/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;

public abstract class A_CmsHtmlWidget
extends A_CmsWidget {
    private CmsHtmlWidgetOption m_htmlWidgetOption;

    public A_CmsHtmlWidget() {
    }

    public A_CmsHtmlWidget(CmsHtmlWidgetOption configuration) {
        this.m_htmlWidgetOption = configuration;
    }

    public A_CmsHtmlWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration() {
        if (super.getConfiguration() != null) {
            return super.getConfiguration();
        }
        return CmsHtmlWidgetOption.createConfigurationString(this.getHtmlWidgetOption());
    }

    public CmsHtmlWidgetOption getHtmlWidgetOption() {
        return this.m_htmlWidgetOption;
    }

    @Override
    public void setConfiguration(String configuration) {
        super.setConfiguration(configuration);
        this.m_htmlWidgetOption = new CmsHtmlWidgetOption(configuration);
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String val = CmsEncoder.decode(values[0], "UTF-8");
            param.setStringValue(cms, val);
        }
    }

    public void setHtmlWidgetOption(CmsHtmlWidgetOption htmlWidgetOption) {
        this.m_htmlWidgetOption = htmlWidgetOption;
    }

    protected String buildOpenCmsButtonRow(I_CmsWidgetDialog widgetDialog, String paramId) {
        StringBuffer result = new StringBuffer(2048);
        boolean buttonsActive = false;
        result.append(this.buildOpenCmsButtonRow(0, widgetDialog));
        if (this.getHtmlWidgetOption().showLinkDialog()) {
            result.append(widgetDialog.button("javascript:setActiveEditor('" + paramId + "');openLinkDialog('" + Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_BUTTON_LINKTO_0") + "');", null, "link", "button.linkto", widgetDialog.getButtonStyle()));
            buttonsActive = true;
        }
        if (this.getHtmlWidgetOption().showAnchorDialog()) {
            result.append(widgetDialog.button("javascript:setActiveEditor('" + paramId + "');openAnchorDialog('" + Messages.get().getBundle(widgetDialog.getLocale()).key("ERR_EDITOR_MESSAGE_NOSELECTION_0") + "');", null, "anchor", "GUI_BUTTON_ANCHOR_0", widgetDialog.getButtonStyle()));
            buttonsActive = true;
        }
        if (!buttonsActive) {
            return "";
        }
        result.append(this.buildOpenCmsButtonRow(1, widgetDialog));
        return result.toString();
    }

    protected String buildOpenCmsButtonRow(int segment, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(256);
        if (segment == 0) {
            result.append(widgetDialog.buttonBarHorizontalLine());
            result.append(widgetDialog.buttonBar(0));
            result.append(widgetDialog.buttonBarStartTab(0, 0));
        } else {
            result.append(widgetDialog.buttonBar(1));
            result.append(widgetDialog.buttonBarHorizontalLine());
        }
        return result.toString();
    }
}

