/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.staticexport.CmsDefaultLinkSubstitutionHandler;
import org.opencms.staticexport.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsAdvancedLinkSubstitutionHandler
extends CmsDefaultLinkSubstitutionHandler {
    private static final String LINK_EXCLUDE_DEFINIFITON_FILE = "/system/shared/linkexcludes";
    private static final Log LOG = CmsLog.getLog(CmsAdvancedLinkSubstitutionHandler.class);
    private static final String XPATH_LINK = "link";

    @Override
    public String getRootPath(CmsObject cms, String targetUri, String basePath) {
        String path;
        URI uri;
        if (cms == null) {
            return targetUri;
        }
        try {
            uri = new URI(targetUri);
            path = uri.getPath();
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_MALFORMED_URI_1", targetUri), (Throwable)e);
            }
            return null;
        }
        if (uri.isOpaque()) {
            return null;
        }
        CmsVfsMemoryObjectCache cache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
        List<String> excludes = (List<String>)cache.getCachedObject(cms, LINK_EXCLUDE_DEFINIFITON_FILE);
        if (excludes == null) {
            excludes = this.readLinkExcludes(cms);
            cache.putCachedObject(cms, LINK_EXCLUDE_DEFINIFITON_FILE, excludes);
        }
        for (int i = 0; i < excludes.size(); ++i) {
            if (!path.startsWith(excludes.get(i))) continue;
            return null;
        }
        return super.getRootPath(cms, targetUri, basePath);
    }

    private List<String> readLinkExcludes(CmsObject cms) {
        ArrayList<String> linkExcludes = new ArrayList<String>();
        try {
            CmsResource res = cms.readResource(LINK_EXCLUDE_DEFINIFITON_FILE);
            CmsFile file = cms.readFile(res);
            CmsXmlContent linkExcludeDefinitions = CmsXmlContentFactory.unmarshal(cms, file);
            int count = linkExcludeDefinitions.getIndexCount(XPATH_LINK, Locale.ENGLISH);
            for (int i = 1; i <= count; ++i) {
                String exclude = linkExcludeDefinitions.getStringValue(cms, "link[" + i + "]", Locale.ENGLISH);
                linkExcludes.add(exclude);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e);
        }
        return linkExcludes;
    }
}

