/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.site.CmsSite;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.site.Messages;
import org.opencms.util.CmsStringUtil;

public final class CmsSiteManagerImpl {
    public static final String SHARED_FOLDER_TITLE = "%SHARED_FOLDER%";
    private static final Log LOG = CmsLog.getLog(CmsSiteManagerImpl.class);
    private static final String SITES_FOLDER = "/sites/";
    private static final int SITES_FOLDER_POS = "/sites/".length() + 1;
    private List<String> m_additionalSiteRoots;
    private List<CmsSiteMatcher> m_aliases;
    private CmsSite m_defaultSite;
    private String m_defaultUri;
    private boolean m_frozen;
    private List<CmsSiteMatcher> m_matchers;
    private String m_sharedFolder;
    private Map<CmsSiteMatcher, CmsSite> m_siteMatcherSites = new HashMap<CmsSiteMatcher, CmsSite>();
    private Set<String> m_siteRoots;
    private Map<String, CmsSite> m_siteRootSites = new HashMap<String, CmsSite>();
    private String m_workplaceServer;
    private CmsSiteMatcher m_workplaceSiteMatcher;

    public CmsSiteManagerImpl() {
        this.m_aliases = new ArrayList<CmsSiteMatcher>();
        this.m_matchers = new ArrayList<CmsSiteMatcher>();
        this.m_additionalSiteRoots = new ArrayList<String>();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_SITE_CONFIG_0"));
        }
    }

    public void addAliasToConfigSite(String alias, String offset) {
        long timeOffset = 0L;
        try {
            timeOffset = Long.parseLong(offset);
        }
        catch (Throwable e) {
            // empty catch block
        }
        CmsSiteMatcher siteMatcher = new CmsSiteMatcher(alias, timeOffset);
        this.m_aliases.add(siteMatcher);
    }

    public void addSite(String server, String uri, String secureServer, String exclusive, String error) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        CmsSiteMatcher matcher2 = new CmsSiteMatcher(server);
        CmsSite site = new CmsSite(uri, matcher2);
        this.addServer(matcher2, site);
        if (CmsStringUtil.isNotEmpty(secureServer)) {
            matcher2 = new CmsSiteMatcher(secureServer);
            site.setSecureServer(matcher2);
            site.setExclusiveUrl(Boolean.valueOf(exclusive));
            site.setExclusiveError(Boolean.valueOf(error));
            this.addServer(matcher2, site);
        }
        site.setAliases(this.m_aliases);
        for (CmsSiteMatcher matcher2 : this.m_aliases) {
            this.addServer(matcher2, site);
        }
        this.m_aliases = new ArrayList<CmsSiteMatcher>();
        this.m_siteRootSites.put(site.getSiteRoot(), site);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_SITE_ROOT_ADDED_1", site.toString()));
        }
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode) {
        return this.getAvailableSites(cms, workplaceMode, cms.getRequestContext().getOuFqn());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, boolean showShared, String ouFqn) {
        String folder;
        ArrayList<String> siteroots = new ArrayList<String>(this.m_siteMatcherSites.size() + 1);
        HashMap<String, CmsSiteMatcher> siteServers = new HashMap<String, CmsSiteMatcher>(this.m_siteMatcherSites.size() + 1);
        ArrayList<CmsSite> result = new ArrayList<CmsSite>(this.m_siteMatcherSites.size() + 1);
        Iterator<CmsSiteMatcher> i = this.m_siteMatcherSites.keySet().iterator();
        while (i.hasNext()) {
            CmsSite site = this.m_siteMatcherSites.get(i.next());
            String folder2 = site.getSiteRoot() + "/";
            if (siteroots.contains(folder2)) continue;
            siteroots.add(folder2);
            siteServers.put(folder2, site.getSiteMatcher());
        }
        if (workplaceMode && this.m_defaultSite != null && !siteroots.contains(folder = this.m_defaultSite.getSiteRoot() + "/")) {
            siteroots.add(folder);
        }
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            List<CmsResource> resources;
            cms.getRequestContext().setSiteRoot("/");
            if (workplaceMode && OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER)) {
                if (!siteroots.contains("/")) {
                    siteroots.add("/");
                }
                if (!siteroots.contains(storedSiteRoot + "/")) {
                    siteroots.add(storedSiteRoot + "/");
                }
            }
            String shared = OpenCms.getSiteManager().getSharedFolder();
            if (showShared && shared != null && !siteroots.contains(shared)) {
                siteroots.add(shared);
            }
            try {
                resources = OpenCms.getOrgUnitManager().getResourcesForOrganizationalUnit(cms, ouFqn);
            }
            catch (CmsException e) {
                List<CmsSite> list = Collections.emptyList();
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                return list;
            }
            Collections.sort(siteroots);
            for (String folder3 : siteroots) {
                boolean compatible = false;
                for (CmsResource resource : resources) {
                    if (!resource.getRootPath().startsWith(folder3) && !folder3.startsWith(resource.getRootPath())) continue;
                    compatible = true;
                    break;
                }
                if (!compatible) continue;
                try {
                    CmsResource res = cms.readResource(folder3);
                    if (workplaceMode && !cms.hasPermissions(res, CmsPermissionSet.ACCESS_VIEW, false, CmsResourceFilter.ONLY_VISIBLE)) continue;
                    String title = cms.readPropertyObject(res, "Title", false).getValue();
                    if (title == null) {
                        title = folder3;
                    }
                    if (shared != null && folder3.equals(shared)) {
                        title = SHARED_FOLDER_TITLE;
                    }
                    String position = cms.readPropertyObject(res, "NavPos", false).getValue();
                    result.add(new CmsSite(folder3, res.getStructureId(), title, (CmsSiteMatcher)siteServers.get(folder3), position));
                }
                catch (CmsException e) {}
            }
            Collections.sort(result, new Comparator<CmsSite>(){

                @Override
                public int compare(CmsSite o1, CmsSite o2) {
                    if (CmsSiteManagerImpl.this.isSharedFolder(o1.getSiteRoot())) {
                        return 1;
                    }
                    if (CmsSiteManagerImpl.this.isSharedFolder(o2.getSiteRoot())) {
                        return -1;
                    }
                    return o1.compareTo(o2);
                }
            });
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_READ_SITE_PROP_FAILED_0"), t);
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
        return result;
    }

    public List<CmsSite> getAvailableSites(CmsObject cms, boolean workplaceMode, String ouFqn) {
        return this.getAvailableSites(cms, workplaceMode, workplaceMode, ouFqn);
    }

    public CmsSite getCurrentSite(CmsObject cms) {
        CmsSite site = this.getSiteForSiteRoot(cms.getRequestContext().getSiteRoot());
        return site == null ? this.m_defaultSite : site;
    }

    public CmsSite getDefaultSite() {
        return this.m_defaultSite;
    }

    public String getDefaultUri() {
        return this.m_defaultUri;
    }

    public String getSharedFolder() {
        return this.m_sharedFolder;
    }

    public CmsSite getSite(String rootPath, String fallbackSiteRoot) {
        CmsSite result = this.getSiteForRootPath(rootPath);
        if (result == null && (result = this.getSiteForSiteRoot(fallbackSiteRoot)) == null) {
            result = this.getDefaultSite();
        }
        return result;
    }

    public CmsSite getSiteForRootPath(String rootPath) {
        CmsSite result;
        if (rootPath.length() > 0 && !rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((result = this.lookupSitesFolder(rootPath)) != null) {
            return result;
        }
        String siteRoot = this.lookupAdditionalSite(rootPath);
        return siteRoot != null ? this.getSiteForSiteRoot(siteRoot) : null;
    }

    public CmsSite getSiteForSiteRoot(String siteRoot) {
        return this.m_siteRootSites.get(siteRoot);
    }

    public String getSiteRoot(String rootPath) {
        CmsSite site;
        if (!rootPath.endsWith("/")) {
            rootPath = rootPath + "/";
        }
        if ((site = this.lookupSitesFolder(rootPath)) != null) {
            return site.getSiteRoot();
        }
        return this.lookupAdditionalSite(rootPath);
    }

    public Set<String> getSiteRoots() {
        return this.m_siteRoots;
    }

    public Map<CmsSiteMatcher, CmsSite> getSites() {
        return this.m_siteMatcherSites;
    }

    public String getWorkplaceServer() {
        return this.m_workplaceServer;
    }

    public CmsSiteMatcher getWorkplaceSiteMatcher() {
        return this.m_workplaceSiteMatcher;
    }

    public void initialize(CmsObject cms) {
        block16: {
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_SITE_ROOTS_CONFIGURED_1", new Integer(this.m_siteMatcherSites.size() + (this.m_defaultUri != null ? 1 : 0))));
            }
            for (CmsSite site : this.m_siteMatcherSites.values()) {
                if (site == null) continue;
                try {
                    cms.readResource(site.getSiteRoot());
                }
                catch (Throwable t) {
                    if (!CmsLog.INIT.isWarnEnabled()) continue;
                    CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_1", site));
                }
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_defaultUri)) {
                this.m_defaultSite = null;
            } else {
                this.m_defaultSite = new CmsSite(this.m_defaultUri, CmsSiteMatcher.DEFAULT_MATCHER);
                try {
                    cms.readResource(this.m_defaultSite.getSiteRoot());
                }
                catch (Throwable t) {
                    if (!CmsLog.INIT.isWarnEnabled()) break block16;
                    CmsLog.INIT.warn((Object)Messages.get().getBundle().key("INIT_NO_ROOT_FOLDER_DEFAULT_SITE_1", this.m_defaultSite));
                }
            }
        }
        if (this.m_defaultSite == null) {
            this.m_defaultSite = new CmsSite("/", CmsSiteMatcher.DEFAULT_MATCHER);
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_defaultSite != null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_1", this.m_defaultSite));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DEFAULT_SITE_ROOT_0"));
            }
        }
        this.m_workplaceSiteMatcher = new CmsSiteMatcher(this.m_workplaceServer);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_workplaceSiteMatcher != null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_1", this.m_workplaceSiteMatcher));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_WORKPLACE_SITE_0"));
            }
        }
        this.m_siteMatcherSites = Collections.unmodifiableMap(this.m_siteMatcherSites);
        this.m_matchers = Collections.unmodifiableList(this.m_matchers);
        this.m_siteRoots = Collections.unmodifiableSet(this.m_siteRootSites.keySet());
        for (String root : this.m_siteRoots) {
            if (root.startsWith(SITES_FOLDER)) continue;
            this.m_additionalSiteRoots.add(root);
        }
        this.m_frozen = true;
    }

    public boolean isMatching(CmsSiteMatcher matcher) {
        boolean result;
        boolean bl = result = this.m_siteMatcherSites.get(matcher) != null;
        if (!result) {
            result = this.m_workplaceSiteMatcher != null && this.m_workplaceSiteMatcher.equals(matcher);
        }
        return result;
    }

    public boolean isMatchingCurrentSite(CmsObject cms, CmsSiteMatcher matcher) {
        return this.m_siteMatcherSites.get(matcher) == this.getCurrentSite(cms);
    }

    public boolean isSharedFolder(String name) {
        return this.m_sharedFolder != null && this.m_sharedFolder.equals(CmsStringUtil.joinPaths("/", name, "/"));
    }

    public boolean isSiteRoot(String rootPath) {
        String siteRoot = this.getSiteRoot(rootPath);
        rootPath = CmsStringUtil.joinPaths(rootPath, "/");
        return rootPath.equals(siteRoot);
    }

    public boolean isWorkplaceRequest(CmsSiteMatcher matcher) {
        return this.m_workplaceSiteMatcher != null && this.m_workplaceSiteMatcher.equals(matcher);
    }

    public boolean isWorkplaceRequest(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        return this.isWorkplaceRequest(this.getRequestMatcher(req));
    }

    public CmsSite matchRequest(HttpServletRequest req) {
        HttpSession session;
        CmsSiteMatcher matcher = this.getRequestMatcher(req);
        if (matcher.getTimeOffset() != 0L && (session = req.getSession()) != null) {
            session.setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(System.currentTimeMillis() + matcher.getTimeOffset()));
        }
        CmsSite site = this.matchSite(matcher);
        if (LOG.isDebugEnabled()) {
            String requestServer = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort();
            LOG.debug((Object)Messages.get().getBundle().key("LOG_MATCHING_REQUEST_TO_SITE_2", requestServer, site.toString()));
        }
        return site;
    }

    public CmsSite matchSite(CmsSiteMatcher matcher) {
        CmsSite site = this.m_siteMatcherSites.get(matcher);
        if (site == null) {
            site = this.m_defaultSite;
        }
        return site;
    }

    public void setDefaultUri(String defaultUri) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_defaultUri = defaultUri;
    }

    public void setSharedFolder(String sharedFolder) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_sharedFolder = CmsStringUtil.joinPaths("/", sharedFolder, "/");
    }

    public void setWorkplaceServer(String workplaceServer) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_workplaceServer = workplaceServer;
    }

    public boolean startsWithShared(String path) {
        return this.m_sharedFolder != null && CmsStringUtil.joinPaths(path, "/").startsWith(this.m_sharedFolder);
    }

    private void addServer(CmsSiteMatcher matcher, CmsSite site) throws CmsConfigurationException {
        if (this.m_siteMatcherSites.containsKey(matcher)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_DUPLICATE_SERVER_NAME_1", matcher.getUrl()));
        }
        this.m_matchers.add(matcher);
        this.m_siteMatcherSites.put(matcher, site);
    }

    private CmsSiteMatcher getRequestMatcher(HttpServletRequest req) {
        CmsSiteMatcher matcher = new CmsSiteMatcher(req.getScheme(), req.getServerName(), req.getServerPort());
        int index = this.m_matchers.indexOf(matcher);
        if (index < 0) {
            return matcher;
        }
        return this.m_matchers.get(index);
    }

    private String lookupAdditionalSite(String rootPath) {
        int size = this.m_additionalSiteRoots.size();
        for (int i = 0; i < size; ++i) {
            String siteRoot = this.m_additionalSiteRoots.get(i);
            if (!rootPath.startsWith(siteRoot)) continue;
            return siteRoot;
        }
        return null;
    }

    private CmsSite lookupSitesFolder(String rootPath) {
        int pos = rootPath.indexOf(47, SITES_FOLDER_POS);
        if (pos > 0) {
            return this.m_siteRootSites.get(rootPath.substring(0, pos));
        }
        return null;
    }
}

