/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSiteMatcher;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public final class CmsSite
implements Cloneable,
Comparable<CmsSite> {
    private static final Log LOG = CmsLog.getLog(CmsSite.class);
    private List<CmsSiteMatcher> m_aliases;
    private boolean m_exclusiveError;
    private boolean m_exclusiveUrl;
    private float m_position;
    private CmsSiteMatcher m_secureServer;
    private CmsSiteMatcher m_siteMatcher;
    private String m_siteRoot;
    private CmsUUID m_siteRootUUID;
    private String m_title;

    public CmsSite(String siteRoot, CmsSiteMatcher siteMatcher) {
        this(siteRoot, CmsUUID.getNullUUID(), siteRoot, siteMatcher, "");
    }

    public CmsSite(String siteRoot, CmsUUID siteRootUUID, String title) {
        this(siteRoot, siteRootUUID, title, CmsSiteMatcher.DEFAULT_MATCHER, "");
    }

    public CmsSite(String siteRoot, CmsUUID siteRootUUID, String title, CmsSiteMatcher siteMatcher, String position) {
        this.setSiteRoot(siteRoot);
        this.setSiteRootUUID(siteRootUUID);
        this.setTitle(title);
        this.setSiteMatcher(siteMatcher);
        this.m_position = Float.MAX_VALUE;
        try {
            this.m_position = Float.parseFloat(position);
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.m_aliases = new ArrayList<CmsSiteMatcher>();
    }

    public Object clone() {
        return new CmsSite(this.getSiteRoot(), (CmsUUID)this.getSiteRootUUID().clone(), this.getTitle(), (CmsSiteMatcher)this.getSiteMatcher().clone(), String.valueOf(this.getPosition()));
    }

    @Override
    public int compareTo(CmsSite that) {
        if (that == this) {
            return 0;
        }
        float thatPos = that.getPosition();
        if (this.m_position == thatPos) {
            if (this.m_position == Float.MAX_VALUE) {
                return this.m_title.compareTo(that.getTitle());
            }
            return 0;
        }
        return this.m_position < thatPos ? -1 : 1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSite) {
            ((CmsSite)obj).m_siteMatcher.equals(this.m_siteMatcher);
        }
        return false;
    }

    public List<CmsSiteMatcher> getAliases() {
        return this.m_aliases;
    }

    public float getPosition() {
        return this.m_position;
    }

    public String getSecureUrl() {
        return this.m_secureServer.getUrl();
    }

    public String getServerPrefix(CmsObject cms, CmsResource resource) {
        boolean secure;
        block4: {
            if (this.equals(OpenCms.getSiteManager().getDefaultSite())) {
                return OpenCms.getSiteManager().getWorkplaceServer();
            }
            secure = false;
            if (this.hasSecureServer()) {
                try {
                    secure = Boolean.valueOf(cms.readPropertyObject(resource, "secure", true).getValue());
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block4;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return secure ? this.getSecureUrl() : this.getUrl();
    }

    public String getServerPrefix(CmsObject cms, String resourceName) {
        boolean secure;
        if (this.equals(OpenCms.getSiteManager().getDefaultSite())) {
            return OpenCms.getSiteManager().getWorkplaceServer();
        }
        if (resourceName.startsWith(cms.getRequestContext().getSiteRoot())) {
            resourceName = resourceName.substring(cms.getRequestContext().getSiteRoot().length());
        }
        return (secure = OpenCms.getStaticExportManager().isSecureLink(cms, resourceName)) ? this.getSecureUrl() : this.getUrl();
    }

    public CmsSiteMatcher getSiteMatcher() {
        return this.m_siteMatcher;
    }

    public String getSitePath(String rootPath) {
        String result = null;
        if (CmsStringUtil.isNotEmpty(rootPath) && rootPath.startsWith(this.m_siteRoot)) {
            result = rootPath.substring(this.m_siteRoot.length());
        }
        return result;
    }

    public String getSiteRoot() {
        return this.m_siteRoot;
    }

    public CmsUUID getSiteRootUUID() {
        return this.m_siteRootUUID;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getUrl() {
        return this.m_siteMatcher.getUrl();
    }

    public int hashCode() {
        return this.m_siteRootUUID.hashCode();
    }

    public boolean hasSecureServer() {
        return this.m_secureServer != null;
    }

    public boolean isExclusiveError() {
        return this.m_exclusiveError;
    }

    public boolean isExclusiveUrl() {
        return this.m_exclusiveUrl;
    }

    public void setExclusiveError(boolean error) {
        this.m_exclusiveError = error;
    }

    public void setExclusiveUrl(boolean exclusive) {
        this.m_exclusiveUrl = exclusive;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append("server: ");
        result.append(this.m_siteMatcher != null ? this.m_siteMatcher.toString() : "null");
        result.append(" uri: ");
        result.append(this.m_siteRoot);
        result.append(" title: ");
        result.append(this.m_title);
        return result.toString();
    }

    protected void addAlias(CmsSiteMatcher aliasServer) {
        this.m_aliases.add(aliasServer);
    }

    protected void setAliases(List<CmsSiteMatcher> aliases) {
        this.m_aliases = aliases;
    }

    protected void setSecureServer(CmsSiteMatcher secureServer) {
        this.m_secureServer = secureServer;
    }

    protected void setSiteMatcher(CmsSiteMatcher siteMatcher) {
        this.m_siteMatcher = siteMatcher;
    }

    protected void setSiteRoot(String siteRoot) {
        this.m_siteRoot = siteRoot.endsWith("/") ? siteRoot.substring(0, siteRoot.length() - 1) : siteRoot;
    }

    protected void setSiteRootUUID(CmsUUID siteRootUUID) {
        this.m_siteRootUUID = siteRootUUID;
    }

    protected void setTitle(String name) {
        this.m_title = name;
    }
}

