/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrQuery
extends SolrQuery {
    public static final String ALL_RETURN_FIELDS = "*,score";
    public static final String DEFAULT_FACET_DATE_GAP = "+1DAY";
    public static final String DEFAULT_QUERY = "*:*";
    public static final String DEFAULT_QUERY_TYPE = "edismax";
    public static final Integer DEFAULT_ROWS = new Integer(10);
    public static final String MINIMUM_FIELDS = "path,type,id";
    public static final String STRUCTURE_FIELDS = "path,type,id,category,contentdate,created,expired,lastmodified,relased,suffix,dependencyType,description,Title_prop,res_locales,con_locales,score,parent-folders";
    private static final long serialVersionUID = -2387357736597627703L;
    private String m_facetDateGap = "+1DAY";
    private Map<String, String[]> m_queryParameters = new HashMap<String, String[]>();
    private List<String> m_textSearchFields = new ArrayList<String>();

    public CmsSolrQuery() {
        this(null, null);
    }

    public CmsSolrQuery(CmsObject cms, Map<String, String[]> queryParams) {
        this.setQuery(DEFAULT_QUERY);
        this.setFields(new String[]{ALL_RETURN_FIELDS});
        this.setQueryType(DEFAULT_QUERY_TYPE);
        this.setRows(DEFAULT_ROWS);
        if (cms != null) {
            this.setLocales(Collections.singletonList(cms.getRequestContext().getLocale()));
            this.setSearchRoots(Collections.singletonList(cms.getRequestContext().getSiteRoot() + "/"));
        }
        if (queryParams != null) {
            this.m_queryParameters = queryParams;
        }
        this.ensureParameters();
        this.ensureReturnFields();
    }

    public static String getResourceType(String[] fqs) {
        String ret = null;
        int count = 0;
        if (fqs != null) {
            for (String fq : fqs) {
                if (!fq.startsWith("type:")) continue;
                String val = fq.substring("type:".length());
                if (!OpenCms.getResourceManager().hasResourceType(val)) continue;
                ++count;
                ret = val;
            }
        }
        return count == 1 ? ret : null;
    }

    public void addFilterQuery(String fieldName, boolean all, List<String> vals) {
        if (this.getFilterQueries() != null) {
            for (String fq : this.getFilterQueries()) {
                if (!fq.startsWith(fieldName + ":")) continue;
                this.removeFilterQuery(fq);
            }
        }
        this.addFilterQuery(new String[]{this.createFilterQuery(fieldName, all, vals)});
    }

    public void addSortFieldOrders(Map<String, SolrQuery.ORDER> sortFields) {
        if (sortFields != null && !sortFields.isEmpty()) {
            for (Map.Entry<String, SolrQuery.ORDER> entry : sortFields.entrySet()) {
                this.addSortField(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setCategories(List<String> categories) {
        if (categories != null && !categories.isEmpty()) {
            this.addFilterQuery("category_exact", true, categories);
        }
    }

    public void setCategories(String ... categories) {
        this.setCategories(Arrays.asList(categories));
    }

    public void setDateRanges(Map<String, CmsPair<Date, Date>> dateRanges) {
        if (dateRanges != null && !dateRanges.isEmpty()) {
            for (Map.Entry<String, CmsPair<Date, Date>> entry : dateRanges.entrySet()) {
                this.removeFacetField(entry.getKey());
            }
            for (Map.Entry<String, CmsPair<Date, Date>> entry : dateRanges.entrySet()) {
                this.addDateRangeFacet(entry.getKey(), entry.getValue().getFirst(), entry.getValue().getSecond(), this.m_facetDateGap);
            }
        }
    }

    public void setFacetDateGap(String facetDateGap) {
        this.m_facetDateGap = facetDateGap;
    }

    public void setLocales(List<Locale> locales) {
        this.m_textSearchFields = new ArrayList<String>();
        if (locales == null || locales.isEmpty()) {
            this.m_textSearchFields.add("text");
            if (this.getFilterQueries() != null) {
                for (String fq : this.getFilterQueries()) {
                    if (!fq.startsWith("con_locales:")) continue;
                    this.removeFilterQuery(fq);
                }
            }
        } else {
            ArrayList<String> localeStrings = new ArrayList<String>();
            for (Locale locale : locales) {
                localeStrings.add(locale.toString());
                this.m_textSearchFields.add("text_" + locale);
            }
            this.addFilterQuery("con_locales", false, localeStrings);
        }
    }

    public void setLocales(Locale ... locales) {
        this.setLocales(Arrays.asList(locales));
    }

    public void setResourceTypes(List<String> resourceTypes) {
        if (resourceTypes != null && !resourceTypes.isEmpty()) {
            this.addFilterQuery("type", false, resourceTypes);
        }
    }

    public void setResourceTypes(String ... resourceTypes) {
        this.setResourceTypes(Arrays.asList(resourceTypes));
    }

    public void setSearchRoots(List<String> searchRoots) {
        if (searchRoots != null && !searchRoots.isEmpty()) {
            this.addFilterQuery("parent-folders", false, searchRoots);
        }
    }

    public void setSearchRoots(String ... searchRoots) {
        this.setSearchRoots(Arrays.asList(searchRoots));
    }

    public void setStructureQuery(boolean structureQuery) {
        if (structureQuery) {
            this.setFields(new String[]{STRUCTURE_FIELDS});
        }
    }

    public void setText(String text) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(text)) {
            this.setQuery(this.createTextQuery(text));
        }
    }

    public void setTextSearchFields(List<String> textSearchFields) {
        this.m_textSearchFields = textSearchFields;
    }

    public void setTextSearchFields(String ... textSearchFields) {
        this.setTextSearchFields(Arrays.asList(textSearchFields));
    }

    public String toString() {
        return CmsEncoder.decode(super.toString());
    }

    protected CmsSolrQuery clone() {
        return new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(this.toString()));
    }

    private String createFilterQuery(String fieldName, boolean all, List<String> vals) {
        String filterQuery = null;
        if (vals != null) {
            if (vals.size() == 1) {
                filterQuery = fieldName + ":" + vals.get(0);
            } else if (vals.size() > 1) {
                filterQuery = fieldName + ":(";
                for (int j = 0; j < vals.size(); ++j) {
                    String val = vals.get(j);
                    filterQuery = filterQuery + val;
                    if (vals.size() <= j + 1) continue;
                    filterQuery = all ? filterQuery + " AND " : filterQuery + " OR ";
                }
                filterQuery = filterQuery + ")";
            }
        }
        return filterQuery;
    }

    private String createTextQuery(String text) {
        if (this.m_textSearchFields.isEmpty()) {
            this.m_textSearchFields.add("text");
        }
        String q = "{!q.op=OR qf=";
        boolean first = true;
        for (String textField : this.m_textSearchFields) {
            if (!first) {
                q = q + " ";
            }
            q = q + textField;
        }
        q = q + "}" + text;
        return q;
    }

    private void ensureParameters() {
        if (this.m_queryParameters != null && !this.m_queryParameters.isEmpty()) {
            for (Map.Entry<String, String[]> entry : this.m_queryParameters.entrySet()) {
                if (!entry.getKey().equals("fq")) {
                    this.setParam(entry.getKey(), entry.getValue());
                    continue;
                }
                this.replaceFilterQueries(entry.getValue());
            }
        }
    }

    private void ensureReturnFields() {
        String[] fl = this.getParams("fl");
        if (fl != null && fl.length > 0) {
            ArrayList<String> result = new ArrayList<String>();
            for (String field : fl) {
                String commasep = field.replaceAll(" ", ",");
                List<String> list = CmsStringUtil.splitAsList(commasep, ',');
                if (!list.contains("*")) {
                    for (String reqField : CmsStringUtil.splitAsList(MINIMUM_FIELDS, ",")) {
                        if (list.contains(reqField)) continue;
                        list.add(reqField);
                    }
                }
                result.addAll(list);
            }
            this.setParam("fl", new String[]{CmsStringUtil.arrayAsString(result.toArray(new String[0]), ",")});
        }
    }

    private void replaceFilterQueries(String[] fqs) {
        for (String fq : fqs) {
            int idx = fq.indexOf(58);
            if (idx == -1) continue;
            String fieldName = fq.substring(0, idx);
            if (this.getFilterQueries() == null) continue;
            for (String sfq : this.getFilterQueries()) {
                if (!sfq.startsWith(fieldName + ":")) continue;
                this.removeFilterQuery(sfq);
            }
        }
        this.addFilterQuery(fqs);
    }
}

