/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.CmsDocumentDependency;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;
import org.opencms.search.fields.I_CmsSearchFieldMapping;
import org.opencms.search.solr.CmsSolrDocument;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.search.solr.Messages;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.I_CmsXmlContentHandler;

public class CmsSolrFieldConfiguration
extends CmsSearchFieldConfiguration {
    private static final Log LOG = CmsLog.getLog(CmsSolrFieldConfiguration.class);
    private List<Locale> m_contentLocales;
    private Map<String, CmsSolrField> m_solrFields = new HashMap<String, CmsSolrField>();

    public Map<String, CmsSolrField> getSolrFields() {
        return Collections.unmodifiableMap(this.m_solrFields);
    }

    @Override
    public void init() {
        this.addContentFields();
        this.addLuceneFields();
    }

    protected void addAdditionalFields(List<CmsSolrField> additionalFields) {
        if (additionalFields != null) {
            for (CmsSolrField solrField : additionalFields) {
                this.m_solrFields.put(solrField.getName(), solrField);
            }
        }
    }

    @Override
    protected I_CmsSearchDocument appendDates(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        document.addDateField("created", resource.getDateCreated(), false);
        document.addDateField("lastmodified", resource.getDateLastModified(), false);
        document.addDateField("contentdate", resource.getDateContent(), false);
        document.addDateField("relased", resource.getDateReleased(), false);
        document.addDateField("expired", resource.getDateExpired(), false);
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMapping(I_CmsSearchDocument document, CmsSearchField sfield, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        CmsSolrField field = (CmsSolrField)sfield;
        try {
            StringBuffer text = new StringBuffer();
            for (I_CmsSearchFieldMapping mapping : field.getMappings()) {
                if (extractionResult == null) continue;
                String mapResult = null;
                if (field.getLocale() != null && mapping.getType().equals(CmsSearchFieldMappingType.CONTENT)) {
                    String key = CmsSearchFieldConfiguration.getLocaleExtendedName("content", field.getLocale());
                    mapResult = extractionResult.getContentItems().get(key);
                    if (mapResult == null && !CmsResourceTypeXmlContent.isXmlContent(resource) && !CmsResourceTypeXmlPage.isXmlPage(resource) && this.m_contentLocales != null && this.m_contentLocales.contains(field.getLocale())) {
                        mapResult = extractionResult.getContent();
                    }
                } else {
                    mapResult = mapping.getStringValue(cms, resource, extractionResult, properties, propertiesSearched);
                }
                if (mapResult != null) {
                    if (text.length() > 0) {
                        text.append('\n');
                    }
                    text.append(mapResult);
                    continue;
                }
                if (mapping.getDefaultValue() == null) continue;
                text.append("\n" + mapping.getDefaultValue());
            }
            if (text.length() <= 0 && field.getDefaultValue() != null) {
                text.append(field.getDefaultValue());
            }
            if (text.length() > 0) {
                document.addSearchField(field, text.toString());
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        Set<CmsSearchField> mappedFields = this.getXSDMappings(cms, resource);
        if (mappedFields != null) {
            for (CmsSearchField cmsSearchField : mappedFields) {
                document = this.appendFieldMapping(document, cmsSearchField, cms, resource, extractionResult, properties, propertiesSearched);
            }
        }
        for (CmsSolrField cmsSolrField : this.m_solrFields.values()) {
            document = this.appendFieldMapping(document, cmsSolrField, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendLocales(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        List<String> itemLocales = null;
        ArrayList<Locale> resourceLocales = new ArrayList();
        if (extraction != null && extraction.getContentItems() != null && extraction.getContentItems().get("res_locales") != null) {
            String localesAsString = extraction.getContentItems().get("res_locales");
            itemLocales = CmsStringUtil.splitAsList(localesAsString, ' ');
            for (String locale : itemLocales) {
                resourceLocales.add(new Locale(locale));
            }
        } else {
            resourceLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        }
        document.addResourceLocales(resourceLocales);
        this.m_contentLocales = new ArrayList<Locale>();
        this.m_contentLocales = itemLocales != null ? resourceLocales : this.getContentLocales(cms, resource, extraction);
        document.addContentLocales(this.m_contentLocales);
        if (this.hasLocaleDependencies()) {
            CmsDocumentDependency dep = CmsDocumentDependency.load(cms, resource);
            ((CmsSolrDocument)document).addDocumentDependency(cms, dep);
        }
        return document;
    }

    @Override
    protected I_CmsSearchDocument appendProperties(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsProperty prop : propertiesSearched) {
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) continue;
            document.addSearchField(new CmsSolrField(prop.getName() + "_prop", null, null, null, 1.0f), prop.getValue());
        }
        return document;
    }

    protected List<Locale> getContentLocales(CmsObject cms, CmsResource resource, I_CmsExtractionResult extraction) {
        Locale detectedLocale = CmsStringUtil.getLocaleForName(resource.getRootPath());
        if (this.getIndex().isLanguageDetection() && detectedLocale == null && extraction != null && extraction.getContent() != null) {
            detectedLocale = CmsStringUtil.getLocaleForText(extraction.getContent());
        }
        ArrayList<Locale> result = new ArrayList<Locale>();
        if (detectedLocale != null) {
            result.add(detectedLocale);
        } else {
            result.add(OpenCms.getLocaleManager().getDefaultLocales(cms, resource).get(0));
            LOG.debug((Object)Messages.get().getBundle().key("LOG_LANGUAGE_DETECTION_FAILED_1", resource));
        }
        return result;
    }

    protected Set<CmsSearchField> getXSDMappings(CmsObject cms, CmsResource resource) {
        try {
            I_CmsXmlContentHandler handler;
            if (CmsResourceTypeXmlContent.isXmlContent(resource) && (handler = CmsXmlContentDefinition.getContentHandlerForResource(cms, resource)) != null && !handler.getSearchFields().isEmpty()) {
                return handler.getSearchFields();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private void addContentFields() {
        CmsSolrField solrField = new CmsSolrField("content", null, null, null, 1.0f);
        solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
        this.m_solrFields.put(solrField.getName(), solrField);
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            solrField = new CmsSolrField(CmsSearchFieldConfiguration.getLocaleExtendedName("content", locale), Collections.singletonList(locale.toString() + "_excerpt"), locale, null, 1.0f);
            solrField.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, "content"));
            this.m_solrFields.put(solrField.getName(), solrField);
        }
    }

    private void addLuceneFields() {
        for (CmsSearchField field : super.getFields()) {
            if (!(field instanceof CmsLuceneField)) continue;
            CmsSolrField solrField = new CmsSolrField((CmsLuceneField)field);
            this.m_solrFields.put(solrField.getName(), solrField);
        }
    }

    private boolean hasLocaleDependencies() {
        for (CmsSearchIndexSource source : this.getIndex().getSources()) {
            if (!source.getIndexer().isLocaleDependenciesEnable()) continue;
            return true;
        }
        return false;
    }
}

