/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.ArrayList;
import org.opencms.search.galleries.CmsGallerySearchResult;

public class CmsGallerySearchResultList
extends ArrayList<CmsGallerySearchResult> {
    private static final long serialVersionUID = 115646669707330088L;
    private int m_hitCount;
    private int m_pageCount;
    private int m_pageIndex;

    public CmsGallerySearchResultList() {
        this(100);
    }

    public CmsGallerySearchResultList(int initialCapacity) {
        super(initialCapacity);
    }

    public void append(CmsGallerySearchResultList moreResults) {
        this.addAll(moreResults);
        this.m_hitCount = moreResults.getHitCount();
    }

    public int getHitCount() {
        return this.m_hitCount;
    }

    public int getPageCount() {
        return this.m_pageCount;
    }

    public int getResultPage() {
        return this.m_pageIndex;
    }

    public void setHitCount(int hitCount) {
        this.m_hitCount = hitCount;
    }

    protected void calculatePages(int pageIndex, int matchesPerPage) {
        this.m_pageIndex = pageIndex;
        this.m_pageCount = this.m_hitCount / matchesPerPage;
        if (this.m_hitCount % matchesPerPage != 0) {
            ++this.m_pageCount;
        }
    }
}

