/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsLuceneFieldConfiguration;

public class CmsTermHighlighterHtml
implements I_CmsTermHighlighter {
    private static final String EXCERPT_FRAGMENT_SEPARATOR = " ... ";
    private static final int EXCERPT_REQUIRED_FRAGMENTS = 5;

    @Override
    public String getExcerpt(Document doc, CmsSearchIndex index, CmsSearchParameters params, Query query, Analyzer analyzer) throws IOException, InvalidTokenOffsetsException {
        if (doc == null || index == null || params == null || analyzer == null || query == null) {
            return null;
        }
        if (!(index.getFieldConfiguration() instanceof CmsLuceneFieldConfiguration)) {
            return null;
        }
        Highlighter highlighter = null;
        CmsLuceneFieldConfiguration conf = (CmsLuceneFieldConfiguration)index.getFieldConfiguration();
        Iterator<String> excerptFieldNames = conf.getExcerptFieldNames().iterator();
        StringBuffer excerptBuffer = new StringBuffer();
        while (excerptFieldNames.hasNext()) {
            String fieldName = excerptFieldNames.next();
            boolean createExcerpt = !params.isExcerptOnlySearchedFields() || params.getFields().contains(fieldName);
            if (!createExcerpt || doc.getFieldable(fieldName) == null) continue;
            String text = doc.getFieldable(fieldName).stringValue();
            text = CmsEncoder.escapeXml(text);
            TokenStream stream = analyzer.tokenStream(fieldName, (Reader)new StringReader(text));
            if (params.isExcerptOnlySearchedFields()) {
                highlighter = new Highlighter((Scorer)new QueryTermScorer(query, fieldName));
            } else if (highlighter == null) {
                highlighter = new Highlighter((Scorer)new QueryTermScorer(query));
            }
            String fragment = highlighter.getBestFragments(stream, text, 5, EXCERPT_FRAGMENT_SEPARATOR);
            fragment = fragment.replace('\t', ' ');
            fragment = fragment.replace('\n', ' ');
            fragment = fragment.replace('\r', ' ');
            fragment = fragment.replace('\f', ' ');
            if (excerptBuffer.length() > 0) {
                excerptBuffer.append(EXCERPT_FRAGMENT_SEPARATOR);
            }
            excerptBuffer.append(fragment);
        }
        String result = null;
        if (excerptBuffer.length() > 0) {
            result = excerptBuffer.toString();
        }
        int maxLength = OpenCms.getSearchManager().getMaxExcerptLength();
        if (result != null && result.length() > maxLength) {
            result = result.substring(0, maxLength);
        }
        return result;
    }
}

