/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsDiskCache;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsFileUtil;

public class CmsExtractionResultCache {
    private static final Log LOG = CmsLog.getLog(CmsExtractionResultCache.class);
    private String m_rfsRepository;

    public CmsExtractionResultCache(String basepath, String foldername) {
        this.m_rfsRepository = CmsFileUtil.normalizePath(basepath + foldername + File.separatorChar);
    }

    public synchronized int cleanCache(float maxAge) {
        File[] files;
        long expireDate = System.currentTimeMillis() - (long)(maxAge * 60.0f * 60.0f * 1000.0f);
        File basedir = new File(this.m_rfsRepository);
        int count = 0;
        if (basedir.canRead() && basedir.isDirectory() && (files = basedir.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                if (!f.canWrite() || f.lastModified() >= expireDate) continue;
                try {
                    f.delete();
                    ++count;
                    continue;
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) continue;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_EXCERPT_CACHE_DELETE_ERROR_1", f.getAbsolutePath()), (Throwable)e);
                }
            }
        }
        return count;
    }

    public String getCacheName(CmsResource resource, Locale locale, String docTypeName) {
        StringBuffer buf = new StringBuffer(this.m_rfsRepository.length() + 36);
        buf.append(this.m_rfsRepository);
        buf.append('/');
        buf.append(resource.getResourceId().toString());
        if (docTypeName != null) {
            buf.append('_');
            buf.append(docTypeName);
        }
        if (locale != null) {
            buf.append('_');
            buf.append(locale.toString());
        }
        buf.append('_');
        buf.append(resource.getDateContent());
        buf.append(".ext");
        return buf.toString();
    }

    public CmsExtractionResult getCacheObject(String rfsName) {
        try {
            File f = new File(rfsName);
            if (f.exists()) {
                long age = f.lastModified();
                if (System.currentTimeMillis() - age > 3600000L) {
                    f.setLastModified(System.currentTimeMillis());
                }
                byte[] byteContent = CmsFileUtil.readFile(f);
                return CmsExtractionResult.fromBytes(byteContent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public String getRepositoryPath() {
        return this.m_rfsRepository;
    }

    public void saveCacheObject(String rfsName, I_CmsExtractionResult content) throws IOException {
        byte[] byteContent = content.getBytes();
        if (byteContent != null) {
            CmsVfsDiskCache.saveFile(rfsName, byteContent);
        }
    }
}

