/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.documents;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.A_CmsVfsDocument;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsDocumentXmlContent
extends A_CmsVfsDocument {
    public CmsDocumentXmlContent(String name) {
        super(name);
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        CmsXmlContentDefinition def = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
        if (def.getContentHandler().isContainerPageOnly()) {
            return null;
        }
        return super.createDocument(cms, resource, index);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
            I_CmsXmlContentHandler handler = xmlContent.getHandler();
            Locale locale = index.getLocaleForResource(cms, resource, xmlContent.getLocales());
            List<String> elements = xmlContent.getNames(locale);
            StringBuffer content = new StringBuffer();
            HashMap<String, String> items = new HashMap<String, String>();
            for (String xpath : elements) {
                String extracted;
                I_CmsXmlContentValue value = xmlContent.getValue(xpath, locale);
                if (!handler.isSearchable(value) || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(extracted = value.getPlainText(cms))) continue;
                items.put(xpath, extracted);
                content.append(extracted);
                content.append('\n');
            }
            return new CmsExtractionResult(content.toString(), items);
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public List<String> getDocumentKeys(List<String> resourceTypes, List<String> mimeTypes) throws CmsException {
        if (resourceTypes.contains("*")) {
            ArrayList<String> allTypes = new ArrayList<String>();
            for (I_CmsResourceType resourceType : OpenCms.getResourceManager().getResourceTypes()) {
                if (!(resourceType instanceof CmsResourceTypeXmlContent) || !((CmsResourceTypeXmlContent)resourceType).getConfiguration().containsKey("schema") && CmsResourceTypeXmlContent.class.equals(resourceType.getClass())) continue;
                allTypes.add(resourceType.getTypeName());
            }
            resourceTypes = allTypes;
        }
        return super.getDocumentKeys(resourceTypes, mimeTypes);
    }

    @Override
    public boolean isLocaleDependend() {
        return true;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }
}

