/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Sort;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.CmsSearchResultList;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearch {
    private static final Log LOG = CmsLog.getLog(CmsSearch.class);
    protected Map<String, Integer> m_categoriesFound;
    protected transient CmsObject m_cms;
    protected Exception m_lastException;
    protected String m_nextUrl;
    protected int m_pageCount;
    protected CmsSearchParameters m_parameterRestriction;
    protected CmsSearchParameters m_parameters = new CmsSearchParameters();
    protected String m_prevUrl;
    protected List<CmsSearchResult> m_result;
    protected String m_searchParameters;
    protected int m_searchResultCount;
    private boolean m_parsedQuerySet;

    public CmsSearch() {
        this.m_parameters.setSearchRoots("");
        this.m_parameters.setSearchPage(1);
        this.m_searchResultCount = 0;
        this.m_parameters.setSort(CmsSearchParameters.SORT_DEFAULT);
        this.m_parameters.setFields(Arrays.asList(CmsSearchIndex.DOC_META_FIELDS));
        this.m_parsedQuerySet = false;
    }

    public void addFieldQuery(CmsSearchParameters.CmsSearchFieldQuery fieldQuery) {
        this.m_parameters.addFieldQuery(fieldQuery);
        this.resetLastResult();
    }

    public void addFieldQuery(String fieldName, String searchQuery, BooleanClause.Occur occur) {
        this.addFieldQuery(new CmsSearchParameters.CmsSearchFieldQuery(fieldName, searchQuery, occur));
    }

    public void addFieldQueryMust(String fieldName, String searchQuery) {
        this.addFieldQuery(fieldName, searchQuery, BooleanClause.Occur.MUST);
    }

    public void addFieldQueryMustNot(String fieldName, String searchQuery) {
        this.addFieldQuery(fieldName, searchQuery, BooleanClause.Occur.MUST_NOT);
    }

    public void addFieldQueryShould(String fieldName, String searchQuery) {
        this.addFieldQuery(fieldName, searchQuery, BooleanClause.Occur.SHOULD);
    }

    public boolean getCalculateCategories() {
        return this.m_parameters.getCalculateCategories();
    }

    public String[] getCategories() {
        List<String> l = this.m_parameters.getCategories();
        return l.toArray(new String[l.size()]);
    }

    public int getDisplayPages() {
        return this.m_parameters.getDisplayPages();
    }

    public String getFields() {
        if (this.m_parameters.getFields() == null) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator<String> it = this.m_parameters.getFields().iterator();
        while (it.hasNext()) {
            result.append(it.next());
            result.append(" ");
        }
        return result.toString();
    }

    public String getIndex() {
        return this.m_parameters.getSearchIndex().getName();
    }

    public Exception getLastException() {
        return this.m_lastException;
    }

    public int getMatchesPerPage() {
        return this.m_parameters.getMatchesPerPage();
    }

    public long getMaxDateCreated() {
        return this.m_parameters.getMaxDateCreated();
    }

    public long getMaxDateLastModified() {
        return this.m_parameters.getMaxDateLastModified();
    }

    public long getMinDateCreated() {
        return this.m_parameters.getMinDateCreated();
    }

    public long getMinDateLastModified() {
        return this.m_parameters.getMinDateLastModified();
    }

    public String getNextUrl() {
        return this.m_nextUrl;
    }

    public Map<Integer, String> getPageLinks() {
        int endIndex;
        int startIndex;
        TreeMap<Integer, String> links = new TreeMap<Integer, String>();
        if (this.m_pageCount <= 1) {
            return links;
        }
        String link = this.m_cms.getRequestContext().getUri() + this.m_parameters.toQueryString() + "&searchPage=";
        if (this.getDisplayPages() < 1) {
            startIndex = 1;
            endIndex = this.m_pageCount;
        } else {
            int countBeforeCurrent;
            int currentPage = this.getSearchPage();
            if (currentPage - (countBeforeCurrent = this.getDisplayPages() / 2) < 1) {
                countBeforeCurrent = currentPage - 1;
            }
            int countAfterCurrent = this.getDisplayPages() - countBeforeCurrent - 1;
            startIndex = currentPage - countBeforeCurrent;
            endIndex = currentPage + countAfterCurrent;
            if (endIndex > this.m_pageCount) {
                int delta = endIndex - this.m_pageCount;
                if ((startIndex -= delta) < 1) {
                    startIndex = 1;
                }
                endIndex = this.m_pageCount;
            }
        }
        for (int i = startIndex; i <= endIndex; ++i) {
            links.put(new Integer(i), link + i);
        }
        return links;
    }

    public CmsSearchParameters getParameters() {
        if (this.m_parameterRestriction != null) {
            this.m_parameters = this.m_parameters.restrict(this.m_parameterRestriction);
        }
        return this.m_parameters;
    }

    public String getParsedQuery() {
        return this.m_parameters.getParsedQuery();
    }

    public String getPreviousUrl() {
        return this.m_prevUrl;
    }

    public String getQuery() {
        return this.m_parameters.getQuery();
    }

    public int getQueryLength() {
        return this.m_parameters.getQueryLength();
    }

    public int getSearchPage() {
        return this.m_parameters.getSearchPage();
    }

    public List<CmsSearchResult> getSearchResult() {
        if (this.m_cms != null && this.m_result == null && this.m_parameters.getIndex() != null && (this.m_parameters.isIgnoreQuery() || CmsStringUtil.isNotEmpty(this.m_parameters.getQuery()) || CmsStringUtil.isNotEmpty(this.m_parameters.getParsedQuery()) || this.m_parameters.getFieldQueries() != null)) {
            if (!this.m_parameters.isIgnoreQuery() && CmsStringUtil.isEmpty(this.m_parameters.getParsedQuery()) && this.getQueryLength() > 0) {
                if (this.m_parameters.getFieldQueries() != null) {
                    for (CmsSearchParameters.CmsSearchFieldQuery fq : this.m_parameters.getFieldQueries()) {
                        for (String keyword : fq.getSearchTerms()) {
                            if (!CmsStringUtil.isEmpty(keyword) && keyword.trim().length() >= this.getQueryLength()) continue;
                            this.m_lastException = new CmsSearchException(Messages.get().container("ERR_QUERY_TOO_SHORT_1", new Integer(this.getQueryLength())));
                            return null;
                        }
                    }
                } else if (this.m_parameters.getQuery().trim().length() < this.getQueryLength()) {
                    this.m_lastException = new CmsSearchException(Messages.get().container("ERR_QUERY_TOO_SHORT_1", new Integer(this.getQueryLength())));
                    return null;
                }
            }
            try {
                CmsSearchResultList result = this.m_parameters.getSearchIndex().search(this.m_cms, this.getParameters());
                if (result.size() > 0) {
                    this.m_result = result;
                    this.m_searchResultCount = result.getHitCount();
                    this.m_categoriesFound = result.getCategories();
                    this.m_pageCount = this.m_searchResultCount / this.m_parameters.getMatchesPerPage();
                    if (this.m_searchResultCount % this.m_parameters.getMatchesPerPage() != 0) {
                        ++this.m_pageCount;
                    }
                    String url = this.m_cms.getRequestContext().getUri() + this.m_parameters.toQueryString() + "&searchPage=";
                    if (this.m_parameters.getSearchPage() > 1) {
                        this.m_prevUrl = url + (this.m_parameters.getSearchPage() - 1);
                    }
                    if (this.m_parameters.getSearchPage() < this.m_pageCount) {
                        this.m_nextUrl = url + (this.m_parameters.getSearchPage() + 1);
                    }
                } else {
                    this.m_result = Collections.emptyList();
                    this.m_searchResultCount = 0;
                    this.m_categoriesFound = null;
                    this.m_pageCount = 0;
                    this.m_prevUrl = null;
                    this.m_nextUrl = null;
                }
            }
            catch (Exception exc) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_SEARCHING_FAILED_0"), (Throwable)exc);
                }
                this.m_result = null;
                this.m_searchResultCount = 0;
                this.m_pageCount = 0;
                this.m_lastException = exc;
            }
        }
        return this.m_result;
    }

    public Map<String, Integer> getSearchResultCategories() {
        return this.m_categoriesFound;
    }

    public int getSearchResultCount() {
        return this.m_searchResultCount;
    }

    public String[] getSearchRoots() {
        List<String> l = this.m_parameters.getRoots();
        return l.toArray(new String[l.size()]);
    }

    public Sort getSortOrder() {
        return this.m_parameters.getSort();
    }

    public void init(CmsObject cms) {
        this.m_cms = cms;
        this.m_result = null;
        this.m_lastException = null;
        this.m_pageCount = 0;
        this.m_nextUrl = null;
        this.m_prevUrl = null;
    }

    public void setCalculateCategories(boolean calculateCategories) {
        this.m_parameters.setCalculateCategories(calculateCategories);
    }

    public void setCategories(String[] categories) {
        ArrayList<String> setCategories = new ArrayList<String>();
        if (categories != null && categories.length != 0) {
            for (int i = 0; i < categories.length; ++i) {
                String cat = categories[i];
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(cat)) continue;
                cat = cat.trim().toLowerCase();
                setCategories.add(cat);
            }
        }
        this.m_parameters.setCategories(setCategories);
        this.resetLastResult();
    }

    public void setDisplayPages(int value) {
        this.m_parameters.setDisplayPages(value);
    }

    public void setExcerptOnlySearchedFields(boolean value) {
        this.m_parameters.setExcerptOnlySearchedFields(value);
        this.resetLastResult();
    }

    public void setField(String[] fields) {
        this.m_parameters.setFields(Arrays.asList(fields));
        this.resetLastResult();
    }

    public void setIndex(String indexName) {
        this.resetLastResult();
        if (CmsStringUtil.isNotEmpty(indexName)) {
            try {
                CmsSearchIndex index = OpenCms.getSearchManager().getIndex(indexName);
                if (index == null) {
                    throw new CmsException(Messages.get().container("ERR_INDEX_NOT_FOUND_1", indexName));
                }
                this.m_parameters.setSearchIndex(index);
            }
            catch (Exception exc) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_INDEX_ACCESS_FAILED_1", indexName), (Throwable)exc);
                }
                this.m_lastException = exc;
            }
        }
    }

    public void setMatchesPerPage(int matches) {
        this.m_parameters.setMatchesPerPage(matches);
        this.resetLastResult();
    }

    public void setMaxDateCreated(String maxDateCreated) {
        this.m_parameters.setMaxDateCreated(CmsStringUtil.getLongValue(maxDateCreated, Long.MAX_VALUE, "maxDateCreated"));
    }

    public void setMaxDateLastModified(String maxDateLastModified) {
        this.m_parameters.setMaxDateLastModified(CmsStringUtil.getLongValue(maxDateLastModified, Long.MAX_VALUE, "maxDateLastModified"));
    }

    public void setMinDateCreated(String minDateCreated) {
        this.m_parameters.setMinDateCreated(CmsStringUtil.getLongValue(minDateCreated, Long.MIN_VALUE, "minDateCreated"));
    }

    public void setMinDateLastModified(String minDateLastModified) {
        this.m_parameters.setMinDateLastModified(CmsStringUtil.getLongValue(minDateLastModified, Long.MIN_VALUE, "minDateLastModified"));
    }

    public void setParameters(CmsSearchParameters parameters) {
        if (parameters != null) {
            this.m_parameters = parameters;
        }
    }

    public void setParsedQuery(String parsedQuery) {
        try {
            this.m_parsedQuerySet = true;
            this.m_parameters.setParsedQuery(CmsEncoder.decodeParameter(parsedQuery));
        }
        catch (CmsIllegalArgumentException iae) {
            this.m_lastException = iae;
        }
    }

    public void setQuery(String query) {
        try {
            this.m_parameters.setQuery(CmsEncoder.decodeParameter(query));
        }
        catch (CmsIllegalArgumentException iae) {
            this.m_lastException = iae;
        }
        this.resetLastResult();
    }

    public void setQueryLength(int length) {
        this.m_parameters.setQueryLength(length);
    }

    public void setResourceType(String resourceType) {
        this.setResourceTypes(new String[]{resourceType});
    }

    public void setResourceTypes(String[] resourceTypes) {
        if (resourceTypes != null) {
            this.m_parameters.setResourceTypes(Arrays.asList(resourceTypes));
        } else {
            this.m_parameters.setResourceTypes(null);
        }
        this.resetLastResult();
    }

    public void setResultRestriction(CmsSearchParameters restriction) {
        this.resetLastResult();
        this.m_parameterRestriction = restriction;
    }

    public void setSearchPage(int page) {
        this.m_parameters.setSearchPage(page);
        this.resetLastResult();
    }

    public void setSearchRoot(String searchRoot) {
        this.setSearchRoots(CmsStringUtil.splitAsArray(searchRoot, ","));
    }

    public void setSearchRoots(String[] searchRoots) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(searchRoots));
        this.m_parameters.setRoots(l);
        this.resetLastResult();
    }

    public void setSortOrder(Sort sortOrder) {
        this.m_parameters.setSort(sortOrder);
        this.resetLastResult();
    }

    private void resetLastResult() {
        this.m_result = null;
        this.m_lastException = null;
        this.m_categoriesFound = null;
        this.m_parameterRestriction = null;
        if (!this.m_parsedQuerySet) {
            this.m_parameters.setParsedQuery(null);
        }
    }
}

