/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;

public class CmsLuceneDocument
implements I_CmsSearchDocument {
    private Document m_doc;
    private float m_score;

    public CmsLuceneDocument(Document doc) {
        this.m_doc = doc;
    }

    public static String getDateTerms(long date) {
        Calendar cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
        cal.setTimeInMillis(date);
        String day = CmsSearchIndex.DATES[cal.get(5)];
        String month = CmsSearchIndex.DATES[cal.get(2) + 1];
        String year = String.valueOf(cal.get(1));
        StringBuffer result = new StringBuffer();
        result.append(year);
        result.append(month);
        result.append(day);
        result.append(' ');
        result.append(year);
        result.append(month);
        result.append(' ');
        result.append(year);
        return result.toString();
    }

    @Override
    public void addCategoryField(List<CmsCategory> categories) {
        if (categories != null && categories.size() > 0) {
            StringBuffer categoryBuffer = new StringBuffer(128);
            for (CmsCategory category : categories) {
                categoryBuffer.append(category.getPath());
                categoryBuffer.append(' ');
            }
            if (categoryBuffer.length() > 0) {
                Field field = new Field("category", categoryBuffer.toString().toLowerCase(), Field.Store.YES, Field.Index.ANALYZED);
                field.setBoost(0.0f);
                this.m_doc.add((Fieldable)field);
            }
        } else {
            Field field = new Field("category", "unknown", Field.Store.YES, Field.Index.ANALYZED);
            this.m_doc.add((Fieldable)field);
        }
    }

    @Override
    public void addContentField(byte[] data) {
        Field field = new Field("contentblob", data);
        this.m_doc.add((Fieldable)field);
    }

    @Override
    public void addContentLocales(List<Locale> locales) {
    }

    @Override
    public void addDateField(String name, long date, boolean analyzed) {
        Field field = new Field(name, DateTools.dateToString((Date)new Date(date), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED);
        field.setBoost(0.0f);
        this.m_doc.add((Fieldable)field);
        if (analyzed) {
            field = new Field(name + "_lookup", CmsLuceneDocument.getDateTerms(date), Field.Store.NO, Field.Index.ANALYZED);
            this.m_doc.add((Fieldable)field);
        }
    }

    @Override
    public void addFileSizeField(int length) {
    }

    @Override
    public void addPathField(String rootPath) {
        String parentFolders = CmsSearchFieldConfiguration.getParentFolderTokens(rootPath);
        Field field = new Field("parent-folders", parentFolders, Field.Store.NO, Field.Index.ANALYZED);
        field.setBoost(0.0f);
        this.m_doc.add((Fieldable)field);
    }

    @Override
    public void addResourceLocales(List<Locale> locales) {
    }

    @Override
    public void addRootPathField(String rootPath) {
        this.m_doc.add((Fieldable)new Field("path", rootPath, Field.Store.YES, Field.Index.NOT_ANALYZED));
    }

    @Override
    public void addSearchField(CmsSearchField field, String value) {
        if (field instanceof CmsLuceneField) {
            this.m_doc.add((Fieldable)((CmsLuceneField)field).createField(value));
        } else {
            new CmsRuntimeException(Messages.get().container("LOG_INVALID_FIELD_CLASS_1", field.getClass().getName()));
        }
    }

    @Override
    public void addSuffixField(String suffix) {
        this.m_doc.add((Fieldable)new Field("suffix", suffix, Field.Store.YES, Field.Index.NOT_ANALYZED));
    }

    @Override
    public void addTypeField(String typeName) {
        this.m_doc.add((Fieldable)new Field("type", typeName, Field.Store.YES, Field.Index.NOT_ANALYZED));
    }

    @Override
    public byte[] getContentBlob() {
        Fieldable fieldContentBlob = this.m_doc.getFieldable("contentblob");
        if (fieldContentBlob != null) {
            return fieldContentBlob.getBinaryValue();
        }
        return null;
    }

    @Override
    public Object getDocument() {
        return this.m_doc;
    }

    @Override
    public List<String> getFieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Fieldable field : this.m_doc.getFields()) {
            result.add(field.name());
        }
        return result;
    }

    @Override
    public Date getFieldValueAsDate(String fieldName) {
        String contentDate = this.getFieldValueAsString(fieldName);
        if (contentDate != null) {
            try {
                return new Date(DateTools.stringToTime((String)contentDate));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getFieldValueAsString(String fieldName) {
        Fieldable fieldValue = this.m_doc.getFieldable(fieldName);
        if (fieldValue != null) {
            return fieldValue.stringValue();
        }
        return null;
    }

    @Override
    public List<String> getMultivaluedFieldAsStringList(String fieldName) {
        return Collections.singletonList(this.getFieldValueAsString(fieldName));
    }

    @Override
    public String getPath() {
        return this.getFieldValueAsString("path");
    }

    @Override
    public float getScore() {
        return this.m_score;
    }

    @Override
    public String getType() {
        return this.getFieldValueAsString("type");
    }

    @Override
    public void setBoost(float boost) {
        this.m_doc.setBoost(boost);
    }

    @Override
    public void setScore(float score) {
        this.m_score = score;
    }
}

