/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsIndexingThreadManager;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchIndexSource;
import org.opencms.search.CmsSearchIndexUpdateData;
import org.opencms.search.CmsVfsIndexer;
import org.opencms.search.I_CmsIndexWriter;
import org.opencms.search.I_CmsIndexer;
import org.opencms.search.Messages;
import org.opencms.search.documents.CmsDocumentDependency;

public class CmsDependencyIndexer
extends CmsVfsIndexer {
    private static final Log LOG = CmsLog.getLog(CmsDependencyIndexer.class);

    @Override
    public CmsSearchIndexUpdateData getUpdateData(CmsSearchIndexSource source, List<CmsPublishedResource> publishedResources) {
        try {
            CmsSearchIndexUpdateData result = new CmsSearchIndexUpdateData(source, this);
            for (CmsPublishedResource pubRes : publishedResources) {
                if (pubRes.getStructureId().isNullUUID() || !pubRes.isFile() || !CmsProject.isInsideProject(source.getResourcesNames(), pubRes.getRootPath())) continue;
                CmsPublishedResource pub = pubRes;
                CmsDocumentDependency dep = CmsDocumentDependency.load(this.m_cms, pub);
                List<CmsDocumentDependency> depsAvailable = dep.getDependencies();
                Iterator<CmsDocumentDependency> depIt = depsAvailable.iterator();
                do {
                    this.addResourceToUpdateData(pub, result);
                    if (!pub.getState().isDeleted()) {
                        dep.storeInContext(this.m_cms);
                    }
                    if (depIt.hasNext()) {
                        pub = depIt.next().getResource();
                        continue;
                    }
                    dep = null;
                } while (dep != null);
            }
            return result;
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isLocaleDependenciesEnable() {
        return true;
    }

    @Override
    public I_CmsIndexer newInstance(CmsObject cms, I_CmsReport report, CmsSearchIndex index) {
        CmsDependencyIndexer indexer = new CmsDependencyIndexer();
        indexer.m_cms = cms;
        indexer.m_report = report;
        indexer.m_index = index;
        return indexer;
    }

    @Override
    public void rebuildIndex(I_CmsIndexWriter writer, CmsIndexingThreadManager threadManager, CmsSearchIndexSource source) throws CmsIndexException {
        List<String> resourceNames = source.getResourcesNames();
        for (String resourceName : resourceNames) {
            List<CmsResource> resources;
            block5: {
                resources = null;
                try {
                    resources = this.m_cms.readResources(resourceName, CmsResourceFilter.IGNORE_EXPIRATION.addRequireFile());
                }
                catch (CmsException e) {
                    if (this.m_report != null) {
                        this.m_report.println(Messages.get().container("RPT_UNABLE_TO_READ_SOURCE_2", resourceName, e.getLocalizedMessage()), 1);
                    }
                    if (!LOG.isWarnEnabled()) break block5;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_UNABLE_TO_READ_SOURCE_2", resourceName, this.m_index.getName()), (Throwable)e);
                }
            }
            if (resources == null) continue;
            Map<String, List<CmsResource>> folderLookupMap = this.createFolderLookupMap(resources);
            for (CmsResource resource : resources) {
                List<CmsResource> folderContent = folderLookupMap.get(CmsResource.getFolderPath(resource.getRootPath()));
                CmsDocumentDependency dep = CmsDocumentDependency.load(this.m_cms, resource, folderContent);
                dep.storeInContext(this.m_cms);
                this.updateResource(writer, threadManager, resource);
            }
        }
    }

    protected Map<String, List<CmsResource>> createFolderLookupMap(List<CmsResource> resources) {
        HashMap<String, List<CmsResource>> result = new HashMap<String, List<CmsResource>>(128);
        for (CmsResource res : resources) {
            String folderPath = CmsResource.getFolderPath(res.getRootPath());
            ArrayList<CmsResource> folderContent = (ArrayList<CmsResource>)result.get(folderPath);
            if (folderContent == null) {
                folderContent = new ArrayList<CmsResource>(32);
                result.put(folderPath, folderContent);
            }
            folderContent.add(res);
        }
        return result;
    }
}

