/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.scheduler.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.log.CmsLogFilter;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.scheduler.I_CmsScheduledJob;

public class CmsRemoveOldDbLogEntriesJob
implements I_CmsScheduledJob {
    public static final int MAX_AGE_DEFAULT = 2880;
    public static final String PARAM_MAX_AGE = "max-age";
    private static final Log LOG = CmsLog.getLog(CmsRemoveOldDbLogEntriesJob.class);

    @Override
    public String launch(CmsObject cms, Map<String, String> parameters) throws Exception {
        String maxAgeStr = parameters.get(PARAM_MAX_AGE);
        int maxAgeHours = this.parseMaxAge(maxAgeStr);
        if (maxAgeHours > 0) {
            long maxAgeMillis = maxAgeHours * 3600 * 1000;
            long now = System.currentTimeMillis();
            CmsLogFilter filter = CmsLogFilter.ALL.filterTo(now - maxAgeMillis);
            LOG.info((Object)("Removing all entries from CMS_LOG older than " + maxAgeHours + " hours..."));
            cms.deleteLogEntries(filter);
        } else {
            LOG.info((Object)"Not deleting any log entries because of a problem with the max-age format.");
        }
        return "remove old db log entries (max age : " + maxAgeStr + ")";
    }

    public int parseMaxAge(String maxAgeStr) {
        if (maxAgeStr == null) {
            this.showFormatError(maxAgeStr);
            return -1;
        }
        String[] tokens = (maxAgeStr = maxAgeStr.toLowerCase().trim()).split(" +");
        if (tokens.length != 2) {
            this.showFormatError(maxAgeStr);
            return -1;
        }
        int number = 0;
        try {
            number = Integer.parseInt(tokens[0]);
        }
        catch (NumberFormatException e) {
            this.showFormatError(maxAgeStr);
            return -1;
        }
        String unit = tokens[1];
        if ("d".equals(unit) || unit.startsWith("day")) {
            return 24 * number;
        }
        if ("h".equals(unit) || unit.startsWith("hour")) {
            return number;
        }
        if ("w".equals(unit) || unit.startsWith("week")) {
            return 168 * number;
        }
        this.showFormatError(maxAgeStr);
        return -1;
    }

    private void showFormatError(String paramValue) {
        LOG.error((Object)("Invalid value for the max-age parameter: '" + paramValue + "'"));
    }
}

