/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.repository.I_CmsRepository;
import org.opencms.repository.Messages;

public class CmsRepositoryManager {
    private static final Log LOG = CmsLog.getLog(CmsRepositoryManager.class);
    private boolean m_configured;
    private boolean m_frozen;
    private List<I_CmsRepository> m_repositoryList = new ArrayList<I_CmsRepository>();
    private Map<String, I_CmsRepository> m_repositoryMap = new LinkedHashMap<String, I_CmsRepository>();

    public CmsRepositoryManager() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_STARTING_REPOSITORY_CONFIG_0"));
        }
        this.m_repositoryMap = new HashMap<String, I_CmsRepository>();
        this.m_frozen = false;
        this.m_configured = true;
    }

    public CmsRepositoryManager(boolean configured) {
        this();
        this.m_configured = configured;
        this.m_frozen = true;
    }

    public void addRepositoryClass(I_CmsRepository repository) throws CmsConfigurationException {
        if (this.m_frozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_NO_CONFIG_AFTER_STARTUP_0"));
        }
        this.m_repositoryList.add(repository);
    }

    public List<I_CmsRepository> getRepositories() {
        return new ArrayList<I_CmsRepository>(this.m_repositoryMap.values());
    }

    public <REPO extends I_CmsRepository> List<REPO> getRepositories(Class<REPO> cls) {
        ArrayList<I_CmsRepository> result = new ArrayList<I_CmsRepository>();
        for (I_CmsRepository repo : this.m_repositoryMap.values()) {
            if (!cls.isInstance(repo)) continue;
            result.add(repo);
        }
        return result;
    }

    public I_CmsRepository getRepository(String name) {
        return this.m_repositoryMap.get(name);
    }

    public <REPO extends I_CmsRepository> REPO getRepository(String name, Class<REPO> cls) {
        I_CmsRepository repo = this.getRepository(name);
        if (repo == null) {
            return null;
        }
        if (cls.isInstance(repo)) {
            return (REPO)repo;
        }
        return null;
    }

    public void initConfiguration() throws CmsConfigurationException {
        for (I_CmsRepository rep : this.m_repositoryList) {
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_REPOSITORY_2", rep.getClass().getName(), rep.getName()));
            }
            rep.initConfiguration();
            this.m_repositoryMap.put(rep.getName(), rep);
        }
        this.m_frozen = true;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_REPOSITORY_CONFIG_FINISHED_0"));
        }
    }

    public void initializeCms(CmsObject cms) {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (I_CmsRepository repository : this.m_repositoryMap.values()) {
            String repoName = repository.getName();
            try {
                repository.initializeCms(cms);
            }
            catch (CmsException e) {
                LOG.warn((Object)("Could not fully initialize repository " + repoName), (Throwable)e);
                toRemove.add(repoName);
            }
        }
        for (String removeRepo : toRemove) {
            this.m_repositoryMap.remove(removeRepo);
        }
    }

    public boolean isConfigured() {
        return this.m_configured;
    }
}

