/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.repository;

import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.wrapper.CmsObjectWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.repository.I_CmsRepositoryItem;

public class CmsRepositoryItem
implements I_CmsRepositoryItem {
    private CmsObjectWrapper m_cms;
    private byte[] m_content;
    private String m_mimeType;
    private CmsResource m_resource;

    public CmsRepositoryItem(CmsResource res, CmsObjectWrapper cms) {
        this.m_resource = res;
        this.m_cms = cms;
    }

    @Override
    public byte[] getContent() {
        if (!this.m_resource.isFile()) {
            return null;
        }
        if (this.m_content == null) {
            try {
                String filename = this.m_cms.getSitePath(this.m_resource);
                CmsFile file = this.m_cms.readFile(filename, CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_content = file.getContents();
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return this.m_content;
    }

    @Override
    public long getContentLength() {
        return this.m_resource.getLength();
    }

    @Override
    public long getCreationDate() {
        return this.m_resource.getDateCreated();
    }

    @Override
    public long getLastModifiedDate() {
        return this.m_resource.getDateLastModified();
    }

    @Override
    public String getMimeType() {
        if (!this.m_resource.isFile()) {
            return null;
        }
        if (this.m_mimeType == null) {
            try {
                String encoding = this.m_cms.readPropertyObject(this.m_resource, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
                this.m_mimeType = OpenCms.getResourceManager().getMimeType(this.m_resource.getRootPath(), encoding, "text/plain");
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
        }
        return this.m_mimeType;
    }

    @Override
    public String getName() {
        return this.m_cms.getRequestContext().removeSiteRoot(this.m_resource.getRootPath());
    }

    @Override
    public boolean isCollection() {
        return this.m_resource.isFolder();
    }
}

