/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.opencms.i18n.CmsMessages;
import org.opencms.relations.Messages;

public class CmsExternalLinksValidationResult {
    private Map<String, String> m_brokenLinks;
    private Date m_validationDate;

    public CmsExternalLinksValidationResult(Map<String, String> brokenLinks) {
        this.m_brokenLinks = brokenLinks;
        this.m_validationDate = new Date();
    }

    public String toHtml(Locale locale) {
        CmsMessages mg = Messages.get().getBundle(locale);
        if (this.m_brokenLinks.size() > 0) {
            StringBuffer result = new StringBuffer(1024);
            Iterator<Map.Entry<String, String>> brokenLinks = this.m_brokenLinks.entrySet().iterator();
            result.append(mg.key("GUI_LINK_VALIDATION_RESULTS_INTRO_1", new Object[]{this.m_validationDate})).append("<ul>");
            while (brokenLinks.hasNext()) {
                Map.Entry<String, String> link = brokenLinks.next();
                String linkPath = link.getKey();
                String linkUrl = link.getValue();
                String msg = mg.key("GUI_LINK_POINTING_TO_2", new Object[]{linkPath, linkUrl});
                result.append("<li>").append(msg).append("</li>");
            }
            return result.append("</ul>").toString();
        }
        return mg.key("GUI_LINK_VALIDATION_RESULTS_ALL_VALID_1", new Object[]{this.m_validationDate});
    }
}

