/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.relations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsStringUtil;

public class CmsCategoryService {
    public static final String CENTRALIZED_REPOSITORY = "/system/categories/";
    private static final Log LOG = CmsLog.getLog(CmsCategoryService.class);
    private static CmsCategoryService m_instance;
    private static final String REPOSITORY_BASE_FOLDER = "/_categories/";

    public static CmsCategoryService getInstance() {
        if (m_instance == null) {
            m_instance = new CmsCategoryService();
        }
        return m_instance;
    }

    public void addResourceToCategory(CmsObject cms, String resourceName, CmsCategory category) throws CmsException {
        if (this.readResourceCategories(cms, cms.readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION)).contains(category)) {
            return;
        }
        String sitePath = cms.getRequestContext().removeSiteRoot(category.getRootPath());
        cms.addRelationToResource(resourceName, sitePath, CmsRelationType.CATEGORY.getName());
        String parentCatPath = category.getPath();
        if (parentCatPath.endsWith("/")) {
            parentCatPath = parentCatPath.substring(0, parentCatPath.length() - 1);
        }
        if (parentCatPath.lastIndexOf(47) > 0) {
            this.addResourceToCategory(cms, resourceName, parentCatPath.substring(0, parentCatPath.lastIndexOf(47) + 1));
        }
    }

    public void addResourceToCategory(CmsObject cms, String resourceName, String categoryPath) throws CmsException {
        CmsCategory category = this.readCategory(cms, categoryPath, resourceName);
        this.addResourceToCategory(cms, resourceName, category);
    }

    public void clearCategoriesForResource(CmsObject cms, String resourcePath) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.TARGETS;
        filter = filter.filterType(CmsRelationType.CATEGORY);
        cms.deleteRelationsFromResource(resourcePath, filter);
    }

    public CmsCategory createCategory(CmsObject cms, CmsCategory parent, String name, String title, String description, String referencePath) throws CmsException {
        CmsResource resource;
        ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
            properties.add(new CmsProperty("Title", title, null));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
            properties.add(new CmsProperty("Description", description, null));
        }
        String folderPath = "";
        if (parent != null) {
            folderPath = folderPath + parent.getRootPath();
        } else if (referencePath == null) {
            folderPath = folderPath + CENTRALIZED_REPOSITORY;
        } else {
            List<String> repositories = this.getCategoryRepositories(cms, referencePath);
            folderPath = repositories.get(repositories.size() - 1);
        }
        folderPath = cms.getRequestContext().removeSiteRoot(this.internalCategoryRootPath(folderPath, name));
        try {
            resource = cms.createResource(folderPath, 0, null, properties);
        }
        catch (CmsVfsResourceNotFoundException e) {
            cms.createResource(CENTRALIZED_REPOSITORY, 0);
            resource = cms.createResource(folderPath, 0, null, properties);
        }
        return this.getCategory(cms, resource);
    }

    public void deleteCategory(CmsObject cms, String categoryPath, String referencePath) throws CmsException {
        CmsCategory category = this.readCategory(cms, categoryPath, referencePath);
        String folderPath = cms.getRequestContext().removeSiteRoot(category.getRootPath());
        CmsLock lock = cms.getLock(folderPath);
        if (lock.isNullLock()) {
            cms.lockResource(folderPath);
        } else if (lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
            cms.changeLock(folderPath);
        }
        cms.deleteResource(folderPath, CmsResource.DELETE_PRESERVE_SIBLINGS);
    }

    public CmsCategory getCategory(CmsObject cms, CmsResource resource) throws CmsException {
        CmsProperty title = cms.readPropertyObject(resource, "Title", false);
        CmsProperty description = cms.readPropertyObject(resource, "Description", false);
        return new CmsCategory(resource.getStructureId(), resource.getRootPath(), title.getValue(resource.getName()), description.getValue(""), this.getRepositoryBaseFolderName(cms));
    }

    public CmsCategory getCategory(CmsObject cms, String categoryRootPath) throws CmsException {
        CmsResource resource = cms.readResource(cms.getRequestContext().removeSiteRoot(categoryRootPath));
        return this.getCategory(cms, resource);
    }

    public List<String> getCategoryRepositories(CmsObject cms, String referencePath) {
        ArrayList<String> ret = new ArrayList<String>();
        if (referencePath == null) {
            ret.add(CENTRALIZED_REPOSITORY);
            return ret;
        }
        String path = referencePath;
        if (!CmsResource.isFolder(path)) {
            path = CmsResource.getParentFolder(path);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(path)) {
            path = "/";
        }
        String categoryBase = this.getRepositoryBaseFolderName(cms);
        do {
            String repositoryPath;
            if (!cms.existsResource(repositoryPath = this.internalCategoryRootPath(path, categoryBase))) continue;
            ret.add(repositoryPath);
        } while ((path = CmsResource.getParentFolder(path)) != null);
        ret.add(CENTRALIZED_REPOSITORY);
        Collections.reverse(ret);
        return ret;
    }

    public String getRepositoryBaseFolderName(CmsObject cms) {
        try {
            String value = cms.readPropertyObject(CENTRALIZED_REPOSITORY, "default-file", false).getValue(REPOSITORY_BASE_FOLDER);
            if (!value.endsWith("/")) {
                value = value + "/";
            }
            if (!value.startsWith("/")) {
                value = "/" + value;
            }
            return value;
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return REPOSITORY_BASE_FOLDER;
        }
    }

    public void moveCategory(CmsObject cms, String oldCatPath, String newCatPath, String referencePath) throws CmsException {
        CmsCategory category = this.readCategory(cms, oldCatPath, referencePath);
        String catPath = cms.getRequestContext().removeSiteRoot(category.getRootPath());
        CmsLock lock = cms.getLock(catPath);
        if (lock.isNullLock()) {
            cms.lockResource(catPath);
        } else if (lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
            cms.changeLock(catPath);
        }
        cms.moveResource(catPath, cms.getRequestContext().removeSiteRoot(this.internalCategoryRootPath(category.getBasePath(), newCatPath)));
    }

    public List<CmsCategory> readCategories(CmsObject cms, String parentCategoryPath, boolean includeSubCats, String referencePath) throws CmsException {
        List<String> repositories = this.getCategoryRepositories(cms, referencePath);
        return this.readCategoriesForRepositories(cms, parentCategoryPath, includeSubCats, repositories);
    }

    public List<CmsCategory> readCategoriesForRepositories(CmsObject cms, String parentCategoryPath, boolean includeSubCats, List<String> repositories) throws CmsException {
        String catPath = parentCategoryPath;
        if (catPath == null) {
            catPath = "";
        }
        HashSet<CmsCategory> cats = new HashSet<CmsCategory>();
        for (String repository : repositories) {
            try {
                cats.addAll(this.internalReadSubCategories(cms, this.internalCategoryRootPath(repository, catPath), includeSubCats));
            }
            catch (CmsVfsResourceNotFoundException e) {}
        }
        ArrayList<CmsCategory> ret = new ArrayList<CmsCategory>(cats);
        Collections.sort(ret);
        return ret;
    }

    public CmsCategory readCategory(CmsObject cms, String categoryPath, String referencePath) throws CmsException {
        Iterator<String> it = this.getCategoryRepositories(cms, referencePath).iterator();
        while (it.hasNext()) {
            String repository = it.next();
            try {
                return this.getCategory(cms, this.internalCategoryRootPath(repository, categoryPath));
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (it.hasNext()) continue;
                throw e;
            }
        }
        return null;
    }

    public List<CmsResource> readCategoryResources(CmsObject cms, String categoryPath, boolean recursive, String referencePath) throws CmsException {
        return this.readCategoryResources(cms, categoryPath, recursive, referencePath, CmsResourceFilter.DEFAULT);
    }

    public List<CmsResource> readCategoryResources(CmsObject cms, String categoryPath, boolean recursive, String referencePath, CmsResourceFilter resFilter) throws CmsException {
        HashSet<CmsResource> resources = new HashSet<CmsResource>();
        CmsRelationFilter filter = CmsRelationFilter.SOURCES.filterType(CmsRelationType.CATEGORY);
        if (recursive) {
            filter = filter.filterIncludeChildren();
        }
        CmsCategory category = this.readCategory(cms, categoryPath, referencePath);
        for (CmsRelation relation : cms.getRelationsForResource(cms.getRequestContext().removeSiteRoot(category.getRootPath()), filter)) {
            try {
                resources.add(relation.getSource(cms, resFilter));
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resources);
        Collections.sort(result);
        return result;
    }

    public List<CmsCategory> readResourceCategories(CmsObject cms, CmsResource resource) throws CmsException {
        return this.internalReadResourceCategories(cms, resource, false);
    }

    public List<CmsCategory> readResourceCategories(CmsObject cms, String resourceName) throws CmsException {
        return this.internalReadResourceCategories(cms, cms.readResource(resourceName), false);
    }

    public void removeResourceFromCategory(CmsObject cms, String resourceName, CmsCategory category) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.TARGETS;
        filter = filter.filterType(CmsRelationType.CATEGORY);
        filter = filter.filterResource(cms.readResource(cms.getRequestContext().removeSiteRoot(category.getRootPath())));
        filter = filter.filterIncludeChildren();
        cms.deleteRelationsFromResource(resourceName, filter);
    }

    public void removeResourceFromCategory(CmsObject cms, String resourceName, String categoryPath) throws CmsException {
        CmsCategory category = this.readCategory(cms, categoryPath, resourceName);
        this.removeResourceFromCategory(cms, resourceName, category);
    }

    public void repairRelations(CmsObject cms, CmsResource resource) throws CmsException {
        this.internalReadResourceCategories(cms, resource, true);
    }

    public void repairRelations(CmsObject cms, String resourceName) throws CmsException {
        this.repairRelations(cms, cms.readResource(resourceName));
    }

    private String internalCategoryRootPath(String basePath, String categoryPath) {
        if (categoryPath.startsWith("/") && basePath.endsWith("/")) {
            return basePath + categoryPath.substring(1);
        }
        if (!categoryPath.startsWith("/") && !basePath.endsWith("/")) {
            return basePath + "/" + categoryPath;
        }
        return basePath + categoryPath;
    }

    private List<CmsCategory> internalReadResourceCategories(CmsObject cms, CmsResource resource, boolean repair) throws CmsException {
        ArrayList<CmsCategory> result = new ArrayList<CmsCategory>();
        String baseFolder = null;
        Iterator<CmsRelation> itRelations = cms.getRelationsForResource(resource, CmsRelationFilter.TARGETS.filterType(CmsRelationType.CATEGORY)).iterator();
        if (repair && itRelations.hasNext()) {
            baseFolder = this.getRepositoryBaseFolderName(cms);
        }
        String resourceName = cms.getSitePath(resource);
        boolean repaired = false;
        while (itRelations.hasNext()) {
            CmsCategory actualCat;
            CmsRelation relation = itRelations.next();
            try {
                CmsResource res = relation.getTarget(cms, CmsResourceFilter.DEFAULT_FOLDERS);
                CmsCategory category = this.getCategory(cms, res);
                if (!repair) {
                    result.add(category);
                    continue;
                }
                actualCat = this.readCategory(cms, category.getPath(), resourceName);
                if (!category.getId().equals(actualCat.getId())) {
                    CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterType(CmsRelationType.CATEGORY).filterResource(res);
                    cms.deleteRelationsFromResource(resourceName, filter);
                    repaired = true;
                    String catPath = cms.getRequestContext().removeSiteRoot(actualCat.getRootPath());
                    cms.addRelationToResource(resourceName, catPath, CmsRelationType.CATEGORY.getName());
                }
                result.add(actualCat);
            }
            catch (CmsException e) {
                if (!repair) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                CmsRelationFilter filter = CmsRelationFilter.TARGETS.filterType(CmsRelationType.CATEGORY).filterPath(relation.getTargetPath());
                if (!relation.getTargetId().isNullUUID()) {
                    filter = filter.filterStructureId(relation.getTargetId());
                }
                cms.deleteRelationsFromResource(resourceName, filter);
                repaired = true;
                try {
                    actualCat = this.readCategory(cms, CmsCategory.getCategoryPath(relation.getTargetPath(), baseFolder), resourceName);
                    this.addResourceToCategory(cms, resourceName, actualCat);
                    result.add(actualCat);
                }
                catch (CmsException ex) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }
        if (!repair) {
            Collections.sort(result);
        } else if (repaired) {
            for (CmsCategory category : result) {
                this.addResourceToCategory(cms, resourceName, category.getPath());
            }
        }
        return result;
    }

    private List<CmsCategory> internalReadSubCategories(CmsObject cms, String rootPath, boolean includeSubCats) throws CmsException {
        ArrayList<CmsCategory> categories = new ArrayList<CmsCategory>();
        List<CmsResource> resources = cms.readResources(cms.getRequestContext().removeSiteRoot(rootPath), CmsResourceFilter.DEFAULT.addRequireType(0), includeSubCats);
        for (CmsResource resource : resources) {
            categories.add(this.getCategory(cms, resource));
        }
        return categories;
    }
}

