/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.publish;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishException;
import org.opencms.publish.CmsPublishJobBase;
import org.opencms.publish.CmsPublishJobEnqueued;
import org.opencms.publish.CmsPublishJobFinished;
import org.opencms.publish.CmsPublishJobRunning;
import org.opencms.publish.I_CmsPublishEventListener;
import org.opencms.publish.Messages;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.report.CmsShellReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsUUID;

public class CmsPublishManager {
    public static final int DEFAULT_HISTORY_SIZE = 100;
    public static final boolean DEFAULT_QUEUE_PERSISTANCE = false;
    public static final int DEFAULT_QUEUE_SHUTDOWNTIME = 1;
    private static final int MS_ONE_SECOND = 1000;
    private boolean m_frozen;
    private CmsPublishEngine m_publishEngine = null;
    private int m_publishHistorySize;
    private boolean m_publishQueuePersistance;
    private int m_publishQueueShutdowntime;
    private CmsSecurityManager m_securityManager;

    public CmsPublishManager() {
        this.m_frozen = false;
    }

    public CmsPublishManager(int historySize, boolean queuePersistance, int queueShutdowntime) {
        this.m_publishHistorySize = historySize;
        this.m_publishQueuePersistance = queuePersistance;
        this.m_publishQueueShutdowntime = queueShutdowntime;
        this.m_frozen = false;
    }

    public void abandonThread() {
        this.m_publishEngine.abandonThread();
    }

    public void abortPublishJob(CmsObject cms, CmsPublishJobEnqueued publishJob, boolean removeJob) throws CmsException, CmsSecurityException, CmsPublishException {
        if (!OpenCms.getRoleManager().hasRole(cms, CmsRole.PROJECT_MANAGER) && !cms.getRequestContext().getCurrentUser().getId().equals(publishJob.getUserId())) {
            throw new CmsSecurityException(Messages.get().container("ERR_PUBLISH_ENGINE_ABORT_DENIED_1", cms.getRequestContext().getCurrentUser().getName()));
        }
        this.m_publishEngine.abortPublishJob(cms.getRequestContext().getCurrentUser().getId(), publishJob, removeJob);
    }

    public void addPublishListener(I_CmsPublishEventListener listener) {
        this.m_publishEngine.addPublishListener(listener);
    }

    public void checkCurrentPublishJobThread() {
        this.m_publishEngine.checkCurrentPublishJobThread();
    }

    public void disablePublishing() {
        this.m_publishEngine.disableEngine();
    }

    public void enablePublishing() {
        this.m_publishEngine.enableEngine();
    }

    public CmsPublishJobRunning getCurrentPublishJob() {
        if (this.m_publishEngine.getCurrentPublishJob() == null) {
            return null;
        }
        return new CmsPublishJobRunning(this.m_publishEngine.getCurrentPublishJob().getPublishJob());
    }

    public CmsPublishJobBase getJobByPublishHistoryId(CmsUUID publishHistoryId) {
        return this.m_publishEngine.getJobByPublishHistoryId(publishHistoryId);
    }

    public List<CmsPublishJobFinished> getPublishHistory() {
        return this.m_publishEngine.getPublishHistory().asList();
    }

    public List<CmsPublishJobFinished> getPublishHistory(CmsUser user) {
        ArrayList<CmsPublishJobFinished> result = new ArrayList<CmsPublishJobFinished>();
        for (CmsPublishJobFinished publishJob : this.getPublishHistory()) {
            if (!publishJob.getUserId().equals(user.getId())) continue;
            result.add(publishJob);
        }
        return result;
    }

    public int getPublishHistorySize() {
        return this.m_publishHistorySize;
    }

    public CmsPublishList getPublishList(CmsObject cms) throws CmsException {
        return this.m_securityManager.fillPublishList(cms.getRequestContext(), new CmsPublishList(cms.getRequestContext().getCurrentProject()));
    }

    public CmsPublishList getPublishList(CmsObject cms, CmsResource directPublishResource, boolean directPublishSiblings) throws CmsException {
        return this.m_securityManager.fillPublishList(cms.getRequestContext(), new CmsPublishList(directPublishResource, directPublishSiblings));
    }

    public CmsPublishList getPublishList(CmsObject cms, List<CmsResource> directPublishResources, boolean directPublishSiblings) throws CmsException {
        return this.getPublishList(cms, directPublishResources, directPublishSiblings, true);
    }

    public CmsPublishList getPublishList(CmsObject cms, List<CmsResource> directPublishResources, boolean directPublishSiblings, boolean publishSubResources) throws CmsException {
        return this.m_securityManager.fillPublishList(cms.getRequestContext(), new CmsPublishList(directPublishResources, directPublishSiblings, publishSubResources));
    }

    public CmsPublishList getPublishListAll(CmsObject cms, List<CmsResource> directPublishResources, boolean directPublishSiblings, boolean isUserPublishList) throws CmsException {
        CmsPublishList pubList = new CmsPublishList(true, directPublishResources, directPublishSiblings);
        pubList.setUserPublishList(isUserPublishList);
        return this.m_securityManager.fillPublishList(cms.getRequestContext(), pubList);
    }

    public List<CmsPublishJobEnqueued> getPublishQueue() {
        return this.m_publishEngine.getPublishQueue().asList();
    }

    public int getPublishQueueShutdowntime() {
        return this.m_publishQueueShutdowntime;
    }

    public CmsPublishList getRelatedResourcesToPublish(CmsObject cms, CmsPublishList publishList) throws CmsException {
        return this.m_securityManager.getRelatedResourcesToPublish(cms.getRequestContext(), publishList, CmsRelationFilter.TARGETS.filterStrong());
    }

    public byte[] getReportContents(CmsPublishJobFinished publishJob) throws CmsException {
        return this.m_publishEngine.getReportContents(publishJob);
    }

    public List<CmsResource> getUsersPubList(CmsObject cms) throws CmsException {
        return this.m_securityManager.getUsersPubList(cms.getRequestContext());
    }

    public void initialize(CmsObject cms) throws CmsException {
        this.m_publishEngine.initialize(cms, this.m_publishQueuePersistance, this.m_publishQueueShutdowntime);
        this.m_frozen = true;
    }

    public boolean isPublishQueuePersistanceEnabled() {
        return this.m_publishQueuePersistance;
    }

    public boolean isRunning() {
        return this.m_publishEngine.isRunning();
    }

    public CmsPublishList mergePublishLists(CmsObject cms, CmsPublishList pubList1, CmsPublishList pubList2) throws CmsException {
        return this.m_securityManager.mergePublishLists(cms.getRequestContext(), pubList1, pubList2);
    }

    public CmsUUID publishProject(CmsObject cms) throws Exception {
        return this.publishProject(cms, new CmsShellReport(cms.getRequestContext().getLocale()));
    }

    public CmsUUID publishProject(CmsObject cms, I_CmsReport report) throws CmsException {
        return this.publishProject(cms, report, this.getPublishList(cms));
    }

    public CmsUUID publishProject(CmsObject cms, I_CmsReport report, CmsPublishList publishList) throws CmsException {
        return this.m_securityManager.publishProject(cms, publishList, report);
    }

    public CmsUUID publishProject(CmsObject cms, I_CmsReport report, CmsResource directPublishResource, boolean directPublishSiblings) throws CmsException {
        return this.publishProject(cms, report, this.getPublishList(cms, directPublishResource, directPublishSiblings));
    }

    public CmsUUID publishResource(CmsObject cms, String resourcename) throws Exception {
        return this.publishResource(cms, resourcename, false, new CmsShellReport(cms.getRequestContext().getLocale()));
    }

    public CmsUUID publishResource(CmsObject cms, String resourcename, boolean publishSiblings, I_CmsReport report) throws Exception {
        CmsResource resource = cms.readResource(resourcename, CmsResourceFilter.ALL);
        return this.publishProject(cms, report, resource, publishSiblings);
    }

    public void removePublishListener(I_CmsPublishEventListener listener) {
        this.m_publishEngine.removePublishListener(listener);
    }

    public void removeResourceFromUsersPubList(CmsObject cms, Collection<CmsUUID> structureIds) throws CmsException {
        this.m_securityManager.removeResourceFromUsersPubList(cms.getRequestContext(), structureIds);
    }

    public void setPublishEngine(CmsPublishEngine publishEngine) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_publishEngine = publishEngine;
    }

    public void setPublishHistorySize(String publishHistorySize) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_publishHistorySize = Integer.parseInt(publishHistorySize);
    }

    public void setPublishQueuePersistance(String publishQueuePersistance) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_publishQueuePersistance = Boolean.valueOf(publishQueuePersistance);
    }

    public void setPublishQueueShutdowntime(String publishQueueShutdowntime) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_publishQueueShutdowntime = Integer.parseInt(publishQueueShutdowntime);
    }

    public void setSecurityManager(CmsSecurityManager securityManager) {
        if (this.m_frozen) {
            throw new CmsRuntimeException(Messages.get().container("ERR_CONFIG_FROZEN_0"));
        }
        this.m_securityManager = securityManager;
    }

    public void startPublishing() {
        this.m_publishEngine.startEngine();
    }

    public void stopPublishing() {
        this.m_publishEngine.stopEngine();
    }

    public Map<String, List<CmsRelation>> validateRelations(CmsObject cms, CmsPublishList publishList, I_CmsReport report) throws Exception {
        return this.m_securityManager.validateRelations(cms.getRequestContext(), publishList, report);
    }

    public void waitWhileRunning() {
        this.waitWhileRunning(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitWhileRunning(long ms) {
        int i = 0;
        CmsPublishManager cmsPublishManager = this;
        synchronized (cmsPublishManager) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            while (this.isRunning() && (long)(1000 * i) <= ms) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
    }

    protected CmsPublishEngine getEngine() {
        return this.m_publishEngine;
    }
}

