/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.main.Messages;
import org.opencms.main.OpenCmsCore;
import org.opencms.main.OpenCmsServlet;
import org.opencms.util.CmsStringUtil;

public class OpenCmsServletErrorHandler
extends OpenCmsServlet {
    private static final long serialVersionUID = 5316004893684482816L;

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Integer errorStatus = (Integer)req.getAttribute("javax.servlet.error.status_code");
        if (errorStatus != null) {
            if (OpenCmsCore.getInstance().getRunLevel() > 3) {
                super.doGet(req, res);
            } else {
                String errorMessage = (String)req.getAttribute("javax.servlet.error.message");
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(errorMessage)) {
                    errorMessage = "";
                }
                String output = "<html><body>" + CmsStringUtil.escapeHtml(Messages.get().getBundle().key("ERR_OPENCMS_NOT_INITIALIZED_2", errorStatus, errorMessage)) + "</body></html>";
                res.setStatus(errorStatus.intValue());
                res.getWriter().println(output);
            }
        } else {
            res.sendError(403);
        }
    }

    @Override
    public void init(ServletConfig config) {
    }
}

