/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Enumeration;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.Messages;
import org.opencms.main.OpenCmsCore;

public class OpenCmsListener
implements ServletContextListener,
HttpSessionListener {
    private static final Log LOG = CmsLog.getLog(OpenCmsListener.class);

    public void contextDestroyed(ServletContextEvent event) {
        try {
            OpenCmsCore.getInstance().shutDown();
            this.shutDownSqlDrivers();
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            OpenCmsCore.getInstance().upgradeRunlevel(event.getServletContext());
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
            throw new CmsInitException(Messages.get().container("ERR_CRITICAL_INIT_GENERIC_1", t.getMessage()));
        }
    }

    public void sessionCreated(HttpSessionEvent event) {
        try {
            OpenCmsCore.getInstance().getSessionManager().sessionCreated(event);
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        try {
            OpenCmsCore.getInstance().getSessionManager().sessionDestroyed(event);
        }
        catch (CmsInitException e) {
            if (e.isNewError()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_GENERIC_0"), t);
        }
    }

    private void shutDownSqlDrivers() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            try {
                DriverManager.deregisterDriver(driver);
                System.out.println(Messages.get().getBundle().key("LOG_ERROR_DERIGISTERING_JDBC_DRIVER_1", driver.getClass().getName()));
            }
            catch (Throwable e) {
                System.out.println(Messages.get().getBundle().key("ERR_DEREGISTERING_JDBC_DRIVER_1", driver.getClass().getName()));
            }
        }
    }
}

