/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public final class CmsReqStatistics {
    private static final Log LOG = CmsLog.getLog(CmsReqStatistics.class);
    private static final ThreadLocal<CmsReqStatistics> PER_THREAD_STATISTICS = new ThreadLocal();
    private long m_cmsInitTime = 0L;
    private long m_endtime = 0L;
    private Map<String, Long> m_initCmsObjectTime;
    private long m_initResourceTime = 0L;
    private long m_loadResourceTime = 0L;
    private long m_starttime = System.currentTimeMillis();
    private String m_uri;

    private CmsReqStatistics() {
        this.m_initCmsObjectTime = new HashMap<String, Long>();
    }

    public static void endCmsInit(String name) {
        Long startTime;
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null && (startTime = stats.m_initCmsObjectTime.get(name)) != null) {
            long time = System.currentTimeMillis() - startTime;
            stats.m_initCmsObjectTime.put(name, new Long(time));
        }
    }

    public static void setCmsObjectInitTime() {
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null) {
            stats.m_cmsInitTime = System.currentTimeMillis() - stats.m_starttime;
        }
    }

    public static void setEndTime() {
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null) {
            stats.m_endtime = System.currentTimeMillis() - stats.m_starttime;
            LOG.debug((Object)stats.getSummary());
            if (stats.getCmsInitTime() > 200L) {
                LOG.debug((Object)stats.getCmsInitInfo());
            }
            for (String poolname : OpenCms.getSqlManager().getDbPoolUrls()) {
                try {
                    LOG.debug((Object)stats.getConn(poolname));
                }
                catch (CmsException e) {
                    LOG.error((Object)e);
                }
            }
            PER_THREAD_STATISTICS.set(null);
            stats.clear();
        }
    }

    private void clear() {
        this.m_initCmsObjectTime = null;
        this.m_uri = null;
    }

    public static void setInitResoueceTime() {
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null) {
            stats.m_initResourceTime = System.currentTimeMillis() - stats.m_starttime;
        }
    }

    public static void setLoadResoueceTime() {
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null) {
            stats.m_loadResourceTime = System.currentTimeMillis() - stats.m_starttime;
        }
    }

    public static void startCmsInit(String name) {
        CmsReqStatistics stats;
        if (LOG.isDebugEnabled() && (stats = PER_THREAD_STATISTICS.get()) != null) {
            stats.m_initCmsObjectTime.put(name, new Long(System.currentTimeMillis()));
        }
    }

    public static void startStatistics(String requestedUrl) {
        if (LOG.isDebugEnabled()) {
            CmsReqStatistics stats = new CmsReqStatistics();
            stats.m_uri = requestedUrl;
            PER_THREAD_STATISTICS.set(stats);
        }
    }

    public String getCmsInitInfo() {
        StringBuffer buf = new StringBuffer();
        ArrayList<String> initTimes = new ArrayList<String>(this.m_initCmsObjectTime.keySet());
        Collections.sort(initTimes);
        for (String initTime : initTimes) {
            buf.append("[");
            buf.append(initTime.substring(initTime.lastIndexOf(":") + 1));
            buf.append("][");
            String tmp = "0000" + this.m_initCmsObjectTime.get(initTime);
            tmp = tmp.substring(tmp.length() - 4);
            buf.append(tmp);
            buf.append("]");
        }
        return buf.toString();
    }

    public long getCmsInitTime() {
        return this.m_cmsInitTime;
    }

    public String getConn(String poolname) throws CmsDbException {
        StringBuffer buf = new StringBuffer();
        buf.append("ACTIVE[");
        String tmp = "0000" + OpenCms.getSqlManager().getActiveConnections(poolname);
        tmp = tmp.substring(tmp.length() - 5);
        buf.append(tmp);
        buf.append("] IDLE[");
        tmp = "00000000" + OpenCms.getSqlManager().getIdleConnections(poolname);
        tmp = tmp.substring(tmp.length() - 5);
        buf.append(tmp);
        buf.append("] POOL[");
        buf.append(poolname);
        buf.append("]");
        return buf.toString();
    }

    public String getSummary() {
        StringBuffer buf = new StringBuffer();
        buf.append("TOTAL[");
        String tmp = "00000000" + this.m_endtime;
        tmp = tmp.substring(tmp.length() - 8);
        buf.append(tmp);
        buf.append("] CI[");
        tmp = "00000000" + this.m_cmsInitTime;
        tmp = tmp.substring(tmp.length() - 8);
        buf.append(tmp);
        buf.append("] IR[");
        tmp = "00000000" + this.m_initResourceTime;
        tmp = tmp.substring(tmp.length() - 8);
        buf.append(tmp);
        buf.append("] LR[");
        tmp = "00000000" + this.m_loadResourceTime;
        tmp = tmp.substring(tmp.length() - 8);
        buf.append(tmp);
        buf.append("] URI='");
        buf.append(this.m_uri);
        buf.append("'");
        return buf.toString();
    }

    public long getTime() {
        return this.m_endtime;
    }
}

