/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.Messages;
import org.opencms.security.CmsPermissionViolationException;

public class CmsPermalinkResourceHandler
implements I_CmsResourceInit {
    public static final String PERMALINK_HANDLER = "/permalink/";
    private Pattern m_uriPattern;
    private static final Log LOG = CmsLog.getLog(CmsPermalinkResourceHandler.class);

    public CmsPermalinkResourceHandler() {
        String uriRegex = "/permalink/([0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})(?:\\.[a-zA-Z0-9]*)?$";
        this.m_uriPattern = Pattern.compile(uriRegex);
    }

    @Override
    public CmsResource initResource(CmsResource resource, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException, CmsPermissionViolationException {
        String uri;
        Matcher matcher;
        if (resource == null && (matcher = this.m_uriPattern.matcher(uri = cms.getRequestContext().getUri())).find()) {
            String id = matcher.group(1);
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("/");
                resource = cms.readDefaultFile(id);
            }
            catch (CmsPermissionViolationException e) {
                throw e;
            }
            catch (Throwable e) {
                CmsMessageContainer msg = Messages.get().container("ERR_PERMALINK_1", id);
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)msg.key(), e);
                }
                throw new CmsResourceInitException(msg, e);
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
                if (resource != null) {
                    cms.getRequestContext().setUri(cms.getSitePath(resource));
                }
            }
        }
        return resource;
    }
}

