/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsSessionInfo;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsCore;
import org.opencms.security.I_CmsAuthorizationHandler;
import org.opencms.util.CmsUUID;

public abstract class A_CmsAuthorizationHandler
implements I_CmsAuthorizationHandler {
    protected static final Log LOG = CmsLog.getLog(A_CmsAuthorizationHandler.class);
    protected Map<String, String> m_parameters;

    protected CmsObject initCmsObjectFromSession(HttpServletRequest request) throws CmsException {
        return OpenCmsCore.getInstance().initCmsObjectFromSession(request);
    }

    protected CmsObject registerSession(HttpServletRequest request, CmsObject cms) throws CmsException {
        cms = OpenCmsCore.getInstance().updateContext(request, cms);
        CmsUser user = cms.getRequestContext().getCurrentUser();
        if (!user.isGuestUser() && !OpenCms.getDefaultUsers().isUserExport(user.getName())) {
            CmsSessionInfo sessionInfo = new CmsSessionInfo(cms.getRequestContext(), new CmsUUID(), request.getSession().getMaxInactiveInterval());
            OpenCmsCore.getInstance().getSessionManager().addSessionInfo(sessionInfo);
        }
        return cms;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.m_parameters = parameters;
    }
}

