/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.mail;

import javax.mail.AuthenticationFailedException;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.opencms.mail.CmsMailHost;
import org.opencms.mail.Messages;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsSimpleMail
extends SimpleEmail {
    private static final Log LOG = CmsLog.getLog(CmsSimpleMail.class);

    public CmsSimpleMail() {
        CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
        this.setHostName(host.getHostname());
        this.setSmtpPort(host.getPort());
        String userName = host.getUsername();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(userName)) {
            this.setAuthentication(userName, host.getPassword());
        }
        try {
            this.setFrom(OpenCms.getSystemInfo().getMailSettings().getMailFromDefault());
        }
        catch (EmailException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INVALID_SENDER_ADDRESS_0"), (Throwable)e);
        }
    }

    public String send() {
        String messageID = null;
        try {
            messageID = super.send();
        }
        catch (EmailException e) {
            if (e.getCause() instanceof AuthenticationFailedException) {
                CmsMailHost host = OpenCms.getSystemInfo().getMailSettings().getDefaultMailHost();
                CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_AUTHENTICATE_2", host.getUsername(), host.getHostname()));
                rte.initCause(e);
                throw rte;
            }
            CmsRuntimeException rte = new CmsRuntimeException(Messages.get().container("ERR_SEND_EMAIL_CONFIG_0"));
            rte.initCause(e);
            throw rte;
        }
        return messageID;
    }
}

