/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.loader.CmsXmlContentLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsXmlContainerPageLoader
extends CmsXmlContentLoader {
    public static final int CONTAINER_PAGE_RESOURCE_LOADER_ID = 11;

    @Override
    public int getLoaderId() {
        return 11;
    }

    @Override
    public String getResourceLoaderInfo() {
        return Messages.get().getBundle().key("GUI_LOADER_CONTAINERPAGE_DEFAULT_DESC_0");
    }

    @Override
    public boolean isUsableForTemplates() {
        return true;
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsTemplateLoaderFacade loaderFacade = OpenCms.getResourceManager().getTemplateLoaderFacade(cms, req, resource, this.getTemplatePropertyDefinition());
        CmsTemplateContext context = loaderFacade.getTemplateContext();
        req.setAttribute("templateContext", (Object)context);
        CmsJspStandardContextBean.TemplateBean templateBean = new CmsJspStandardContextBean.TemplateBean(context != null ? context.getKey() : loaderFacade.getTemplateName(), loaderFacade.getTemplate());
        req.setAttribute("ATTR_TEMPLATE_BEAN", (Object)templateBean);
        loaderFacade.getLoader().load(cms, loaderFacade.getLoaderStartResource(), req, res);
    }

    @Override
    protected String getTemplatePropertyDefinition() {
        return "template";
    }

    @Override
    protected CmsXmlContainerPage unmarshalXmlDocument(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsException {
        return CmsXmlContainerPageFactory.unmarshal(cms, resource, req);
    }
}

