/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.shared.CmsTemplateContextInfo;
import org.opencms.loader.A_CmsXmlDocumentLoader;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsDefaultSet;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsTemplateContextManager {
    public static final String ATTR_TEMPLATE_BEAN = "ATTR_TEMPLATE_BEAN";
    public static final String ATTR_TEMPLATE_CONTEXT = "templateContext";
    public static final String ATTR_TEMPLATE_NAME = "cmsTemplateName";
    public static final String ATTR_TEMPLATE_RESOURCE = "cmsTemplateResource";
    public static final String DYNAMIC_TEMPLATE_PREFIX = "dynamic:";
    private static final Log LOG = CmsLog.getLog(CmsTemplateContextManager.class);
    private CmsObject m_cms;
    private Map<String, I_CmsTemplateContextProvider> m_providerInstances = new HashMap<String, I_CmsTemplateContextProvider>();

    public CmsTemplateContextManager(CmsObject cms) {
        this.m_cms = cms;
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_RESOURCE);
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_CONTEXT);
        CmsFlexController.registerUncacheableAttribute(ATTR_TEMPLATE_RESOURCE);
    }

    public CmsTemplateContextInfo getContextInfoBean(CmsObject cms, HttpServletRequest request) {
        CmsTemplateContextInfo result = new CmsTemplateContextInfo();
        CmsTemplateContext context = (CmsTemplateContext)request.getAttribute(ATTR_TEMPLATE_CONTEXT);
        if (context != null) {
            result.setCurrentContext(context.getKey());
            I_CmsTemplateContextProvider provider = context.getProvider();
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            CmsXmlContentProperty settingDefinition = this.createTemplateContextsPropertyDefinition(provider, locale);
            result.setSettingDefinition(settingDefinition);
            String cookieName = context.getProvider().getOverrideCookieName();
            if (cookieName != null) {
                String cookieValue = CmsRequestUtil.getCookieValue(request.getCookies(), cookieName);
                result.setSelectedContext(cookieValue);
            }
            result.setCookieName(cookieName);
            HashMap<String, String> niceNames = new HashMap<String, String>();
            for (Map.Entry<String, CmsTemplateContext> entry : provider.getAllContexts().entrySet()) {
                CmsTemplateContext otherContext = entry.getValue();
                String niceName = otherContext.getLocalizedName(locale);
                niceNames.put(otherContext.getKey(), niceName);
            }
            result.setContextLabels(niceNames);
            result.setContextProvider(provider.getClass().getName());
        }
        Map<String, CmsDefaultSet<String>> allowedContextMap = this.safeGetAllowedContextMap();
        result.setAllowedContexts(allowedContextMap);
        return result;
    }

    public CmsTemplateContext getTemplateContext(String providerName, CmsObject cms, HttpServletRequest request, CmsResource resource) {
        Map<String, CmsTemplateContext> contextMap;
        String cookieValue;
        I_CmsTemplateContextProvider provider = this.getTemplateContextProvider(providerName);
        if (provider == null) {
            return null;
        }
        String cookieName = provider.getOverrideCookieName();
        if (cookieName != null && (cookieValue = CmsRequestUtil.getCookieValue(request.getCookies(), cookieName)) != null && (contextMap = provider.getAllContexts()).containsKey(cookieValue)) {
            return contextMap.get(cookieValue);
        }
        return provider.getTemplateContext(cms, request, resource);
    }

    public I_CmsTemplateContextProvider getTemplateContextProvider(CmsObject cms, String path) throws CmsException {
        CmsResource resource = cms.readResource(path);
        I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(resource);
        if (loader instanceof A_CmsXmlDocumentLoader) {
            String propertyValue;
            List<CmsProperty> properties;
            String propertyName = ((A_CmsXmlDocumentLoader)loader).getTemplatePropertyDefinition();
            CmsProperty property = CmsProperty.get(propertyName, properties = cms.readPropertyObjects(resource, true));
            if (property != null && !property.isNullProperty() && (propertyValue = property.getValue()).startsWith(DYNAMIC_TEMPLATE_PREFIX)) {
                return this.getTemplateContextProvider(propertyValue.substring(DYNAMIC_TEMPLATE_PREFIX.length()));
            }
            return null;
        }
        return null;
    }

    public I_CmsTemplateContextProvider getTemplateContextProvider(String providerName) {
        I_CmsTemplateContextProvider result;
        if ((providerName = providerName.trim()).startsWith(DYNAMIC_TEMPLATE_PREFIX)) {
            providerName = providerName.substring(DYNAMIC_TEMPLATE_PREFIX.length());
        }
        if ((result = this.m_providerInstances.get(providerName)) == null) {
            try {
                Class<?> providerClass = Class.forName(providerName);
                if (I_CmsTemplateContextProvider.class.isAssignableFrom(providerClass)) {
                    result = (I_CmsTemplateContextProvider)providerClass.newInstance();
                    result.initialize(this.m_cms);
                    this.m_providerInstances.put(providerName, result);
                }
            }
            catch (Throwable t) {
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
        }
        return result;
    }

    public boolean shouldShowType(CmsTemplateContext context, String typeName) {
        Map<String, CmsDefaultSet<String>> allowedContextMap = this.safeGetAllowedContextMap();
        CmsDefaultSet<String> allowedContexts = allowedContextMap.get(typeName);
        if (allowedContexts == null) {
            return true;
        }
        return allowedContexts.contains(context.getKey());
    }

    protected CmsXmlContentProperty createTemplateContextsPropertyDefinition(I_CmsTemplateContextProvider contextProvider, Locale locale) {
        if (contextProvider == null) {
            return null;
        }
        ArrayList<String> contextOptions = new ArrayList<String>();
        for (CmsTemplateContext context : contextProvider.getAllContexts().values()) {
            contextOptions.add(context.getKey() + ":" + context.getLocalizedName(locale));
        }
        String widgetConfig = CmsStringUtil.listAsString(contextOptions, "|");
        String niceName = Messages.get().getBundle(locale).key("GUI_SETTING_TEMPLATE_CONTEXTS_NAME_0");
        String description = Messages.get().getBundle(locale).key("GUI_SETTING_TEMPLATE_CONTEXTS_DESCRIPTION_0");
        CmsXmlContentProperty propDef = new CmsXmlContentProperty("templateContexts", "string", "multicheck", widgetConfig, null, null, "", niceName, description, "", "false");
        return propDef;
    }

    protected Map<String, CmsDefaultSet<String>> safeGetAllowedContextMap() {
        try {
            return OpenCms.getResourceManager().getAllowedContextMap(this.m_cms);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Collections.emptyMap();
        }
    }
}

