/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.util.CmsJspDeviceSelector;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.I_CmsTemplateContextProvider;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsDefaultTemplateContextProvider
implements I_CmsTemplateContextProvider {
    private static final Log LOG = CmsLog.getLog(CmsDefaultTemplateContextProvider.class);
    private Map<String, CmsTemplateContext> m_map = new HashMap<String, CmsTemplateContext>();
    private CmsJspDeviceSelector m_selector = new CmsJspDeviceSelector();

    @Override
    public synchronized Map<String, CmsTemplateContext> getAllContexts() {
        return Collections.unmodifiableMap(this.m_map);
    }

    public String getConfigurationPropertyPath() {
        return null;
    }

    @Override
    public String getEditorStyleSheet(CmsObject cms, String editedResourcePath) {
        String templatePath = this.m_map.get("desktop").getTemplatePath();
        String result = null;
        try {
            CmsProperty property = cms.readPropertyObject(templatePath, "template", true);
            if (!property.isNullProperty()) {
                result = property.getValue();
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public CmsMessageContainer getMessageContainerDesktop() {
        return null;
    }

    public CmsMessageContainer getMessageContainerMobile() {
        return null;
    }

    @Override
    public String getOverrideCookieName() {
        return "templatecontext";
    }

    @Override
    public synchronized CmsTemplateContext getTemplateContext(CmsObject cms, HttpServletRequest request, CmsResource resource) {
        String deviceType = this.m_selector.getDeviceType(request);
        if (deviceType.equals("mobile")) {
            return this.m_map.get("mobile");
        }
        return this.m_map.get("desktop");
    }

    @Override
    public void initialize(CmsObject cms) {
        try {
            InputStream stream = null;
            if (this.getConfigurationPropertyPath() != null) {
                try {
                    CmsObject clone = OpenCms.initCmsObject(cms);
                    clone.getRequestContext().setSiteRoot("");
                    CmsResource res = clone.readResource(this.getConfigurationPropertyPath());
                    if (res != null) {
                        CmsFile file = cms.readFile(res);
                        stream = new ByteArrayInputStream(file.getContents());
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Could not cerate input stream for given configuration path: " + this.getConfigurationPropertyPath()), (Throwable)e);
                }
            }
            if (stream == null) {
                stream = this.getClass().getClassLoader().getResourceAsStream("templatecontext.properties");
            }
            Properties properties = new Properties();
            properties.load(stream);
            stream.close();
            String templateMobile = properties.getProperty("template.mobile");
            String templateDesktop = properties.getProperty("template.desktop");
            CmsTemplateContext mobile = new CmsTemplateContext("mobile", templateMobile, this.getMessageContainerMobile(), this);
            this.m_map.put(mobile.getKey(), mobile);
            CmsTemplateContext desktop = new CmsTemplateContext("desktop", templateDesktop, this.getMessageContainerDesktop(), this);
            this.m_map.put(desktop.getKey(), desktop);
        }
        catch (Throwable t) {
            LOG.error((Object)t.getLocalizedMessage(), t);
        }
    }
}

