/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.Factory;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.I_CmsFileNameGenerator;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.PrintfFormat;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.content.CmsNumberSuffixNameSequence;

public class CmsDefaultFileNameGenerator
implements I_CmsFileNameGenerator {
    private static final String MACRO_NUMBER_START = "%(number:";

    @Override
    public String getNewFileName(CmsObject cms, String namePattern, int defaultDigits) throws CmsException {
        String checkPattern = cms.getRequestContext().removeSiteRoot(namePattern);
        String folderName = CmsResource.getFolderPath(checkPattern);
        List<CmsResource> resources = cms.readResources(folderName, CmsResourceFilter.ALL, false);
        ArrayList<String> fileNames = new ArrayList<String>(resources.size());
        for (CmsResource res : resources) {
            fileNames.add(cms.getSitePath(res));
        }
        return this.getNewFileNameFromList(fileNames, checkPattern, defaultDigits);
    }

    @Override
    public String getUniqueFileName(CmsObject cms, String parentFolder, String baseName) {
        Iterator<String> nameIterator = this.getUrlNameSequence(baseName);
        String result = nameIterator.next();
        while (cms.existsResource(CmsStringUtil.joinPaths(parentFolder, result), CmsResourceFilter.ALL)) {
            result = nameIterator.next();
        }
        return result;
    }

    @Override
    public Iterator<String> getUrlNameSequence(String baseName) {
        String translatedTitle = OpenCms.getResourceManager().getFileTranslator().translateResource(baseName).replace("/", "-");
        return new CmsNumberSuffixNameSequence(translatedTitle);
    }

    protected String getNewFileNameFromList(List<String> fileNames, String checkPattern, int defaultDigits) {
        String checkTempFileName;
        String checkFileName;
        CmsMacroResolver resolver = CmsMacroResolver.newInstance();
        String macro = "number";
        int useDigits = defaultDigits;
        int prefixIndex = checkPattern.indexOf(MACRO_NUMBER_START);
        if (prefixIndex >= 0) {
            char n = checkPattern.charAt(prefixIndex + MACRO_NUMBER_START.length());
            macro = macro + ':' + n;
            useDigits = Character.getNumericValue(n);
        }
        CmsNumberFactory numberFactory = new CmsNumberFactory(useDigits);
        resolver.addDynamicMacro(macro, numberFactory);
        int j = 0;
        do {
            numberFactory.setNumber(++j);
            checkFileName = resolver.resolveMacros(checkPattern);
            checkTempFileName = CmsWorkplace.getTemporaryFileName(checkFileName);
        } while (fileNames.contains(checkFileName) || fileNames.contains(checkTempFileName));
        return checkFileName;
    }

    public class CmsNumberFactory
    implements Factory {
        private int m_number;
        private PrintfFormat m_numberFormat;

        public CmsNumberFactory(int digits) {
            this.m_numberFormat = new PrintfFormat("%0." + digits + "d");
            this.m_number = 0;
        }

        public Object create() {
            return this.m_numberFormat.sprintf(this.m_number);
        }

        public void setNumber(int number) {
            this.m_number = number;
        }
    }
}

