/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.Messages;
import org.opencms.jsp.parse.A_CmsConfiguredHtmlParser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsJspTagParse
extends BodyTagSupport {
    public static final String ATT_VISITOR_CLASS = "parserClass";
    public static final String TAG_NAME = "parse";
    private static final Log LOG = CmsLog.getLog(CmsJspTagParse.class);
    private static final long serialVersionUID = -6541745426202242240L;
    private String m_configuredParserClassname;
    private List<String> m_noAutoCloseTags;
    private String m_param = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            String content = "";
            try {
                if (CmsStringUtil.isEmpty(this.m_configuredParserClassname) && LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("GUI_ERR_TAG_ATTRIBUTE_MISSING_2", new Object[]{TAG_NAME, ATT_VISITOR_CLASS}));
                }
                try {
                    Class<?> cl = Class.forName(this.m_configuredParserClassname);
                    Object instance = cl.newInstance();
                    A_CmsConfiguredHtmlParser parser = (A_CmsConfiguredHtmlParser)instance;
                    parser.setParam(this.m_param);
                    CmsFlexController controller = CmsFlexController.getController(req);
                    CmsObject cms = controller.getCmsObject();
                    parser.setCmsObject(cms);
                    content = this.parseTagAction(this.getBodyContent().getString(), this.pageContext, parser);
                }
                catch (Exception e) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("GUI_ERR_TAG_ATTRIBUTE_INVALID_3", new Object[]{TAG_NAME, ATT_VISITOR_CLASS, A_CmsConfiguredHtmlParser.class.getName()}), (Throwable)e);
                    }
                    e.printStackTrace(System.err);
                }
            }
            finally {
                try {
                    this.getBodyContent().clear();
                    this.getBodyContent().print(content);
                    this.getBodyContent().writeOut((Writer)this.pageContext.getOut());
                    this.release();
                }
                catch (Exception ex) {
                    this.release();
                    if (LOG.isErrorEnabled()) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", TAG_NAME), (Throwable)ex);
                    }
                    throw new JspException((Throwable)ex);
                }
            }
        }
        return 6;
    }

    public String getNoAutoCloseTags() {
        StringBuffer result = new StringBuffer();
        if (this.m_noAutoCloseTags != null && this.m_noAutoCloseTags.size() > 0) {
            Iterator<String> it = this.m_noAutoCloseTags.iterator();
            while (it.hasNext()) {
                result.append(it.next()).append(',');
            }
        }
        return result.toString();
    }

    public String getParam() {
        return this.m_param;
    }

    public String getParserClass() {
        return this.m_configuredParserClassname;
    }

    public String parseTagAction(String content, PageContext context, A_CmsConfiguredHtmlParser parser) {
        String result = null;
        CmsRequestContext cmsContext = CmsFlexController.getCmsObject(context.getRequest()).getRequestContext();
        if (parser == null) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle(cmsContext.getLocale()).key("GUI_ERR_TAG_ATTRIBUTE_MISSING_2", new Object[]{TAG_NAME, ATT_VISITOR_CLASS}));
            }
            result = content;
        } else {
            String encoding = cmsContext.getEncoding();
            try {
                result = parser.doParse(content, encoding, this.m_noAutoCloseTags);
            }
            catch (ParserException pex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle(cmsContext.getLocale()).key("ERR_PROCESS_TAG_1", new Object[]{TAG_NAME}), (Throwable)pex);
                }
                StringWriter stackTrace = new StringWriter();
                PrintWriter writer = new PrintWriter(new StringWriter());
                StringBuffer msg = new StringBuffer("<!--\n").append(pex.getLocalizedMessage()).append("\n");
                pex.printStackTrace(writer);
                msg.append(stackTrace.toString()).append("\n-->");
                result = msg.toString();
            }
            catch (CmsException cmex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle(cmsContext.getLocale()).key("ERR_PROCESS_TAG_1", new Object[]{TAG_NAME}), (Throwable)cmex);
                }
                StringWriter stackTrace = new StringWriter();
                PrintWriter writer = new PrintWriter(new StringWriter());
                StringBuffer msg = new StringBuffer("<!--\n").append(cmex.getLocalizedMessage()).append("\n");
                cmex.printStackTrace(writer);
                msg.append(stackTrace.toString()).append("\n-->");
                result = msg.toString();
            }
        }
        return result;
    }

    public void release() {
        this.m_configuredParserClassname = null;
        this.m_param = null;
        super.release();
    }

    public void setNoAutoCloseTags(String noAutoCloseTagList) {
        this.m_noAutoCloseTags = CmsStringUtil.splitAsList(noAutoCloseTagList, ',');
    }

    public void setParam(String param) {
        this.m_param = param;
    }

    public void setParserClass(String parserClass) {
        this.m_configuredParserClassname = parserClass;
    }
}

