/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUriSplitter;

public class CmsJspTagImage
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    private static final String ATTR_ALIGN = "align";
    private static final String ATTR_ALT = "alt";
    private static final String ATTR_BORDER = "border";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_HSPACE = "hspace";
    private static final String ATTR_ID = "id";
    private static final String ATTR_LONGDESC = "longdesc";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_STYLE = "style";
    private static final String ATTR_TITLE = "title";
    private static final String ATTR_USEMAP = "usemap";
    private static final String ATTR_VSPACE = "vspace";
    private static final Log LOG = CmsLog.getLog(CmsJspTagImage.class);
    private static final String SCALE_ATTR_COLOR = "scalecolor";
    private static final String SCALE_ATTR_FILTER = "scalefilter";
    private static final String SCALE_ATTR_HEIGHT = "height";
    private static final String SCALE_ATTR_MAXHEIGHT = "maxHeight";
    private static final String SCALE_ATTR_MAXWIDTH = "maxWidth";
    private static final String SCALE_ATTR_PARTIALTAG = "partialtag";
    private static final String SCALE_ATTR_POSITION = "scaleposition";
    private static final String SCALE_ATTR_QUALITY = "scalequality";
    private static final String SCALE_ATTR_RENDERMODE = "scalerendermode";
    private static final String SCALE_ATTR_SRC = "src";
    private static final String SCALE_ATTR_TYPE = "scaletype";
    private static final String SCALE_ATTR_WIDTH = "width";
    private static final String[] SCALER_ATTRS = new String[]{"scalecolor", "scalefilter", "height", "partialtag", "scaleposition", "scalequality", "scalerendermode", "src", "scaletype", "width", "maxHeight", "maxWidth"};
    private static final List<String> SCALER_ATTRS_LIST = Arrays.asList(SCALER_ATTRS);
    private static final long serialVersionUID = 6513320107441256414L;
    private Map<String, String> m_attributes;
    private boolean m_partialTag;
    private transient CmsImageScaler m_scaler = new CmsImageScaler();
    private String m_src;

    public static CmsImageScaler getScaler(CmsImageScaler scaler, CmsImageScaler original, String scaleParam) {
        if (scaleParam != null) {
            CmsImageScaler cropScaler = null;
            cropScaler = new CmsImageScaler(scaleParam);
            if (scaler.getType() == 5) {
                cropScaler.setWidth(cropScaler.getCropWidth());
                cropScaler.setHeight(cropScaler.getCropHeight());
            }
            scaler = cropScaler.getCropScaler(scaler);
        }
        if ((scaler.getHeight() <= 0 || scaler.getWidth() <= 0 || scaler.getType() == 5 && scaler.isValid() && !scaler.isCropping()) && original.isValid()) {
            scaler = original.getReScaler(scaler);
        }
        return scaler;
    }

    public static String imageTagAction(String src, CmsImageScaler scaler, Map<String, String> attributes, boolean partialTag, ServletRequest req) throws CmsException {
        String[] scaleStr;
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        src = CmsLinkManager.getAbsoluteUri(src, controller.getCurrentRequest().getElementUri());
        CmsUriSplitter splitSrc = new CmsUriSplitter(src);
        String scaleParam = null;
        if (splitSrc.getQuery() != null && (scaleStr = CmsRequestUtil.createParameterMap(splitSrc.getQuery()).get("__scale")) != null) {
            scaleParam = scaleStr[0];
        }
        CmsResource imageRes = cms.readResource(splitSrc.getPrefix());
        CmsImageScaler original = new CmsImageScaler(cms, imageRes);
        scaler = CmsJspTagImage.getScaler(scaler, original, scaleParam);
        StringBuffer result = new StringBuffer(128);
        if (!partialTag) {
            result.append("<img");
        }
        result.append(" src=\"");
        String imageLink = cms.getSitePath(imageRes);
        if (scaler.isValid()) {
            imageLink = imageLink + scaler.toRequestParam();
        }
        result.append(OpenCms.getLinkManager().substituteLink(cms, imageLink));
        result.append("\"");
        if (scaler.isValid()) {
            result.append(" width=\"");
            result.append(scaler.getWidth());
            result.append("\"");
            result.append(" height=\"");
            result.append(scaler.getHeight());
            result.append("\"");
        }
        if (attributes != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                String attr = entry.getKey();
                String value = entry.getValue();
                result.append(" ");
                result.append(attr);
                result.append("=\"");
                result.append(CmsEncoder.escapeXml(value));
                result.append("\"");
            }
        }
        if (!partialTag) {
            result.append(" />");
        }
        return result.toString();
    }

    @Override
    public void addParameter(String name, String value) {
        String key = name.trim().toLowerCase();
        switch (SCALER_ATTRS_LIST.indexOf(key)) {
            case 0: {
                this.setScaleColor(value);
                break;
            }
            case 1: {
                this.setScaleFilter(value);
                break;
            }
            case 2: {
                this.setHeight(value);
                break;
            }
            case 3: {
                this.setPartialTag(value);
                break;
            }
            case 4: {
                this.setScalePosition(value);
                break;
            }
            case 5: {
                this.setScaleQuality(value);
                break;
            }
            case 6: {
                this.setScaleRendermode(value);
                break;
            }
            case 7: {
                this.setSrc(value);
                break;
            }
            case 8: {
                this.setScaleType(value);
                break;
            }
            case 9: {
                this.setWidth(value);
                break;
            }
            default: {
                this.setAttribute(key, value);
            }
        }
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        if (CmsFlexController.isCmsRequest(req)) {
            try {
                String imageTag;
                block6: {
                    imageTag = null;
                    try {
                        imageTag = CmsJspTagImage.imageTagAction(this.m_src, this.m_scaler, this.m_attributes, this.m_partialTag, req);
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) break block6;
                        LOG.warn((Object)Messages.get().getBundle().key("ERR_IMAGE_TAG_VFS_ACCESS_1", this.m_src), (Throwable)e);
                    }
                }
                this.pageContext.getOut().print(imageTag == null ? "" : imageTag);
            }
            catch (Exception ex) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_PROCESS_TAG_1", "image"), (Throwable)ex);
                }
                throw new JspException((Throwable)ex);
            }
        }
        this.release();
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getAlign() {
        return this.getAttribute(ATTR_ALIGN);
    }

    public String getAlt() {
        return this.getAttribute(ATTR_ALT);
    }

    public String getBorder() {
        return this.getAttribute(ATTR_BORDER);
    }

    public String getCssclass() {
        return this.getAttribute(ATTR_CLASS);
    }

    public String getHeight() {
        return String.valueOf(this.m_scaler.getHeight());
    }

    public String getHspace() {
        return this.getAttribute(ATTR_HSPACE);
    }

    public String getId() {
        return this.getAttribute(ATTR_ID);
    }

    public String getLongdesc() {
        return this.getAttribute(ATTR_LONGDESC);
    }

    public String getMaxHeight() {
        return String.valueOf(this.m_scaler.getMaxHeight());
    }

    public String getMaxWidth() {
        return String.valueOf(this.m_scaler.getMaxWidth());
    }

    public String getName() {
        return this.getAttribute(ATTR_NAME);
    }

    public String getScaleColor() {
        return this.m_scaler.getColorString();
    }

    public String getScaleFilter() {
        return this.m_scaler.getFiltersString();
    }

    public String getScalePosition() {
        return String.valueOf(this.m_scaler.getPosition());
    }

    public String getScaleQuality() {
        return String.valueOf(this.m_scaler.getQuality());
    }

    public String getScaleRendermode() {
        return String.valueOf(this.m_scaler.getRenderMode());
    }

    public String getScaleType() {
        return String.valueOf(this.m_scaler.getType());
    }

    public String getSrc() {
        return this.m_src;
    }

    public String getStyle() {
        return this.getAttribute(ATTR_STYLE);
    }

    public String getTitle() {
        return this.getAttribute(ATTR_TITLE);
    }

    public String getUsemap() {
        return this.getAttribute(ATTR_USEMAP);
    }

    public String getVspace() {
        return this.getAttribute(ATTR_VSPACE);
    }

    public String getWidth() {
        return String.valueOf(this.m_scaler.getWidth());
    }

    public String isPartialTag() {
        return String.valueOf(this.m_partialTag);
    }

    public void release() {
        this.m_attributes = null;
        this.m_scaler = new CmsImageScaler();
        this.m_partialTag = false;
        this.m_src = null;
        super.release();
    }

    public void setAlign(String value) {
        this.setAttribute(ATTR_ALIGN, value);
    }

    public void setAlt(String value) {
        this.setAttribute(ATTR_ALT, value, true);
    }

    public void setBorder(String value) {
        this.setAttribute(ATTR_BORDER, value);
    }

    public void setCssclass(String value) {
        this.setAttribute(ATTR_CLASS, value);
    }

    public void setHeight(String value) {
        this.m_scaler.setHeight(CmsStringUtil.getIntValueRounded(value, 0, SCALE_ATTR_HEIGHT));
    }

    public void setHspace(String value) {
        this.setAttribute(ATTR_HSPACE, value);
    }

    public void setId(String value) {
        this.setAttribute(ATTR_ID, value);
    }

    public void setLongdesc(String value) {
        this.setAttribute(ATTR_LONGDESC, value);
    }

    public void setMaxHeight(String value) {
        this.m_scaler.setMaxHeight(CmsStringUtil.getIntValueRounded(value, -1, SCALE_ATTR_MAXHEIGHT));
    }

    public void setMaxWidth(String value) {
        this.m_scaler.setMaxWidth(CmsStringUtil.getIntValueRounded(value, -1, SCALE_ATTR_MAXWIDTH));
    }

    public void setName(String value) {
        this.setAttribute(ATTR_NAME, value);
    }

    public void setPartialTag(String partialTag) {
        this.m_partialTag = Boolean.valueOf(partialTag);
    }

    public void setScaleColor(String value) {
        this.m_scaler.setColor(value);
    }

    public void setScaleFilter(String value) {
        this.m_scaler.setFilters(value);
    }

    public void setScalePosition(String value) {
        this.m_scaler.setPosition(CmsStringUtil.getIntValue(value, 0, SCALE_ATTR_POSITION));
    }

    public void setScaleQuality(String value) {
        this.m_scaler.setQuality(CmsStringUtil.getIntValue(value, 0, SCALE_ATTR_QUALITY));
    }

    public void setScaleRendermode(String value) {
        this.m_scaler.setRenderMode(CmsStringUtil.getIntValue(value, 0, SCALE_ATTR_RENDERMODE));
    }

    public void setScaleType(String value) {
        this.m_scaler.setType(CmsStringUtil.getIntValue(value, 0, SCALE_ATTR_TYPE));
    }

    public void setSrc(String value) {
        this.m_src = value;
    }

    public void setStyle(String value) {
        this.setAttribute(ATTR_STYLE, value);
    }

    public void setTitle(String value) {
        this.setAttribute(ATTR_TITLE, value);
    }

    public void setUsemap(String value) {
        this.setAttribute(ATTR_USEMAP, value);
    }

    public void setVspace(String value) {
        this.setAttribute(ATTR_VSPACE, value);
    }

    public void setWidth(String value) {
        this.m_scaler.setWidth(CmsStringUtil.getIntValueRounded(value, 0, SCALE_ATTR_WIDTH));
    }

    private String getAttribute(String key) {
        if (this.m_attributes != null) {
            return this.m_attributes.get(key);
        }
        return null;
    }

    private void setAttribute(String key, String value) {
        this.setAttribute(key, value, false);
    }

    private void setAttribute(String key, String value, boolean allowEmptyValue) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) || allowEmptyValue && value != null) {
            if (this.m_attributes == null) {
                this.m_attributes = new HashMap<String, String>();
            }
            this.m_attributes.put(key, value);
        }
    }
}

