/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagLink;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsJspTagHeadIncludes
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    public static final String TYPE_CSS = "css";
    public static final String TYPE_JAVASCRIPT = "javascript";
    private static final Log LOG = CmsLog.getLog(CmsJspTagHeadIncludes.class);
    private static final long serialVersionUID = 5496349529835666345L;
    private String m_closeTags;
    private String m_defaults;
    private Map<String, String[]> m_parameterMap;
    private String m_type;

    public static void addParameter(Map<String, String[]> parameters, String name, String value, boolean overwrite) {
        if (parameters == null || name == null || value == null) {
            return;
        }
        if (parameters.containsKey(name) && !overwrite) {
            String[] values = parameters.get(name);
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            parameters.put(name, newValues);
        } else {
            String[] values = new String[]{value};
            parameters.put(name, values);
        }
    }

    public static Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getCSSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    public static Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsLoaderException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        if (resType instanceof CmsResourceTypeXmlContent) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getJSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.m_parameterMap == null) {
            this.m_parameterMap = new HashMap<String, String[]>();
        }
        CmsJspTagHeadIncludes.addParameter(this.m_parameterMap, name, value, false);
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        try {
            if (TYPE_CSS.equals(this.m_type)) {
                this.tagCssAction(cms, req);
            }
            if (TYPE_JAVASCRIPT.equals(this.m_type)) {
                this.tagJSAction(cms, req);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.m_parameterMap = null;
        }
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getDefaults() {
        return this.m_defaults;
    }

    public String getType() {
        return this.m_type;
    }

    public void setClosetags(String closeTags) {
        this.m_closeTags = closeTags;
    }

    public void setDefaults(String defaults) {
        this.m_defaults = defaults;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public boolean shouldCloseTags() {
        if (this.m_closeTags == null) {
            return true;
        }
        return Boolean.parseBoolean(this.m_closeTags);
    }

    public void tagCssAction(CmsObject cms, ServletRequest req) throws CmsException, IOException {
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        LinkedHashSet<String> cssIncludes = new LinkedHashSet<String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                cssIncludes.add(defaults[i]);
            }
        }
        if (containerPage != null && containerPage.getElements() != null) {
            for (CmsContainerElementBean element : containerPage.getElements()) {
                try {
                    element.initResource(cms);
                    cssIncludes.addAll(CmsJspTagHeadIncludes.getCSSHeadIncludes(cms, element.getResource()));
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                }
            }
        }
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId());
                cssIncludes.addAll(CmsJspTagHeadIncludes.getCSSHeadIncludes(cms, detailContent));
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String cssUri : cssIncludes) {
            this.pageContext.getOut().print("<link href=\"" + CmsJspTagLink.linkTagAction(cssUri, req) + this.generateReqParams() + "\" rel=\"stylesheet\" type=\"text/css\">");
            if (!this.shouldCloseTags()) continue;
            this.pageContext.getOut().print("</link>");
        }
    }

    public void tagJSAction(CmsObject cms, ServletRequest req) throws CmsException, IOException {
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        LinkedHashSet<String> jsIncludes = new LinkedHashSet<String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                jsIncludes.add(defaults[i]);
            }
        }
        if (containerPage != null && containerPage.getElements() != null) {
            for (CmsContainerElementBean element : containerPage.getElements()) {
                try {
                    element.initResource(cms);
                    jsIncludes.addAll(CmsJspTagHeadIncludes.getJSHeadIncludes(cms, element.getResource()));
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                }
            }
        }
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId());
                jsIncludes.addAll(CmsJspTagHeadIncludes.getJSHeadIncludes(cms, detailContent));
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String jsUri : jsIncludes) {
            this.pageContext.getOut().print("<script type=\"text/javascript\" src=\"" + CmsJspTagLink.linkTagAction(jsUri, req) + this.generateReqParams() + "\"></script>");
        }
    }

    private String generateReqParams() throws UnsupportedEncodingException {
        String params = "";
        if (this.m_parameterMap != null && !this.m_parameterMap.isEmpty()) {
            for (Map.Entry<String, String[]> paramEntry : this.m_parameterMap.entrySet()) {
                if (paramEntry.getValue() == null) continue;
                for (int i = 0; i < paramEntry.getValue().length; ++i) {
                    params = params + "&" + paramEntry.getKey() + "=" + URLEncoder.encode(paramEntry.getValue()[i], "UTF-8");
                }
            }
            params = "?" + params.substring(1);
        }
        return params;
    }

    private CmsJspStandardContextBean getStandardContext(CmsObject cms, ServletRequest req) throws CmsException {
        String requestUri = cms.getRequestContext().getUri();
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        if (containerPage == null) {
            CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(req));
            if (pageResource == null) {
                pageResource = cms.readResource(requestUri);
            }
            CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource, req);
            containerPage = xmlContainerPage.getContainerPage(cms, cms.getRequestContext().getLocale());
            standardContext.setPage(containerPage);
        }
        return standardContext;
    }
}

