/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.CmsJspTagInclude;
import org.opencms.main.OpenCms;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;

public class CmsJspTagEnableAde
extends BodyTagSupport {
    private static final String INCLUDE_JSP_URI = "/system/modules/org.opencms.ade.containerpage/containerpage_include.jsp";
    private static final long serialVersionUID = 8447599916548975733L;

    public static void enableAdeTagAction(PageContext context) throws JspException {
        ServletRequest req = context.getRequest();
        if (CmsHistoryResourceHandler.isHistoryRequest(req)) {
            return;
        }
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return;
        }
        if (CmsResource.isTemporaryFileName(cms.getRequestContext().getUri())) {
            return;
        }
        if (CmsJspTagEditable.isDirectEditDisabled(req)) {
            return;
        }
        CmsAdvancedDirectEditProvider eb = new CmsAdvancedDirectEditProvider();
        eb.init(cms, CmsDirectEditMode.TRUE, "");
        CmsJspTagEditable.setDirectEditProvider(context, eb);
        CmsJspTagInclude.includeTagAction(context, INCLUDE_JSP_URI, null, false, null, null, req, context.getResponse());
    }

    public int doEndTag() throws JspException {
        CmsJspTagEnableAde.enableAdeTagAction(this.pageContext);
        if (OpenCms.getSystemInfo().getServletContainerSettings().isReleaseTagsAfterEnd()) {
            this.release();
        }
        return 6;
    }

    public int doStartTag() {
        return 1;
    }
}

