/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsContentInfoBean;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.CmsJspTagResourceLoad;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspContentLoadBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.directedit.CmsDirectEditButtonSelection;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;
import org.opencms.workplace.editors.directedit.CmsDirectEditParams;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsJspTagContentLoad
extends CmsJspTagResourceLoad
implements I_CmsXmlContentContainer {
    private static final long serialVersionUID = 981176995635225294L;
    private transient I_CmsXmlDocument m_content;
    private Locale m_contentLocale;
    private CmsDirectEditButtonSelection m_directEditFollowButtons;
    private String m_directEditLinkForNew;
    private CmsDirectEditMode m_directEditMode;
    private boolean m_directEditOpen;
    private boolean m_isFirstLoop;
    private Locale m_locale;

    public CmsJspTagContentLoad() {
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, Locale locale, boolean editable) throws JspException {
        this(container, context, collectorName, collectorParam, null, null, locale, editable);
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, String pageIndex, String pageSize, Locale locale, boolean editable) throws JspException {
        this(container, context, collectorName, collectorParam, pageIndex, pageSize, locale, CmsDirectEditMode.valueOf(editable));
    }

    public CmsJspTagContentLoad(I_CmsXmlContentContainer container, PageContext context, String collectorName, String collectorParam, String pageIndex, String pageSize, Locale locale, CmsDirectEditMode editMode) throws JspException {
        this.setCollector(collectorName);
        this.setParam(collectorParam);
        this.setPageIndex(pageIndex);
        this.setPageSize(pageSize);
        this.m_locale = locale;
        this.m_contentLocale = locale;
        this.m_directEditMode = editMode;
        this.m_preload = false;
        this.setPageContext(context);
        this.init(container);
    }

    @Override
    public int doStartTag() throws JspException, CmsIllegalArgumentException {
        Tag ancestor = CmsJspTagContentLoad.findAncestorWithClass((Tag)this, I_CmsXmlContentContainer.class);
        I_CmsXmlContentContainer container = null;
        if (ancestor != null && !(container = (I_CmsXmlContentContainer)ancestor).isPreloader()) {
            container = null;
        }
        this.init(container);
        this.hasMoreResources();
        return this.isScopeVarSet() ? 0 : 1;
    }

    public String getEditable() {
        return this.m_directEditMode != null ? this.m_directEditMode.toString() : "";
    }

    public String getLocale() {
        return this.m_locale != null ? this.m_locale.toString() : "";
    }

    @Override
    public I_CmsXmlDocument getXmlDocument() {
        return this.m_content;
    }

    @Override
    public String getXmlDocumentElement() {
        return null;
    }

    @Override
    public Locale getXmlDocumentLocale() {
        return this.m_contentLocale;
    }

    @Override
    public boolean hasMoreResources() throws JspException {
        boolean hasMoreContent;
        if (this.m_isFirstLoop) {
            this.m_isFirstLoop = false;
        } else if (this.m_directEditOpen) {
            CmsJspTagEditable.endDirectEdit(this.pageContext);
            this.m_directEditOpen = false;
        }
        if (this.isPreloader()) {
            return false;
        }
        boolean bl = hasMoreContent = this.m_collectorResult.size() > 0;
        if (hasMoreContent) {
            try {
                this.doLoadNextFile();
            }
            catch (CmsException e) {
                this.m_controller.setThrowable(e, this.m_resourceName);
                throw new JspException((Throwable)e);
            }
            if (this.m_directEditMode.isEnabled() && this.m_resourceName != null) {
                CmsDirectEditButtonSelection directEditButtons;
                if (this.m_directEditFollowButtons == null) {
                    if (this.m_directEditLinkForNew == null) {
                        this.m_directEditFollowButtons = directEditButtons = CmsDirectEditButtonSelection.EDIT;
                    } else {
                        directEditButtons = CmsDirectEditButtonSelection.EDIT_DELETE_NEW;
                        this.m_directEditFollowButtons = CmsDirectEditButtonSelection.EDIT_DELETE;
                    }
                } else {
                    directEditButtons = this.m_directEditFollowButtons;
                }
                this.m_directEditOpen = CmsJspTagEditable.startDirectEdit(this.pageContext, new CmsDirectEditParams(this.m_resourceName, directEditButtons, this.m_directEditMode, this.m_directEditLinkForNew));
            }
        } else {
            this.m_locale = null;
        }
        return hasMoreContent;
    }

    @Override
    public void release() {
        this.m_content = null;
        this.m_contentLocale = null;
        this.m_directEditLinkForNew = null;
        this.m_directEditFollowButtons = null;
        this.m_directEditOpen = false;
        this.m_directEditMode = null;
        this.m_isFirstLoop = false;
        this.m_locale = null;
        super.release();
    }

    public void setEditable(String mode) {
        this.m_directEditMode = CmsDirectEditMode.valueOf(mode);
    }

    public void setLocale(String locale) {
        if (CmsStringUtil.isEmpty(locale)) {
            this.m_locale = null;
            this.m_contentLocale = null;
        } else {
            this.m_contentLocale = this.m_locale = CmsLocaleManager.getLocale(locale);
        }
    }

    protected void doLoadNextFile() throws CmsException {
        super.doLoadNextResource();
        if (this.m_resource == null) {
            return;
        }
        CmsFile file = this.m_cms.readFile(this.m_resource);
        this.m_content = CmsXmlContentFactory.unmarshal(this.m_cms, (CmsResource)file, this.pageContext.getRequest());
        this.m_contentLocale = this.m_locale;
        if (!this.m_content.hasLocale(this.m_contentLocale)) {
            for (Locale locale : OpenCms.getLocaleManager().getDefaultLocales()) {
                if (!this.m_content.hasLocale(locale)) continue;
                this.m_contentLocale = locale;
                break;
            }
        }
    }

    protected void init(I_CmsXmlContentContainer container) throws JspException {
        I_CmsXmlContentContainer usedContainer;
        int pageAttribCount = 0;
        pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageSize) ? 1 : 0;
        if ((pageAttribCount += CmsStringUtil.isNotEmpty(this.m_pageIndex) ? 1 : 0) > 0 && pageAttribCount < 2) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_INDEX_SIZE_0"));
        }
        if (container == null) {
            usedContainer = this;
            if (CmsStringUtil.isEmpty(this.m_collector)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_MISSING_COLLECTOR_0"));
            }
            if (CmsStringUtil.isEmpty(this.m_param)) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_TAG_CONTENTLOAD_MISSING_PARAM_0"));
            }
        } else {
            usedContainer = container;
        }
        if (this.isPreloader()) {
            this.m_directEditMode = CmsDirectEditMode.FALSE;
        } else if (this.m_directEditMode == null) {
            this.m_directEditMode = CmsDirectEditMode.FALSE;
        }
        this.m_controller = CmsFlexController.getController(this.pageContext.getRequest());
        this.m_cms = this.m_controller.getCmsObject();
        String resourcename = CmsJspTagContentLoad.getResourceName(this.m_cms, usedContainer);
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(this.m_cms).setJspPageContext(this.pageContext).setResourceName(resourcename).setKeepEmptyMacros(true);
        if (container == null) {
            this.m_collectorName = resolver.resolveMacros(this.getCollector());
            this.m_collectorParam = resolver.resolveMacros(this.getParam());
            this.m_collectorResult = null;
        } else {
            this.m_collectorName = usedContainer.getCollectorName();
            this.m_collectorParam = usedContainer.getCollectorParam();
            this.m_collectorResult = usedContainer.getCollectorResult();
            if (this.m_locale == null) {
                this.m_locale = usedContainer.getXmlDocumentLocale();
            }
        }
        if (this.m_locale == null) {
            this.m_locale = this.m_cms.getRequestContext().getLocale();
        }
        try {
            I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(this.m_collectorName);
            if (collector == null) {
                throw new CmsException(Messages.get().container("ERR_COLLECTOR_NOT_FOUND_1", this.m_collectorName));
            }
            if (this.m_collectorResult == null) {
                this.m_collectorResult = collector.getResults(this.m_cms, this.m_collectorName, this.m_collectorParam);
            }
            this.m_contentInfoBean = new CmsContentInfoBean();
            this.m_contentInfoBean.setPageSizeAsString(resolver.resolveMacros(this.m_pageSize));
            this.m_contentInfoBean.setPageIndexAsString(resolver.resolveMacros(this.m_pageIndex));
            this.m_contentInfoBean.setPageNavLengthAsString(resolver.resolveMacros(this.m_pageNavLength));
            this.m_contentInfoBean.setResultSize(this.m_collectorResult.size());
            this.m_contentInfoBean.setLocale(this.m_locale.toString());
            this.m_contentInfoBean.initResultIndex();
            if (!this.isPreloader()) {
                this.m_collectorResult = CmsJspTagResourceLoad.limitCollectorResult(this.m_contentInfoBean, this.m_collectorResult);
                this.m_contentInfoBean.initPageNavIndexes();
                String createParam = collector.getCreateParam(this.m_cms, this.m_collectorName, this.m_collectorParam);
                if (createParam != null) {
                    this.m_directEditLinkForNew = CmsEncoder.encode(this.m_collectorName + "|" + createParam);
                }
            } else if (this.isScopeVarSet()) {
                CmsJspContentLoadBean bean = new CmsJspContentLoadBean(this.m_cms, this.m_locale, this.m_collectorResult);
                this.storeAttribute(bean);
            }
        }
        catch (CmsException e) {
            this.m_controller.setThrowable(e, this.m_cms.getRequestContext().getUri());
            throw new JspException((Throwable)e);
        }
        this.m_directEditOpen = false;
        this.m_directEditFollowButtons = null;
        this.m_isFirstLoop = true;
    }
}

