/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.opencms.util.CmsStringUtil;

public class CmsJspScopedVarBodyTagSuport
extends BodyTagSupport {
    private static final String[] SCOPES = new String[]{"page", "request", "session", "application"};
    private static final List<String> SCOPES_LIST = Collections.unmodifiableList(Arrays.asList(SCOPES));
    private static final long serialVersionUID = 6521418315921327927L;
    private int m_scope = 1;
    private String m_variable;

    protected static int getScopeAsInt(String scope) {
        int scopeValue;
        switch (SCOPES_LIST.indexOf(scope)) {
            case 3: {
                scopeValue = 4;
                break;
            }
            case 2: {
                scopeValue = 3;
                break;
            }
            case 1: {
                scopeValue = 2;
                break;
            }
            default: {
                scopeValue = 1;
            }
        }
        return scopeValue;
    }

    protected static String getScopeAsString(int scope) {
        if (scope <= 0 || scope > 4) {
            return SCOPES[0];
        }
        return SCOPES[scope - 1];
    }

    public String getScope() {
        return CmsJspScopedVarBodyTagSuport.getScopeAsString(this.m_scope);
    }

    public String getVar() {
        return this.m_variable;
    }

    public void release() {
        this.m_variable = null;
        this.m_scope = 1;
        super.release();
    }

    public void setScope(String scope) {
        if (CmsStringUtil.isNotEmpty(scope)) {
            scope = scope.trim().toLowerCase();
            this.m_scope = CmsJspScopedVarBodyTagSuport.getScopeAsInt(scope);
        } else {
            this.m_scope = 1;
        }
    }

    public void setVar(String var) {
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(var)) {
            this.m_variable = var.trim();
        }
    }

    protected int getScopeInt() {
        return this.m_scope;
    }

    protected boolean isScopeVarSet() {
        return CmsStringUtil.isNotEmpty(this.getVar());
    }

    protected void storeAttribute(Object obj) {
        this.storeAttribute(this.getVar(), obj);
    }

    protected void storeAttribute(String name, Object obj) {
        this.pageContext.setAttribute(name, obj, this.getScopeInt());
    }
}

