/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.importexport;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.importexport.A_CmsImport;
import org.opencms.importexport.CmsImportExportException;
import org.opencms.importexport.CmsImportHelper;
import org.opencms.importexport.CmsImportParameters;
import org.opencms.importexport.Messages;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;

@Deprecated
public class CmsImportVersion4
extends A_CmsImport {
    private static final int IMPORT_VERSION = 4;
    private static final Log LOG = CmsLog.getLog(CmsImportVersion4.class);
    private List<CmsResource> m_parseables;

    public CmsImportVersion4() {
        this.m_convertToXmlPage = true;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Override
    @Deprecated
    public void importResources(CmsObject cms, String importPath, I_CmsReport report, File importResource, ZipFile importZip, Document docXml) throws CmsImportExportException {
        CmsImportParameters params = new CmsImportParameters(importResource != null ? importResource.getAbsolutePath() : importZip.getName(), importPath, true);
        try {
            this.importData(cms, report, params);
        }
        catch (CmsXmlException e) {
            throw new CmsImportExportException(e.getMessageContainer(), (Throwable)e);
        }
    }

    @Override
    public void importData(CmsObject cms, I_CmsReport report, CmsImportParameters params) throws CmsImportExportException, CmsXmlException {
        this.initialize();
        this.m_cms = cms;
        this.m_importPath = params.getDestinationPath();
        this.m_report = report;
        this.m_linkStorage = new HashMap();
        this.m_linkPropertyStorage = new HashMap();
        this.m_parseables = new ArrayList<CmsResource>();
        CmsImportHelper helper = new CmsImportHelper(params);
        try {
            helper.openFile();
            this.m_importResource = helper.getFolder();
            this.m_importZip = helper.getZipFile();
            this.m_docXml = CmsXmlUtils.unmarshalHelper(helper.getFileBytes("manifest.xml"), null);
            if (OpenCms.getRoleManager().hasRole(this.m_cms, CmsRole.ACCOUNT_MANAGER)) {
                this.importGroups();
                this.importUsers();
            }
            this.readResourcesFromManifest();
            this.convertPointerToSiblings();
            this.rewriteParseables();
        }
        catch (IOException ioe) {
            CmsMessageContainer msg = Messages.get().container("ERR_IMPORTEXPORT_ERROR_READING_FILE_1", "manifest.xml");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)msg.key(), (Throwable)ioe);
            }
            throw new CmsImportExportException(msg, (Throwable)ioe);
        }
        finally {
            helper.closeFile();
            this.cleanUp();
        }
    }

    @Override
    protected void importUser(String name, String flags, String password, String firstname, String lastname, String email, long dateCreated, Map<String, Object> userInfo, List<String> userGroups) throws CmsImportExportException {
        boolean convert = false;
        CmsParameterConfiguration config = OpenCms.getPasswordHandler().getConfiguration();
        if (config != null && config.containsKey("compatibility.convert.digestencoding")) {
            convert = config.getBoolean("compatibility.convert.digestencoding", false);
        }
        if (convert) {
            password = this.convertDigestEncoding(password);
        }
        super.importUser(name, flags, password, firstname, lastname, email, dateCreated, userInfo, userGroups);
    }

    protected void rewriteParseables() {
        if (this.m_parseables.isEmpty()) {
            return;
        }
        this.m_report.println(Messages.get().container("RPT_START_PARSE_LINKS_0"), 2);
        int i = 0;
        for (CmsResource res : this.m_parseables) {
            block5: {
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(this.m_parseables.size())), 3);
                this.m_report.print(Messages.get().container("RPT_PARSE_LINKS_FOR_1", this.m_cms.getSitePath(res)), 3);
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                try {
                    CmsFile file = this.m_cms.readFile(res);
                    file.setDateLastModified(res.getDateLastModified());
                    this.m_cms.writeFile(file);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                }
                catch (Throwable e) {
                    this.m_report.addWarning(e);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_REWRITING_1", res.getRootPath()));
                    }
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)e.getLocalizedMessage(), e);
                }
            }
            ++i;
        }
        this.m_report.println(Messages.get().container("RPT_END_PARSE_LINKS_0"), 2);
    }

    private long convertTimestamp(String timestamp) {
        long value = 0L;
        try {
            value = Long.parseLong(timestamp);
        }
        catch (NumberFormatException e) {
            try {
                value = CmsDateUtil.parseHeaderDate(timestamp);
            }
            catch (ParseException pe) {
                value = System.currentTimeMillis();
            }
        }
        return value;
    }

    private CmsResource importResource(String source, String destination, I_CmsResourceType type, String uuidresource, long datelastmodified, String userlastmodified, long datecreated, String usercreated, long datereleased, long dateexpired, String flags, List<CmsProperty> properties) {
        byte[] content = null;
        CmsResource result = null;
        try {
            CmsUUID newUsercreated;
            CmsUUID newUserlastmodified;
            if (source != null) {
                content = this.getFileBytes(source);
            }
            int size = 0;
            if (content != null) {
                size = content.length;
            }
            try {
                newUserlastmodified = this.m_cms.readUser(userlastmodified).getId();
            }
            catch (CmsException e) {
                newUserlastmodified = this.m_cms.getRequestContext().getCurrentUser().getId();
            }
            try {
                newUsercreated = this.m_cms.readUser(usercreated).getId();
            }
            catch (CmsException e) {
                newUsercreated = this.m_cms.getRequestContext().getCurrentUser().getId();
            }
            CmsUUID newUuidresource = null;
            newUuidresource = uuidresource != null && !type.isFolder() ? new CmsUUID(uuidresource) : new CmsUUID();
            CmsResource resource = new CmsResource(new CmsUUID(), newUuidresource, destination, type.getTypeId(), type.isFolder(), new Integer(flags), this.m_cms.getRequestContext().getCurrentProject().getUuid(), CmsResource.STATE_NEW, datecreated, newUsercreated, datelastmodified, newUserlastmodified, datereleased, dateexpired, 1, size, System.currentTimeMillis(), 0);
            result = this.m_cms.importResource(destination, resource, content, properties);
            if (result != null) {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
        }
        catch (Exception exc) {
            this.m_report.println(exc);
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private void readResourcesFromManifest() throws CmsImportExportException {
        List<String> ignoredProperties;
        String source = null;
        String destination = null;
        String uuidresource = null;
        String userlastmodified = null;
        String usercreated = null;
        String flags = null;
        String timestamp = null;
        long datelastmodified = 0L;
        long datecreated = 0L;
        long datereleased = 0L;
        long dateexpired = 0L;
        List fileNodes = null;
        List acentryNodes = null;
        Element currentElement = null;
        Element currentEntry = null;
        List<CmsProperty> properties = null;
        List<String> immutableResources = OpenCms.getImportExportManager().getImmutableResources();
        if (immutableResources == null) {
            immutableResources = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_IMMUTABLE_RESOURCES_SIZE_1", Integer.toString(immutableResources.size())));
        }
        if ((ignoredProperties = OpenCms.getImportExportManager().getIgnoredProperties()) == null) {
            ignoredProperties = Collections.emptyList();
        }
        this.m_convertToXmlPage = OpenCms.getImportExportManager().convertToXmlPage();
        try {
            fileNodes = this.m_docXml.selectNodes("//file");
            int importSize = fileNodes.size();
            for (int i = 0; i < fileNodes.size(); ++i) {
                I_CmsResourceType type;
                this.m_report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(i + 1), String.valueOf(importSize)), 3);
                currentElement = (Element)fileNodes.get(i);
                source = this.getChildElementTextValue(currentElement, "source");
                destination = this.getChildElementTextValue(currentElement, "destination");
                String typeName = this.getChildElementTextValue(currentElement, "type");
                try {
                    type = OpenCms.getResourceManager().getResourceType(typeName);
                }
                catch (CmsLoaderException e) {
                    type = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName());
                }
                uuidresource = !type.isFolder() ? this.getChildElementTextValue(currentElement, "uuidresource") : null;
                timestamp = this.getChildElementTextValue(currentElement, "datelastmodified");
                datelastmodified = timestamp != null ? this.convertTimestamp(timestamp) : System.currentTimeMillis();
                userlastmodified = this.getChildElementTextValue(currentElement, "userlastmodified");
                userlastmodified = OpenCms.getImportExportManager().translateUser(userlastmodified);
                timestamp = this.getChildElementTextValue(currentElement, "datecreated");
                datecreated = timestamp != null ? this.convertTimestamp(timestamp) : System.currentTimeMillis();
                usercreated = this.getChildElementTextValue(currentElement, "usercreated");
                usercreated = OpenCms.getImportExportManager().translateUser(usercreated);
                timestamp = this.getChildElementTextValue(currentElement, "datereleased");
                datereleased = timestamp != null ? this.convertTimestamp(timestamp) : 0L;
                timestamp = this.getChildElementTextValue(currentElement, "dateexpired");
                dateexpired = timestamp != null ? this.convertTimestamp(timestamp) : Long.MAX_VALUE;
                flags = this.getChildElementTextValue(currentElement, "flags");
                String translatedName = this.m_cms.getRequestContext().addSiteRoot(this.m_importPath + destination);
                if (type.isFolder() && !CmsResource.isFolder(translatedName)) {
                    translatedName = translatedName + "/";
                }
                boolean resourceNotImmutable = this.checkImmutable(translatedName, immutableResources);
                translatedName = this.m_cms.getRequestContext().removeSiteRoot(translatedName);
                if (resourceNotImmutable) {
                    this.m_report.print(Messages.get().container("RPT_IMPORTING_0"), 3);
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    this.m_report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    properties = this.readPropertiesFromManifest(currentElement, ignoredProperties);
                    CmsResource res = this.importResource(source, translatedName, type, uuidresource, datelastmodified, userlastmodified, datecreated, usercreated, datereleased, dateexpired, flags, properties);
                    if (res != null) {
                        ArrayList<CmsAccessControlEntry> aceList = new ArrayList<CmsAccessControlEntry>();
                        acentryNodes = currentElement.selectNodes("*/accessentry");
                        for (int j = 0; j < acentryNodes.size(); ++j) {
                            currentEntry = (Element)acentryNodes.get(j);
                            String id = this.getChildElementTextValue(currentEntry, "uuidprincipal");
                            String principalId = new CmsUUID().toString();
                            String principal = id.substring(id.indexOf(46) + 1, id.length());
                            try {
                                if (id.startsWith("GROUP")) {
                                    principal = OpenCms.getImportExportManager().translateGroup(principal);
                                    principalId = this.m_cms.readGroup(principal).getId().toString();
                                } else {
                                    principal = OpenCms.getImportExportManager().translateUser(principal);
                                    principalId = this.m_cms.readUser(principal).getId().toString();
                                }
                                String acflags = this.getChildElementTextValue(currentEntry, "flags");
                                String allowed = ((Element)currentEntry.selectNodes("./permissionset/allowed").get(0)).getTextTrim();
                                String denied = ((Element)currentEntry.selectNodes("./permissionset/denied").get(0)).getTextTrim();
                                aceList.add(this.getImportAccessControlEntry(res, principalId, allowed, denied, acflags));
                                continue;
                            }
                            catch (CmsException e) {
                                if (LOG.isWarnEnabled()) {
                                    LOG.warn((Object)Messages.get().getBundle().key("LOG_IMPORTEXPORT_ERROR_IMPORTING_ACE_1", translatedName), (Throwable)e);
                                }
                                this.m_report.println(e);
                            }
                        }
                        this.importAccessControlEntries(res, aceList);
                        if (OpenCms.getResourceManager().getResourceType(res.getTypeId()) instanceof I_CmsLinkParseable) {
                            this.m_parseables.add(res);
                        }
                        if (!LOG.isInfoEnabled()) continue;
                        LOG.info((Object)Messages.get().getBundle().key("LOG_IMPORTING_4", new Object[]{String.valueOf(i + 1), String.valueOf(importSize), translatedName, destination}));
                        continue;
                    }
                    this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(i + 1), String.valueOf(importSize), translatedName));
                    continue;
                }
                this.m_report.print(Messages.get().container("RPT_SKIPPING_0"), 3);
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", translatedName));
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)Messages.get().getBundle().key("LOG_SKIPPING_3", String.valueOf(i + 1), String.valueOf(importSize), translatedName));
            }
        }
        catch (Exception e) {
            this.m_report.println(e);
            this.m_report.addError(e);
            CmsMessageContainer message = Messages.get().container("ERR_IMPORTEXPORT_ERROR_IMPORTING_RESOURCES_0");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)message.key(), (Throwable)e);
            }
            throw new CmsImportExportException(message, (Throwable)e);
        }
    }
}

