/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Factory;
import org.apache.commons.collections.FactoryUtils;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.logging.Log;
import org.opencms.ade.galleries.CmsPreviewService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsAliasHelper;
import org.opencms.gwt.CmsBrokenLinkRenderer;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsAvailabilityInfoBean;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.gwt.shared.CmsDeleteResourceBean;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsLockReportInfo;
import org.opencms.gwt.shared.CmsPrepareEditResponse;
import org.opencms.gwt.shared.CmsPreviewInfo;
import org.opencms.gwt.shared.CmsPrincipalBean;
import org.opencms.gwt.shared.CmsRenameInfoBean;
import org.opencms.gwt.shared.CmsReplaceInfo;
import org.opencms.gwt.shared.CmsResourceStatusBean;
import org.opencms.gwt.shared.CmsRestoreInfoBean;
import org.opencms.gwt.shared.CmsVfsEntryBean;
import org.opencms.gwt.shared.alias.CmsAliasBean;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.gwt.shared.property.CmsPropertyModification;
import org.opencms.gwt.shared.rpc.I_CmsVfsService;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.loader.CmsImageScaler;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.page.CmsXmlPageFactory;

public class CmsVfsService
extends CmsGwtService
implements I_CmsVfsService {
    private static final Log LOG = CmsLog.getLog(CmsVfsService.class);
    private static Set<String> m_previewMimeTypes = new HashSet<String>();
    private static final long serialVersionUID = -383483666952834348L;
    private CmsAliasHelper m_aliasHelper = new CmsAliasHelper();

    public static CmsListInfoBean addLockInfo(CmsObject cms, CmsResource resource, CmsListInfoBean resourceInfo) throws CmsException {
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        CmsLock lock = resourceUtil.getLock();
        CmsListInfoBean.LockIcon icon = CmsListInfoBean.LockIcon.NONE;
        String iconTitle = null;
        CmsLockType lockType = lock.getType();
        if (!lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
                icon = CmsListInfoBean.LockIcon.CLOSED;
            } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
                icon = CmsListInfoBean.LockIcon.SHARED_CLOSED;
            }
        } else if (lockType == CmsLockType.EXCLUSIVE || lockType == CmsLockType.INHERITED || lockType == CmsLockType.TEMPORARY) {
            icon = CmsListInfoBean.LockIcon.OPEN;
        } else if (lockType == CmsLockType.SHARED_EXCLUSIVE || lockType == CmsLockType.SHARED_INHERITED) {
            icon = CmsListInfoBean.LockIcon.SHARED_OPEN;
        }
        if (lock.getUserId() != null && !lock.getUserId().isNullUUID()) {
            CmsUser lockOwner = cms.readUser(lock.getUserId());
            iconTitle = Messages.get().getBundle().key("GUI_LOCKED_BY_1", lockOwner.getFullName());
            resourceInfo.addAdditionalInfo(Messages.get().getBundle().key("GUI_LOCKED_OWNER_0"), lockOwner.getFullName());
        }
        resourceInfo.setLockIcon(icon);
        resourceInfo.setLockIconTitle(iconTitle);
        if (icon != CmsListInfoBean.LockIcon.NONE) {
            resourceInfo.setTitle(resourceInfo.getTitle() + " (" + iconTitle + ")");
        }
        return resourceInfo;
    }

    public static String getNoPreviewReason(CmsObject cms, CmsResource resource) {
        String noPreviewReason = null;
        if (resource.getState().isDeleted()) {
            noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_DELETED_0");
        } else if (resource.isFolder()) {
            noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_FOLDER_0");
        } else {
            String mimeType;
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource.getRootPath());
            if (siteRoot != null && !siteRoot.equals(cms.getRequestContext().getSiteRoot())) {
                noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_OTHER_SITE_0");
            } else if (resource.getTypeId() == CmsResourceTypeBinary.getStaticTypeId() && !m_previewMimeTypes.contains(mimeType = OpenCms.getResourceManager().getMimeType(resource.getName(), null, "empty"))) {
                noPreviewReason = Messages.get().getBundle().key("GUI_NO_PREVIEW_WRONG_MIME_TYPE_0");
            }
        }
        return noPreviewReason;
    }

    public static CmsListInfoBean getPageInfo(CmsObject cms, CmsResource res) throws CmsException, CmsLoaderException {
        CmsListInfoBean result = new CmsListInfoBean();
        result.setResourceState(res.getState());
        String title = cms.readPropertyObject(res, "Title", false).getValue();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
            result.setTitle(title);
        } else {
            result.setTitle(res.getName());
        }
        result.setSubTitle(cms.getSitePath(res));
        String secure = cms.readPropertyObject(res, "secure", true).getValue();
        if (Boolean.parseBoolean(secure)) {
            result.setStateIcon(CmsListInfoBean.StateIcon.secure);
        } else {
            String export = cms.readPropertyObject(res, "export", true).getValue();
            if (Boolean.parseBoolean(export)) {
                result.setStateIcon(CmsListInfoBean.StateIcon.export);
            } else {
                result.setStateIcon(CmsListInfoBean.StateIcon.standard);
            }
        }
        String resTypeName = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
        String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(resTypeName).getKey();
        Locale currentLocale = cms.getRequestContext().getLocale();
        CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(currentLocale);
        String resTypeNiceName = messages.key(key);
        result.addAdditionalInfo(messages.key("GUI_LABEL_TYPE_0"), resTypeNiceName);
        result.setResourceType(resTypeName);
        return result;
    }

    public static CmsListInfoBean getPageInfoWithLock(CmsObject cms, CmsResource resource) throws CmsLoaderException, CmsException {
        CmsListInfoBean result = CmsVfsService.getPageInfo(cms, resource);
        CmsVfsService.addLockInfo(cms, resource, result);
        return result;
    }

    public static String prepareFileNameForEditor(CmsObject cms, CmsResource res, String pathWithMacros) {
        String subsite = OpenCms.getADEManager().getSubSiteRoot(cms, res.getRootPath());
        CmsMacroResolver resolver = new CmsMacroResolver();
        if (subsite != null) {
            resolver.addMacro("subsite", cms.getRequestContext().removeSiteRoot(subsite));
        }
        String path = resolver.resolveMacros(pathWithMacros).replaceAll("/+", "/");
        return path;
    }

    @Override
    public void createPropertyDefinition(String name) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            cms.createPropertyDefinition(name.trim());
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    public void deleteResource(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.deleteResource(res);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void deleteResource(String sitePath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            this.deleteResource(res);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void forceUnlock(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsLock currentLock = this.getCmsObject().getLock(resource);
            if (currentLock.getEditionLock().isUnlocked() && currentLock.getSystemLock().isUnlocked()) {
                this.getCmsObject().lockResourceTemporary(resource);
            } else {
                this.getCmsObject().changeLock(resource);
            }
            this.getCmsObject().unlockResource(resource);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public List<CmsAliasBean> getAliasesForPage(CmsUUID uuid) throws CmsRpcException {
        try {
            return this.m_aliasHelper.getAliasesForPage(uuid);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsAvailabilityInfoBean getAvailabilityInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getAvailabilityInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsDeleteResourceBean getBrokenLinks(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource entryResource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getBrokenLinks(entryResource);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsDeleteResourceBean getBrokenLinks(String sitePath) throws CmsRpcException {
        try {
            CmsResource entryResource = this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getBrokenLinks(entryResource);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getChildren(String path) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
            resources.addAll(cms.getResourcesInFolder(path, CmsResourceFilter.DEFAULT));
            List<CmsVfsEntryBean> result = this.makeEntryBeans(resources, false);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public ArrayList<String> getDefinedProperties() throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            List<CmsPropertyDefinition> definitions = cms.readAllPropertyDefinitions();
            ArrayList<String> result = new ArrayList<String>();
            for (CmsPropertyDefinition def : definitions) {
                result.add(def.getName());
            }
            return result;
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsReplaceInfo getFileReplaceInfo(CmsUUID structureId) throws CmsRpcException {
        CmsReplaceInfo result = null;
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource res = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean fileInfo = this.getPageInfo(res);
            boolean isLockable = cms.getLock(res).isLockableBy(cms.getRequestContext().getCurrentUser());
            long maxFileSize = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(cms);
            result = new CmsReplaceInfo(fileInfo, cms.getSitePath(res), isLockable, maxFileSize);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsLockReportInfo getLockReportInfo(CmsUUID structureId) throws CmsRpcException {
        CmsLockReportInfo result = null;
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            ArrayList<CmsListInfoBean> lockedInfos = new ArrayList<CmsListInfoBean>();
            List<CmsResource> lockedResources = cms.getBlockingLockedResources(resource);
            if (lockedResources != null) {
                for (CmsResource lockedResource : lockedResources) {
                    lockedInfos.add(CmsVfsService.getPageInfoWithLock(cms, lockedResource));
                }
            }
            result = new CmsLockReportInfo(CmsVfsService.getPageInfoWithLock(cms, resource), lockedInfos);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsListInfoBean getPageInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getPageInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsListInfoBean getPageInfo(String vfsPath) throws CmsRpcException {
        try {
            CmsResource res = this.getCmsObject().readResource(vfsPath, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getPageInfo(res);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPreviewInfo getPreviewInfo(CmsUUID structureId, String locale) throws CmsRpcException {
        CmsPreviewInfo result = null;
        try {
            result = this.getPreviewInfo(this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION), CmsLocaleManager.getLocale(locale));
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsPreviewInfo getPreviewInfo(String sitePath, String locale) throws CmsRpcException {
        CmsPreviewInfo result = null;
        try {
            result = this.getPreviewInfo(this.getCmsObject().readResource(sitePath, CmsResourceFilter.IGNORE_EXPIRATION), CmsLocaleManager.getLocale(locale));
        }
        catch (Exception e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsRenameInfoBean getRenameInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean listInfo = this.getPageInfo(resource);
            String sitePath = cms.getSitePath(resource);
            return new CmsRenameInfoBean(sitePath, structureId, listInfo);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsResourceStatusBean getResourceStatus(CmsUUID structureId, String contentLocale) throws CmsRpcException {
        try {
            String lastProject;
            Locale realLocale;
            CmsGallerySearchResult result;
            CmsObject cms = this.getCmsObject();
            Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
            cms.getRequestContext().setLocale(locale);
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            String localizedTitle = null;
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(contentLocale) && !CmsStringUtil.isEmptyOrWhitespaceOnly((result = CmsGallerySearch.searchById(cms, structureId, realLocale = CmsLocaleManager.getLocale(contentLocale))).getTitle())) {
                localizedTitle = result.getTitle();
            }
            CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
            List<CmsProperty> properties = cms.readPropertyObjects(resource, false);
            CmsResourceStatusBean result2 = new CmsResourceStatusBean();
            result2.setDateCreated(this.formatDateTime(resource.getDateCreated()));
            long dateExpired = resource.getDateExpired();
            if (dateExpired != Long.MAX_VALUE) {
                result2.setDateExpired(this.formatDateTime(dateExpired));
            }
            result2.setDateLastModified(this.formatDateTime(resource.getDateLastModified()));
            long dateReleased = resource.getDateReleased();
            if (dateReleased != 0L) {
                result2.setDateReleased(this.formatDateTime(dateReleased));
            }
            if ("".equals(lastProject = resourceUtil.getLockedInProjectName())) {
                lastProject = null;
            }
            result2.setLastProject(lastProject);
            result2.setListInfo(CmsVfsService.getPageInfo(cms, resource));
            CmsLock lock = cms.getLock(resource);
            CmsUser lockOwner = null;
            if (!lock.isUnlocked()) {
                lockOwner = cms.readUser(lock.getUserId());
                result2.setLockState(org.opencms.workplace.list.Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_LOCK_NAME_2", lockOwner.getName(), lastProject));
            } else {
                result2.setLockState(org.opencms.workplace.list.Messages.get().getBundle(locale).key("GUI_EXPLORER_LIST_ACTION_UNLOCK_NAME_0"));
            }
            CmsProperty navText = CmsProperty.get("NavText", properties);
            if (navText != null) {
                result2.setNavText(navText.getValue());
            }
            result2.setPermissions(resourceUtil.getPermissionString());
            result2.setSize(resource.getLength());
            result2.setStateBean(resource.getState());
            CmsProperty title = CmsProperty.get("Title", properties);
            if (localizedTitle != null) {
                result2.setTitle(localizedTitle);
                result2.getListInfo().setTitle(localizedTitle);
            } else if (title != null) {
                result2.setTitle(title.getValue());
            }
            result2.setUserCreated(resourceUtil.getUserCreated());
            result2.setUserLastModified(resourceUtil.getUserLastModified());
            I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
            result2.setResourceType(resType.getTypeName());
            if (resType instanceof CmsResourceTypeXmlContent) {
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                List<Locale> locales = content.getLocales();
                ArrayList<String> localeStrings = new ArrayList<String>();
                for (Locale l : locales) {
                    localeStrings.add(l.toString());
                }
                result2.setLocales(localeStrings);
            }
            return result2;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsRestoreInfoBean getRestoreInfo(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsListInfoBean listInfo = this.getPageInfo(resource);
            CmsRestoreInfoBean result = new CmsRestoreInfoBean();
            result.setListInfoBean(listInfo);
            CmsObject onlineCms = OpenCms.initCmsObject(cms);
            CmsProject onlineProject = cms.readProject("Online");
            onlineCms.getRequestContext().setCurrentProject(onlineProject);
            CmsResource onlineResource = onlineCms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            result.setOnlinePath(onlineResource.getRootPath());
            result.setOfflinePath(resource.getRootPath());
            String offlineDate = this.formatDateTime(resource.getDateLastModified());
            String onlineDate = this.formatDateTime(onlineResource.getDateLastModified());
            result.setOfflineDate(offlineDate);
            result.setOnlineDate(onlineDate);
            result.setStructureId(structureId);
            CmsObject offlineRootCms = OpenCms.initCmsObject(cms);
            offlineRootCms.getRequestContext().setSiteRoot("");
            CmsObject onlineRootCms = OpenCms.initCmsObject(onlineCms);
            onlineRootCms.getRequestContext().setSiteRoot("");
            String parent = CmsResource.getParentFolder(onlineResource.getRootPath());
            boolean canUndoMove = offlineRootCms.existsResource(parent, CmsResourceFilter.IGNORE_EXPIRATION);
            result.setCanUndoMove(canUndoMove);
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public List<CmsVfsEntryBean> getRootEntries() throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            ArrayList<CmsResource> roots = new ArrayList<CmsResource>();
            roots.add(cms.readResource("/", CmsResourceFilter.IGNORE_EXPIRATION));
            return this.makeEntryBeans(roots, true);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String getSitePath(CmsUUID structureId) {
        try {
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            return this.getCmsObject().getSitePath(resource);
        }
        catch (CmsException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e.getMessageContainer(), (Throwable)e);
            }
            return null;
        }
    }

    public void internalUpdateProperties(CmsObject cms, CmsResource ownRes, List<CmsPropertyModification> propertyModifications) throws CmsException {
        Map<String, CmsProperty> ownProps = this.getPropertiesByName(cms.readPropertyObjects(ownRes, false));
        boolean changeOwnTitle = this.shouldChangeTitle(ownProps);
        String hasNavTextChange = null;
        ArrayList<CmsProperty> ownPropertyChanges = new ArrayList<CmsProperty>();
        for (CmsPropertyModification propMod : propertyModifications) {
            CmsProperty propToModify = null;
            if (ownRes.getStructureId().equals(propMod.getId())) {
                if ("NavText".equals(propMod.getName())) {
                    hasNavTextChange = propMod.getValue();
                } else if ("Title".equals(propMod.getName())) {
                    changeOwnTitle = false;
                }
                propToModify = ownProps.get(propMod.getName());
                if (propToModify == null) {
                    propToModify = new CmsProperty(propMod.getName(), null, null);
                }
            } else {
                throw new IllegalStateException("Invalid structure id in property changes!");
            }
            ownPropertyChanges.add(propToModify);
            String newValue = propMod.getValue();
            if (newValue == null) {
                newValue = "";
            }
            if (propMod.isStructureValue()) {
                propToModify.setStructureValue(newValue);
                continue;
            }
            propToModify.setResourceValue(newValue);
        }
        if (hasNavTextChange != null && changeOwnTitle) {
            CmsProperty titleProp = ownProps.get("Title");
            if (titleProp == null) {
                titleProp = new CmsProperty("Title", null, null);
            }
            titleProp.setStructureValue(hasNavTextChange);
            ownPropertyChanges.add(titleProp);
        }
        if (!ownPropertyChanges.isEmpty()) {
            cms.writePropertyObjects(ownRes, ownPropertyChanges);
        }
    }

    @Override
    public CmsPropertiesBean loadPropertyData(CmsUUID id) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            return this.internalLoadPropertyData(cms, id);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsPrepareEditResponse prepareEdit(CmsUUID currentPageId, String pathWithMacros) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource currentPage = cms.readResource(currentPageId, CmsResourceFilter.IGNORE_EXPIRATION);
            String path = CmsVfsService.prepareFileNameForEditor(cms, currentPage, pathWithMacros);
            CmsResource resource = cms.readResource(path, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            CmsPrepareEditResponse result = new CmsPrepareEditResponse();
            result.setRootPath(resource.getRootPath());
            result.setSitePath(cms.getSitePath(resource));
            result.setStructureId(resource.getStructureId());
            return result;
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public String renameResource(CmsUUID structureId, String newName) throws CmsRpcException {
        try {
            return this.renameResourceInternal(structureId, newName);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    public String renameResourceInternal(CmsUUID structureId, String newName) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        try {
            CmsResource.checkResourceName(newName);
        }
        catch (CmsIllegalArgumentException e) {
            return e.getLocalizedMessage(locale);
        }
        CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        String oldSitePath = cms.getSitePath(resource);
        String parentPath = CmsResource.getParentFolder(oldSitePath);
        String newSitePath = CmsStringUtil.joinPaths(parentPath, newName);
        try {
            this.ensureLock(resource);
            cms.moveResource(oldSitePath, newSitePath);
            resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            return e.getLocalizedMessage(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
        }
        this.tryUnlock(resource);
        return null;
    }

    @Override
    public void saveAliases(CmsUUID structureId, List<CmsAliasBean> aliasBeans) throws CmsRpcException {
        try {
            this.m_aliasHelper.saveAliases(structureId, aliasBeans);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveProperties(CmsPropertyChangeSet changes) throws CmsRpcException {
        String origSiteRoot = this.getCmsObject().getRequestContext().getSiteRoot();
        try {
            this.getCmsObject().getRequestContext().setSiteRoot("");
            this.internalSaveProperties(changes);
        }
        catch (Throwable t) {
            this.error(t);
        }
        finally {
            this.getCmsObject().getRequestContext().setSiteRoot(origSiteRoot);
        }
    }

    @Override
    public synchronized void setCms(CmsObject cms) {
        super.setCms(cms);
        this.m_aliasHelper.setCms(cms);
    }

    @Override
    public String substituteLinkForRootPath(String currentSiteRoot, String rootPath) throws CmsRpcException {
        String result = null;
        try {
            CmsObject cms = OpenCms.initCmsObject(this.getCmsObject());
            cms.getRequestContext().setSiteRoot(currentSiteRoot);
            result = OpenCms.getLinkManager().substituteLinkForRootPath(cms, rootPath);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public void syncDeleteResource(CmsUUID structureId) throws CmsRpcException {
        this.deleteResource(structureId);
    }

    @Override
    public void undoChanges(CmsUUID structureId, boolean undoMove) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(resource);
            CmsResource.CmsResourceUndoMode mode = undoMove ? CmsResource.UNDO_MOVE_CONTENT : CmsResource.UNDO_CONTENT;
            String path = cms.getSitePath(resource);
            cms.undoChanges(path, mode);
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                path = cms.getSitePath(resource);
                cms.unlockResource(path);
            }
            catch (CmsException e) {
                LOG.info((Object)("Could not unlock resource after undoing changes: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public Map<String, String> validateAliases(CmsUUID uuid, Map<String, String> aliasPaths) throws CmsRpcException {
        try {
            return this.m_aliasHelper.validateAliases(uuid, aliasPaths);
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    protected Map<String, CmsClientProperty> convertProperties(List<CmsProperty> properties) {
        HashMap<String, CmsClientProperty> result = new HashMap<String, CmsClientProperty>();
        for (CmsProperty prop : properties) {
            CmsClientProperty clientProp = new CmsClientProperty(prop.getName(), prop.getStructureValue(), prop.getResourceValue());
            clientProp.setOrigin(prop.getOrigin());
            result.put(clientProp.getName(), clientProp);
        }
        return result;
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsObject cms = this.getCmsObject();
        CmsProperty titleProp = cms.readPropertyObject(resource, "Title", true);
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        String defaultTitle = "";
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = cms.getSitePath(resource);
        return new CmsBrokenLinkBean(title, subtitle, typeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalSaveProperties(CmsPropertyChangeSet changes) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResource target = cms.readResource(changes.getTargetStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
        CmsLockActionRecord actionRecord = this.ensureLock(cms.getSitePath(target));
        try {
            this.internalUpdateProperties(cms, target, changes.getChanges());
        }
        finally {
            if (actionRecord.getChange() == CmsLockActionRecord.LockChange.locked) {
                cms.unlockResource(cms.getSitePath(target));
            }
        }
    }

    protected CmsVfsEntryBean makeEntryBean(CmsResource resource, boolean root) throws CmsException {
        List<CmsResource> children;
        CmsObject cms = this.getCmsObject();
        boolean isFolder = resource.isFolder();
        String name = root ? "/" : resource.getName();
        String path = cms.getSitePath(resource);
        boolean hasChildren = false;
        if (isFolder && !(children = cms.getResourcesInFolder(cms.getRequestContext().getSitePath(resource), CmsResourceFilter.DEFAULT)).isEmpty()) {
            hasChildren = true;
        }
        String resourceType = OpenCms.getResourceManager().getResourceType(resource.getTypeId()).getTypeName();
        return new CmsVfsEntryBean(path, name, resourceType, isFolder, hasChildren);
    }

    protected List<CmsVfsEntryBean> makeEntryBeans(List<CmsResource> resources, boolean root) throws CmsException {
        ArrayList<CmsVfsEntryBean> result = new ArrayList<CmsVfsEntryBean>();
        for (CmsResource res : resources) {
            result.add(this.makeEntryBean(res, root));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteResource(CmsResource resource) throws CmsException {
        String path = null;
        try {
            path = this.getCmsObject().getSitePath(resource);
            this.getCmsObject().lockResource(path);
            this.getCmsObject().deleteResource(path, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        finally {
            try {
                if (path != null) {
                    this.getCmsObject().unlockResource(path);
                }
            }
            catch (Exception e) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private String formatDateTime(long date) {
        CmsObject cms = this.getCmsObject();
        return CmsDateUtil.getDateTime(new Date(date), 2, OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    private CmsAvailabilityInfoBean getAvailabilityInfo(CmsResource res) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            String notificationEnabled;
            CmsAvailabilityInfoBean result = new CmsAvailabilityInfoBean();
            result.setPageInfo(this.getPageInfo(res));
            String resourceSitePath = cms.getRequestContext().removeSiteRoot(res.getRootPath());
            result.setVfsPath(resourceSitePath);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            result.setResType(type.getTypeName());
            result.setDateReleased(res.getDateReleased());
            result.setDateExpired(res.getDateExpired());
            String notificationInterval = cms.readPropertyObject(res, "notification-interval", false).getValue();
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationInterval)) {
                result.setNotificationInterval(Integer.valueOf(notificationInterval));
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(notificationEnabled = cms.readPropertyObject(res, "enable-notification", false).getValue())) {
                result.setNotificationEnabled(Boolean.valueOf(notificationEnabled));
            }
            result.setHasSiblings(cms.readSiblings(resourceSitePath, CmsResourceFilter.ALL).size() > 1);
            result.setResponsibles(this.getResponsibles(res.getRootPath()));
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private LinkedHashMap<String, String> getAvailableLocales(CmsResource resource) {
        LinkedHashMap<String, String> result = null;
        List<Locale> locales = null;
        try {
            if (CmsResourceTypeXmlPage.isXmlPage(resource)) {
                locales = CmsXmlPageFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest()).getLocales();
            } else if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
                locales = CmsXmlContentFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest()).getLocales();
            } else if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
                locales = CmsXmlContainerPageFactory.unmarshal(this.getCmsObject(), resource).getLocales();
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (locales != null) {
            Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.getCmsObject());
            result = new LinkedHashMap<String, String>();
            for (Locale locale : locales) {
                result.put(locale.toString(), locale.getDisplayName(wpLocale));
            }
        }
        return result;
    }

    private List<CmsBrokenLinkBean> getBrokenLinkBeans(MultiValueMap linkMap) throws CmsException {
        CmsBrokenLinkRenderer brokenLinkRenderer = new CmsBrokenLinkRenderer(this.getCmsObject());
        ArrayList<CmsBrokenLinkBean> result = new ArrayList<CmsBrokenLinkBean>();
        for (CmsResource key : linkMap.keySet()) {
            CmsBrokenLinkBean parentBean = this.createSitemapBrokenLinkBean(key);
            result.add(parentBean);
            Collection values = linkMap.getCollection((Object)key);
            for (CmsResource resource : values) {
                List<CmsBrokenLinkBean> brokenLinkBeans = brokenLinkRenderer.renderBrokenLink(key, resource);
                for (CmsBrokenLinkBean childBean : brokenLinkBeans) {
                    parentBean.addChild(childBean);
                }
            }
        }
        return result;
    }

    private CmsDeleteResourceBean getBrokenLinks(CmsResource entryResource) throws CmsException {
        CmsDeleteResourceBean result = null;
        CmsListInfoBean info = null;
        List<CmsBrokenLinkBean> brokenLinks = null;
        CmsObject cms = this.getCmsObject();
        String resourceSitePath = cms.getSitePath(entryResource);
        this.ensureSession();
        ArrayList<CmsResource> descendants = new ArrayList<CmsResource>();
        HashSet<CmsUUID> deleteIds = new HashSet<CmsUUID>();
        descendants.add(entryResource);
        if (entryResource.isFolder()) {
            descendants.addAll(cms.readResources(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        for (CmsResource deleteRes : descendants) {
            deleteIds.add(deleteRes.getStructureId());
        }
        MultiValueMap linkMap = MultiValueMap.decorate(new HashMap(), (Factory)FactoryUtils.instantiateFactory(HashSet.class));
        for (CmsResource resource : descendants) {
            List<CmsResource> linkSources = this.getLinkSources(cms, resource, deleteIds);
            for (CmsResource source : linkSources) {
                linkMap.put((Object)resource, (Object)source);
            }
        }
        brokenLinks = this.getBrokenLinkBeans(linkMap);
        info = this.getPageInfo(entryResource);
        result = new CmsDeleteResourceBean(resourceSitePath, info, brokenLinks);
        return result;
    }

    private List<CmsResource> getLinkSources(CmsObject cms, CmsResource resource, HashSet<CmsUUID> deleteIds) throws CmsException {
        List<CmsRelation> relations = cms.getRelationsForResource(resource, CmsRelationFilter.SOURCES);
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsRelation relation : relations) {
            if (deleteIds.contains(relation.getSourceId())) continue;
            result.add(relation.getSource(cms, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        return result;
    }

    private CmsListInfoBean getPageInfo(CmsResource res) throws CmsException, CmsLoaderException {
        CmsObject cms = this.getCmsObject();
        return CmsVfsService.getPageInfo(cms, res);
    }

    private CmsPreviewInfo getPreviewInfo(CmsResource resource, Locale locale) {
        CmsPreviewInfo result;
        CmsObject cms = this.getCmsObject();
        String title = "";
        try {
            CmsProperty titleProperty = cms.readPropertyObject(resource, "Title", false);
            title = titleProperty.getValue("");
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String noPreviewReason = CmsVfsService.getNoPreviewReason(cms, resource);
        String previewContent = null;
        int height = 0;
        int width = 0;
        LinkedHashMap<String, String> locales = this.getAvailableLocales(resource);
        if (noPreviewReason != null) {
            previewContent = "<div>" + noPreviewReason + "</div>";
            return new CmsPreviewInfo("<div>" + noPreviewReason + "</div>", null, false, title, cms.getSitePath(resource), locale.toString());
        }
        if (CmsResourceTypeImage.getStaticTypeId() == resource.getTypeId()) {
            CmsImageScaler scaler = new CmsImageScaler(cms, resource);
            previewContent = "<img src=\"" + OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "\" title=\"" + title + "\" style=\"display:block\" />";
            height = scaler.getHeight();
            width = scaler.getWidth();
        } else if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            if (!locales.containsKey(locale.toString())) {
                locale = CmsLocaleManager.getMainLocale(cms, resource);
            }
            previewContent = CmsPreviewService.getPreviewContent(this.getRequest(), this.getResponse(), cms, resource, locale);
        } else if (CmsResourceTypePlain.getStaticTypeId() == resource.getTypeId()) {
            try {
                previewContent = "<pre><code>" + new String(cms.readFile(resource).getContents()) + "</code></pre>";
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                previewContent = "<div>" + Messages.get().getBundle().key("GUI_NO_PREVIEW_CAN_T_READ_CONTENT_0") + "</div>";
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(previewContent)) {
            result = new CmsPreviewInfo(previewContent, null, false, title, cms.getSitePath(resource), locale.toString());
            result.setHeight(height);
            result.setWidth(width);
            result.setLocales(locales);
            return result;
        }
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource) || CmsResourceTypeXmlPage.isXmlPage(resource)) {
            result = new CmsPreviewInfo(null, OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "?" + "__disableDirectEdit" + "=true" + "&__locale=" + locale.toString(), false, title, cms.getSitePath(resource), locale.toString());
            result.setLocales(locales);
            return result;
        }
        return new CmsPreviewInfo(null, OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, resource.getRootPath()) + "?" + "__disableDirectEdit" + "=true", true, title, cms.getSitePath(resource), locale.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<CmsPrincipalBean, String> getResponsibles(String vfsPath) throws CmsRpcException {
        HashMap<CmsPrincipalBean, String> result = new HashMap<CmsPrincipalBean, String>();
        List<Object> parentResources = new ArrayList();
        CmsObject cms = this.getCmsObject();
        String resourceSitePath = cms.getRequestContext().removeSiteRoot(vfsPath);
        try {
            parentResources = cms.readPath(resourceSitePath, CmsResourceFilter.IGNORE_EXPIRATION);
        }
        catch (CmsException e) {
            this.error(e);
        }
        for (CmsResource cmsResource : parentResources) {
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            String sitePath = cms.getRequestContext().removeSiteRoot(cmsResource.getRootPath());
            try {
                cms.getRequestContext().setSiteRoot("/");
                List<CmsAccessControlEntry> entries = cms.getAccessControlEntries(cmsResource.getRootPath(), false);
                for (CmsAccessControlEntry ace : entries) {
                    I_CmsPrincipal principal;
                    if (!ace.isResponsible() || (principal = cms.lookupPrincipal(ace.getPrincipal())) == null) continue;
                    CmsPrincipalBean prinBean = new CmsPrincipalBean(principal.getName(), principal.getDescription(), principal.isGroup());
                    if (!cmsResource.getRootPath().equals(vfsPath)) {
                        if (cmsResource.getRootPath().startsWith(storedSiteRoot)) {
                            result.put(prinBean, sitePath);
                            continue;
                        }
                        result.put(prinBean, cmsResource.getRootPath());
                        continue;
                    }
                    result.put(prinBean, null);
                }
            }
            catch (CmsException e) {
                this.error(e);
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsPropertiesBean internalLoadPropertyData(CmsObject cms, CmsUUID id) throws CmsException {
        String originalSiteRoot = cms.getRequestContext().getSiteRoot();
        CmsPropertiesBean result = new CmsPropertiesBean();
        CmsResource resource = cms.readResource(id, CmsResourceFilter.IGNORE_EXPIRATION);
        boolean hasPermissions = cms.hasPermissions(resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsLock lock = cms.getLock(resource);
        boolean lockedByOtherUser = !lock.isUnlocked() && !lock.isOwnedBy(cms.getRequestContext().getCurrentUser());
        result.setReadOnly(!hasPermissions || lockedByOtherUser);
        result.setFolder(resource.isFolder());
        result.setContainerPage(CmsResourceTypeXmlContainerPage.isContainerPage(resource));
        String sitePath = cms.getSitePath(resource);
        Map<String, CmsXmlContentProperty> propertyConfig = OpenCms.getADEManager().lookupConfiguration(cms, resource.getRootPath()).getPropertyConfigurationAsMap();
        result.setPropertyDefinitions(new LinkedHashMap<String, CmsXmlContentProperty>(propertyConfig));
        try {
            cms.getRequestContext().setSiteRoot("");
            String parentPath = CmsResource.getParentFolder(resource.getRootPath());
            CmsResource parent = cms.readResource(parentPath);
            List<CmsProperty> parentProperties = cms.readPropertyObjects(parent, true);
            List<CmsProperty> ownProperties = cms.readPropertyObjects(resource, false);
            result.setOwnProperties(this.convertProperties(ownProperties));
            result.setInheritedProperties(this.convertProperties(parentProperties));
            result.setPageInfo(this.getPageInfo(resource));
            List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
            ArrayList<String> propNames = new ArrayList<String>();
            for (CmsPropertyDefinition propDef : propDefs) {
                propNames.add(propDef.getName());
            }
            CmsTemplateFinder templateFinder = new CmsTemplateFinder(cms);
            result.setTemplates(templateFinder.getTemplates());
            result.setAllProperties(propNames);
            result.setStructureId(id);
            result.setSitePath(sitePath);
            CmsPropertiesBean cmsPropertiesBean = result;
            return cmsPropertiesBean;
        }
        finally {
            cms.getRequestContext().setSiteRoot(originalSiteRoot);
        }
    }

    private boolean shouldChangeTitle(Map<String, CmsProperty> properties) {
        return properties == null || properties.get("Title") == null || properties.get("Title").getValue() == null || properties.get("NavText") != null && properties.get("Title").getValue().equals(properties.get("NavText").getValue());
    }

    static {
        CollectionUtils.addAll(m_previewMimeTypes, (Object[])new String[]{"application/msword", "application/pdf", "application/excel", "application/mspowerpoint", "application/zip"});
    }
}

