/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.gwt.CmsGwtServiceContext;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.Messages;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsUUID;

public class CmsGwtService
extends RemoteServiceServlet {
    private static final Log LOG = CmsLog.getLog(CmsGwtService.class);
    private static final long serialVersionUID = 8119684308154724518L;
    private CmsGwtServiceContext m_context;
    private ThreadLocal<CmsObject> m_perThreadCmsObject;

    public void checkPermissions(CmsObject cms) throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.WORKPLACE_USER);
    }

    public void error(Throwable t) throws CmsRpcException {
        this.logError(t);
        throw new CmsRpcException(t);
    }

    public CmsObject getCmsObject() {
        return this.m_perThreadCmsObject.get();
    }

    public HttpServletRequest getRequest() {
        return this.getThreadLocalRequest();
    }

    public HttpServletResponse getResponse() {
        return this.getThreadLocalResponse();
    }

    public void log(String msg) {
        if (this.getResponse() != null) {
            super.log(msg);
        }
        LOG.info((Object)msg);
    }

    public void log(String message, Throwable t) {
        if (this.getResponse() != null) {
            super.log(message, t);
        }
        LOG.info((Object)message, t);
    }

    public void logError(Throwable t) {
        LOG.error((Object)t.getLocalizedMessage(), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest arg0, ServletResponse arg1) throws ServletException, IOException {
        try {
            arg1.setCharacterEncoding(arg0.getCharacterEncoding());
            super.service(arg0, arg1);
        }
        finally {
            this.clearThreadStorage();
        }
    }

    public synchronized void setCms(CmsObject cms) {
        if (this.m_perThreadCmsObject == null) {
            this.m_perThreadCmsObject = new ThreadLocal();
        }
        this.m_perThreadCmsObject.set(cms);
    }

    public synchronized void setContext(CmsGwtServiceContext context) {
        this.m_context = context;
    }

    public synchronized void setRequest(HttpServletRequest request) {
        if (this.perThreadRequest == null) {
            this.perThreadRequest = new ThreadLocal();
        }
        this.perThreadRequest.set(request);
    }

    public synchronized void setResponse(HttpServletResponse response) {
        if (this.perThreadResponse == null) {
            this.perThreadResponse = new ThreadLocal();
        }
        this.perThreadResponse.set(response);
    }

    protected void clearThreadStorage() {
        if (this.m_perThreadCmsObject != null) {
            this.m_perThreadCmsObject.remove();
        }
        if (this.perThreadRequest != null) {
            this.perThreadRequest.remove();
        }
        if (this.perThreadResponse != null) {
            this.perThreadResponse.remove();
        }
    }

    protected SerializationPolicy doGetSerializationPolicy(HttpServletRequest request, String moduleBaseURL, String strongName) {
        return this.m_context.getSerializationPolicy(this.getCmsObject(), moduleBaseURL, strongName);
    }

    protected void doUnexpectedFailure(Throwable e) {
        LOG.error((Object)String.valueOf(System.currentTimeMillis()), e);
        super.doUnexpectedFailure(e);
    }

    protected CmsLockActionRecord ensureLock(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsLockActionRecord.LockChange change = CmsLockActionRecord.LockChange.unchanged;
        List<CmsResource> blockingResources = cms.getBlockingLockedResources(resource);
        if (blockingResources != null && !blockingResources.isEmpty()) {
            throw new CmsException(Messages.get().container("ERR_RESOURCE_HAS_BLOCKING_LOCKED_CHILDREN_1", cms.getSitePath(resource)));
        }
        CmsUser user = cms.getRequestContext().getCurrentUser();
        CmsLock lock = cms.getLock(resource);
        if (!lock.isOwnedBy(user)) {
            cms.lockResourceTemporary(resource);
            change = CmsLockActionRecord.LockChange.locked;
            lock = cms.getLock(resource);
        } else if (!lock.isOwnedInProjectBy(user, cms.getRequestContext().getCurrentProject())) {
            cms.changeLock(resource);
            change = CmsLockActionRecord.LockChange.changed;
            lock = cms.getLock(resource);
        }
        return new CmsLockActionRecord(lock, change);
    }

    protected CmsLockActionRecord ensureLock(CmsUUID structureId) throws CmsException {
        return this.ensureLock(this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION));
    }

    protected CmsLockActionRecord ensureLock(String sitepath) throws CmsException {
        return this.ensureLock(this.getCmsObject().readResource(sitepath, CmsResourceFilter.IGNORE_EXPIRATION));
    }

    protected void ensureSession() throws CmsException {
        CmsUser user = this.getCmsObject().getRequestContext().getCurrentUser();
        if (user.isGuestUser()) {
            throw new CmsException(Messages.get().container("ERR_SESSION_EXPIRED_0"));
        }
    }

    protected Map<String, CmsProperty> getPropertiesByName(List<CmsProperty> properties) {
        HashMap<String, CmsProperty> result = new HashMap<String, CmsProperty>();
        for (CmsProperty property : properties) {
            String key = property.getName();
            result.put(key, property.clone());
        }
        return result;
    }

    protected void tryUnlock(CmsResource resource) {
        try {
            this.getCmsObject().unlockResource(resource);
        }
        catch (CmsException e) {
            LOG.debug((Object)("Unable to unlock " + resource.getRootPath()), (Throwable)e);
        }
    }
}

