/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import org.opencms.file.CmsResource;

public class CmsFlexRequestContextInfo {
    private long m_dateExpires = Long.MAX_VALUE;
    private long m_dateLastModified;

    public long getDateExpires() {
        return this.m_dateExpires;
    }

    public long getDateLastModified() {
        return this.m_dateLastModified;
    }

    public void merge(CmsFlexRequestContextInfo other) {
        this.updateDateLastModified(other.getDateLastModified());
        this.updateDateExpires(other.getDateExpires());
    }

    public void updateDateExpires(long dateExpires) {
        if (dateExpires > System.currentTimeMillis()) {
            if (dateExpires < this.m_dateExpires) {
                this.m_dateExpires = dateExpires;
            }
        } else {
            this.updateDateLastModified(dateExpires);
        }
    }

    public void updateDateLastModified(long dateLastModified) {
        if (this.m_dateLastModified > -1L && (dateLastModified > this.m_dateLastModified || dateLastModified < 0L)) {
            this.m_dateLastModified = dateLastModified;
        }
    }

    public void updateDates(long dateLastModified, long dateExpires) {
        this.updateDateLastModified(dateLastModified);
        this.updateDateExpires(dateExpires);
    }

    public void updateFromResource(CmsResource resource) {
        this.updateDateLastModified(resource.getDateLastModified());
        this.updateDateExpires(resource.getDateReleased());
        this.updateDateExpires(resource.getDateExpired());
    }
}

