/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.List;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.wrapper.I_CmsResourceWrapper;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;

public abstract class A_CmsResourceWrapper
implements I_CmsResourceWrapper {
    protected boolean m_isWrappedResource;

    @Override
    public List<CmsResource> addResourcesToFolder(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        if (this.m_isWrappedResource) {
            return cms.getResourcesInFolder(resourcename, filter);
        }
        return null;
    }

    @Override
    public boolean copyResource(CmsObject cms, String source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        if (this.m_isWrappedResource) {
            cms.copyResource(source, destination, siblingMode);
            return true;
        }
        return false;
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        if (this.m_isWrappedResource) {
            return cms.createResource(resourcename, type, content, properties);
        }
        return null;
    }

    @Override
    public boolean deleteResource(CmsObject cms, String resourcename, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        if (this.m_isWrappedResource) {
            cms.deleteResource(resourcename, siblingMode);
            return true;
        }
        return false;
    }

    @Override
    public CmsLock getLock(CmsObject cms, CmsResource resource) throws CmsException {
        if (this.m_isWrappedResource) {
            return cms.getLock(resource);
        }
        return null;
    }

    @Override
    public boolean lockResource(CmsObject cms, String resourcename) throws CmsException {
        if (this.m_isWrappedResource) {
            cms.lockResource(resourcename);
            return true;
        }
        return false;
    }

    @Override
    public boolean moveResource(CmsObject cms, String source, String destination) throws CmsException, CmsIllegalArgumentException {
        if (this.m_isWrappedResource) {
            cms.moveResource(source, destination);
            return true;
        }
        return false;
    }

    @Override
    public CmsFile readFile(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        if (this.m_isWrappedResource) {
            return cms.readFile(resourcename, filter);
        }
        return null;
    }

    @Override
    public CmsResource readResource(CmsObject cms, String resourcename, CmsResourceFilter filter) throws CmsException {
        if (this.m_isWrappedResource) {
            return cms.readResource(resourcename, filter);
        }
        return null;
    }

    @Override
    public String restoreLink(CmsObject cms, String uri) {
        return null;
    }

    @Override
    public String rewriteLink(CmsObject cms, CmsResource res) {
        return null;
    }

    @Override
    public boolean unlockResource(CmsObject cms, String resourcename) throws CmsException {
        if (this.m_isWrappedResource) {
            cms.unlockResource(resourcename);
            return true;
        }
        return false;
    }

    @Override
    public CmsResource wrapResource(CmsObject cms, CmsResource resource) {
        return resource;
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsFile resource) throws CmsException {
        if (this.m_isWrappedResource) {
            return cms.writeFile(resource);
        }
        return null;
    }
}

