/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.A_CmsResourceType;
import org.opencms.file.types.Messages;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.OpenCms;

public class CmsResourceTypePlain
extends A_CmsResourceType {
    private static boolean m_staticFrozen;
    private static int m_staticTypeId;
    private static final int RESOURCE_TYPE_ID = 1;
    private static final String RESOURCE_TYPE_NAME = "plain";
    protected CmsJspLoader m_jspLoader;

    public CmsResourceTypePlain() {
        this.m_typeId = 1;
        this.m_typeName = RESOURCE_TYPE_NAME;
    }

    public static int getStaticTypeId() {
        return m_staticTypeId;
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    @Override
    public void chtype(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.chtype(cms, securityManager, resource, type);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void deleteResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.deleteResource(cms, securityManager, resource, siblingMode);
        this.removeReferencingFromCache(references);
    }

    @Override
    public String getCachePropertyDefault() {
        return "always;";
    }

    @Override
    public int getLoaderId() {
        return 1;
    }

    @Override
    public void initConfiguration(String name, String id, String className) throws CmsConfigurationException {
        if (OpenCms.getRunLevel() > 2 && m_staticFrozen) {
            throw new CmsConfigurationException(Messages.get().container("ERR_CONFIG_FROZEN_3", this.getClass().getName(), CmsResourceTypePlain.getStaticTypeName(), new Integer(CmsResourceTypePlain.getStaticTypeId())));
        }
        if (!RESOURCE_TYPE_NAME.equals(name)) {
            throw new CmsConfigurationException(Messages.get().container("ERR_INVALID_RESTYPE_CONFIG_NAME_3", this.getClass().getName(), RESOURCE_TYPE_NAME, name));
        }
        m_staticFrozen = true;
        super.initConfiguration(RESOURCE_TYPE_NAME, id, className);
        m_staticTypeId = this.m_typeId;
    }

    @Override
    public void initialize(CmsObject cms) {
        super.initialize(cms);
        try {
            this.m_jspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    @Override
    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.moveResource(cms, securityManager, resource, destination);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void replaceResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.replaceResource(cms, securityManager, resource, type, content, properties);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void restoreResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, int version) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.restoreResource(cms, securityManager, resource, version);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateExpired(cms, securityManager, resource, dateExpired, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateLastModified(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateLastModified, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateLastModified(cms, securityManager, resource, dateLastModified, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.setDateReleased(cms, securityManager, resource, dateReleased, recursive);
        this.removeReferencingFromCache(references);
    }

    @Override
    public void undoChanges(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        super.undoChanges(cms, securityManager, resource, mode);
        this.removeReferencingFromCache(references);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        Set<String> references = this.getReferencingStrongLinks(cms, resource);
        CmsFile file = super.writeFile(cms, securityManager, resource);
        this.removeReferencingFromCache(references);
        return file;
    }

    protected Set<String> getReferencingStrongLinks(CmsObject cms, CmsResource resource) throws CmsException {
        HashSet<String> references = new HashSet<String>();
        if (this.m_jspLoader == null) {
            return references;
        }
        this.m_jspLoader.getReferencingStrongLinks(cms, resource, references);
        return references;
    }

    protected void removeReferencingFromCache(Set<String> references) {
        if (this.m_jspLoader != null) {
            this.m_jspLoader.removeFromCache(references, false);
        }
    }
}

