/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsSubscriptionReadMode;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.I_CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsSubscriptionCollector
extends A_CmsResourceCollector {
    public static final String PARAM_KEY_CURRENTUSER = "currentuser";
    public static final String PARAM_KEY_DAYSFROM = "daysfrom";
    public static final String PARAM_KEY_DAYSTO = "daysto";
    public static final String PARAM_KEY_GROUPS = "groups";
    public static final String PARAM_KEY_INCLUDEGROUPS = "includegroups";
    public static final String PARAM_KEY_INCLUDESUBFOLDERS = "includesubfolders";
    public static final String PARAM_KEY_MODE = "mode";
    public static final String PARAM_KEY_RESOURCE = "resource";
    public static final String PARAM_KEY_USER = "user";
    private static final String[] COLLECTORS = new String[]{"allVisited", "allSubscribed", "allSubscribedDeleted"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));
    private static final Log LOG = CmsLog.getLog(CmsSubscriptionCollector.class);

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.getVisitedResources(cms, param);
            }
            case 1: {
                return this.getSubscribedResources(cms, param);
            }
            case 2: {
                return this.getSubscribedDeletedResources(cms, param);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List<CmsResource> getSubscribedDeletedResources(CmsObject cms, String param) throws CmsException {
        Map<String, String> params = this.getParameters(param);
        CmsSubscriptionFilter filter = this.getSubscriptionFilter(cms, params);
        String parentPath = filter.getParentPath();
        if (CmsStringUtil.isNotEmpty(parentPath)) {
            parentPath = cms.getRequestContext().removeSiteRoot(parentPath);
        }
        List<I_CmsHistoryResource> deletedResources = OpenCms.getSubscriptionManager().readSubscribedDeletedResources(cms, filter.getUser(), Boolean.valueOf(params.get(PARAM_KEY_INCLUDEGROUPS)), parentPath, filter.isIncludeSubFolders(), filter.getFromDate());
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(deletedResources.size());
        for (I_CmsHistoryResource deletedResource : deletedResources) {
            result.add((CmsResource)((Object)deletedResource));
        }
        return result;
    }

    protected List<CmsResource> getSubscribedResources(CmsObject cms, String param) throws CmsException {
        List<CmsResource> result = OpenCms.getSubscriptionManager().readSubscribedResources(cms, this.getSubscriptionFilter(cms, param));
        Collections.sort(result, I_CmsResource.COMPARE_DATE_LAST_MODIFIED);
        return result;
    }

    protected CmsSubscriptionFilter getSubscriptionFilter(CmsObject cms, Map<String, String> params) throws CmsException {
        CmsSubscriptionFilter filter = new CmsSubscriptionFilter();
        this.initVisitedByFilter(filter, cms, params, false);
        if (params.containsKey(PARAM_KEY_MODE)) {
            String modeName = params.get(PARAM_KEY_MODE);
            filter.setMode(CmsSubscriptionReadMode.modeForName(modeName));
        }
        if (params.containsKey(PARAM_KEY_GROUPS)) {
            List<String> groupNames = CmsStringUtil.splitAsList(params.get(PARAM_KEY_GROUPS), ',', true);
            for (String groupName : groupNames) {
                try {
                    CmsGroup group = cms.readGroup(groupName);
                    filter.addGroup(group);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", "groups=" + params.get(PARAM_KEY_GROUPS)));
                    throw e;
                }
            }
        }
        boolean includeUserGroups = Boolean.valueOf(params.get(PARAM_KEY_INCLUDEGROUPS));
        if (filter.getGroups().isEmpty() && includeUserGroups) {
            String userName = null;
            userName = filter.getUser() != null ? filter.getUser().getName() : cms.getRequestContext().getCurrentUser().getName();
            filter.setGroups(cms.getGroupsOfUser(userName, false));
        }
        return filter;
    }

    protected CmsSubscriptionFilter getSubscriptionFilter(CmsObject cms, String param) throws CmsException {
        return this.getSubscriptionFilter(cms, this.getParameters(param));
    }

    protected CmsVisitedByFilter getVisitedByFilter(CmsObject cms, String param) throws CmsException {
        CmsVisitedByFilter filter = new CmsVisitedByFilter();
        Map<String, String> params = this.getParameters(param);
        this.initVisitedByFilter(filter, cms, params, true);
        return filter;
    }

    protected List<CmsResource> getVisitedResources(CmsObject cms, String param) throws CmsException {
        List<CmsResource> result = OpenCms.getSubscriptionManager().readResourcesVisitedBy(cms, this.getVisitedByFilter(cms, param));
        Collections.sort(result, I_CmsResource.COMPARE_DATE_LAST_MODIFIED);
        return result;
    }

    private long getCalculatedTime(long baseTime, String deltaDays, String key, long defaultTime) {
        try {
            long days = Long.parseLong(deltaDays);
            long delta = 86400000L * days;
            long result = baseTime - delta;
            if (result >= 0L) {
                return result;
            }
        }
        catch (NumberFormatException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", key + "=" + deltaDays));
        }
        return defaultTime;
    }

    private Map<String, String> getParameters(String param) {
        if (CmsStringUtil.isNotEmpty(param)) {
            return CmsStringUtil.splitAsMap(param, "|", "=");
        }
        return Collections.emptyMap();
    }

    private void initVisitedByFilter(CmsVisitedByFilter filter, CmsObject cms, Map<String, String> params, boolean forceSetUser) throws CmsException {
        if (params.containsKey(PARAM_KEY_USER)) {
            try {
                CmsUser user = cms.readUser(params.get(PARAM_KEY_USER));
                filter.setUser(user);
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_USER_1", params.get(PARAM_KEY_USER)));
                throw e;
            }
        }
        boolean setCurrentUser = Boolean.valueOf(params.get(PARAM_KEY_CURRENTUSER));
        if (filter.getUser() == null && (forceSetUser || setCurrentUser)) {
            filter.setUser(cms.getRequestContext().getCurrentUser());
        }
        long currentTime = System.currentTimeMillis();
        if (params.containsKey(PARAM_KEY_DAYSFROM)) {
            filter.setFromDate(this.getCalculatedTime(currentTime, params.get(PARAM_KEY_DAYSFROM), PARAM_KEY_DAYSFROM, 0L));
        }
        if (params.containsKey(PARAM_KEY_DAYSTO)) {
            filter.setToDate(this.getCalculatedTime(currentTime, params.get(PARAM_KEY_DAYSTO), PARAM_KEY_DAYSTO, Long.MAX_VALUE));
        }
        if (params.containsKey(PARAM_KEY_RESOURCE)) {
            try {
                CmsResource resource = cms.readResource(params.get(PARAM_KEY_RESOURCE));
                filter.setParentResource(resource);
                if (params.containsKey(PARAM_KEY_INCLUDESUBFOLDERS)) {
                    boolean includeSubFolders = Boolean.valueOf(params.get(PARAM_KEY_INCLUDESUBFOLDERS));
                    filter.setIncludeSubfolders(includeSubFolders);
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_COLLECTOR_PARAM_INVALID_1", "resource=" + params.get(PARAM_KEY_RESOURCE)));
                throw e;
            }
        }
    }
}

