/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.CmsPriorityDateResourceComparator;
import org.opencms.file.collectors.CmsPriorityTitleResourceComparator;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;

public class CmsPriorityResourceCollector
extends A_CmsResourceCollector {
    public static final int PRIORITY_STANDARD = 3;
    public static final String PROPERTY_CHANNEL = "collector.channel";
    public static final String PROPERTY_PRIORITY = "collector.priority";
    private static final String[] COLLECTORS = new String[]{"allInFolderPriorityDateAsc", "allInSubTreePriorityDateAsc", "allInFolderPriorityDateDesc", "allInSubTreePriorityDateDesc", "allInFolderPriorityTitleDesc", "allInSubTreePriorityTitleDesc", "allMappedToUriPriorityDateAsc", "allMappedToUriPriorityDateDesc"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[1];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 2: 
            case 4: {
                return this.getCreateInFolder(cms, param);
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[1];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 2: 
            case 4: {
                return param;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsException, CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.allInFolderPriorityDate(cms, param, false, true);
            }
            case 1: {
                return this.allInFolderPriorityDate(cms, param, true, true);
            }
            case 2: {
                return this.allInFolderPriorityDate(cms, param, false, false);
            }
            case 3: {
                return this.allInFolderPriorityDate(cms, param, true, false);
            }
            case 4: {
                return this.allInFolderPriorityTitle(cms, param, false);
            }
            case 5: {
                return this.allInFolderPriorityTitle(cms, param, true);
            }
            case 6: {
                return this.allMappedToUriPriorityDate(cms, param, true);
            }
            case 7: {
                return this.allMappedToUriPriorityDate(cms, param, false);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List<CmsResource> allInFolderPriorityDate(CmsObject cms, String param, boolean tree, boolean asc) throws CmsException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        CmsPriorityDateResourceComparator comparator = new CmsPriorityDateResourceComparator(cms, asc);
        Collections.sort(result, comparator);
        return this.shrinkToFit(result, data.getCount());
    }

    protected List<CmsResource> allInFolderPriorityTitle(CmsObject cms, String param, boolean tree) throws CmsException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        CmsPriorityTitleResourceComparator comparator = new CmsPriorityTitleResourceComparator(cms);
        Collections.sort(result, comparator);
        return this.shrinkToFit(result, data.getCount());
    }

    protected List<CmsResource> allMappedToUriPriorityDate(CmsObject cms, String param, boolean asc) throws CmsException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, true);
        ArrayList<CmsResource> mapped = new ArrayList<CmsResource>();
        for (CmsResource res : result) {
            CmsProperty prop = cms.readPropertyObject(res, PROPERTY_CHANNEL, false);
            if (prop.isNullProperty() || !CmsProject.isInsideProject(prop.getValueList(), cms.getRequestContext().getSiteRoot() + cms.getRequestContext().getUri())) continue;
            mapped.add(res);
        }
        if (mapped.isEmpty()) {
            return mapped;
        }
        CmsPriorityDateResourceComparator comparator = new CmsPriorityDateResourceComparator(cms, asc);
        Collections.sort(mapped, comparator);
        return this.shrinkToFit(mapped, data.getCount());
    }
}

