/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsDateResourceComparator;
import org.opencms.file.collectors.CmsExtendedCollectorData;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;

public class CmsDateResourceCollector
extends A_CmsResourceCollector {
    private static final String[] COLLECTORS = new String[]{"allInFolderDateDesc", "allInFolderDateAsc", "allInSubTreeDateDesc", "allInSubTreeDateAsc"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                return this.getCreateInFolder(cms, new CmsExtendedCollectorData(param));
            }
            case 2: 
            case 3: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                return param;
            }
            case 2: 
            case 3: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.allInFolderDate(cms, param, false, false);
            }
            case 1: {
                return this.allInFolderDate(cms, param, false, true);
            }
            case 2: {
                return this.allInFolderDate(cms, param, true, false);
            }
            case 3: {
                return this.allInFolderDate(cms, param, true, true);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List<CmsResource> allInFolderDate(CmsObject cms, String param, boolean tree, boolean asc) throws CmsException {
        CmsExtendedCollectorData data = new CmsExtendedCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        List<String> dateIdentifiers = data.getAdditionalParams();
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        CmsDateResourceComparator comparator = new CmsDateResourceComparator(cms, dateIdentifiers, asc);
        Collections.sort(result, comparator);
        return this.shrinkToFit(result, data.getCount());
    }
}

