/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import org.apache.commons.logging.Log;
import org.opencms.file.collectors.Messages;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsCollectorData {
    private static final Log LOG = CmsLog.getLog(CmsCollectorData.class);
    private int m_count;
    private String m_fileName;
    private int m_type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CmsCollectorData(String data) {
        if (data == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_EMPTY_0"));
        }
        int pos1 = data.indexOf(124);
        if (pos1 == -1) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_INVALID_1", data));
        }
        int pos2 = data.indexOf(124, pos1 + 1);
        if (pos2 == -1) {
            pos2 = data.length();
            this.m_count = 0;
        } else {
            this.m_count = Integer.valueOf(data.substring(pos2 + 1));
        }
        this.m_fileName = data.substring(0, pos1);
        String type = data.substring(pos1 + 1, pos2);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(type)) {
            try {
                I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(type);
                this.m_type = resourceType.getTypeId();
                return;
            }
            catch (CmsLoaderException e) {
                int typeInt = Integer.valueOf(type);
                try {
                    I_CmsResourceType resourceType = OpenCms.getResourceManager().getResourceType(typeInt);
                    this.m_type = resourceType.getTypeId();
                    if (!LOG.isWarnEnabled()) return;
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_RESTYPE_INTID_2", resourceType.getTypeName(), new Integer(resourceType.getTypeId())));
                    return;
                }
                catch (CmsLoaderException e1) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_UNKNOWN_RESTYPE_1", type), (Throwable)e1);
                }
            }
        } else {
            this.m_type = -1;
        }
    }

    protected CmsCollectorData() {
    }

    public int getCount() {
        return this.m_count;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public int getType() {
        return this.m_type;
    }

    public void setFileName(String fileName) {
        this.m_fileName = fileName;
    }

    public void setType(int type) {
        this.m_type = type;
    }

    protected void setCount(int count) {
        this.m_count = count;
    }
}

