/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbException;
import org.opencms.db.CmsDbPool;
import org.opencms.db.CmsDriverManager;
import org.opencms.main.CmsLog;

public class CmsSqlManager {
    private static final Log LOG = CmsLog.getLog(CmsSqlManager.class);
    private CmsDriverManager m_driverManager;

    protected CmsSqlManager() {
    }

    protected CmsSqlManager(CmsDriverManager driverManager) {
        this.m_driverManager = driverManager;
    }

    public int getActiveConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getActiveConnections(dbPoolUrl);
    }

    public Connection getConnection(String dbPoolName) throws SQLException {
        return this.getConnectionByUrl("jdbc:apache:commons:dbcp:opencms:" + dbPoolName);
    }

    public Connection getConnectionByUrl(String dbPoolUrl) throws SQLException {
        long timer = System.currentTimeMillis();
        Connection con = DriverManager.getConnection(dbPoolUrl);
        if (LOG.isDebugEnabled() && (timer = System.currentTimeMillis() - timer) > 1000L) {
            LOG.debug((Object)("DriverManager.getConnection required " + timer + " milliseconds"));
        }
        return con;
    }

    public List<String> getDbPoolUrls() {
        return CmsDbPool.getDbPoolUrls(this.m_driverManager.getPropertyConfiguration());
    }

    public String getDefaultDbPoolName() {
        return CmsDbPool.getDefaultDbPoolName();
    }

    public int getIdleConnections(String dbPoolUrl) throws CmsDbException {
        return this.m_driverManager.getIdleConnections(dbPoolUrl);
    }
}

