/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.db.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.I_CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsUUID;

public class CmsPublishList
implements Externalizable {
    private static final Log LOG = CmsLog.getLog(CmsPublishList.class);
    private static final int NIL = -1;
    private static final long serialVersionUID = -2578909250462750927L;
    private static final int UUID_LENGTH = CmsUUID.getNullUUID().toByteArray().length;
    private List<CmsResource> m_deletedFolderList;
    private List<CmsUUID> m_deletedFolderUUIDs;
    private List<CmsResource> m_directPublishResources;
    private List<CmsUUID> m_directPublishResourceUUIDs;
    private List<CmsResource> m_fileList;
    private List<CmsUUID> m_fileUUIDs;
    private List<CmsResource> m_folderList;
    private List<CmsUUID> m_folderUUIDs;
    private boolean m_isUserPublishList;
    private boolean m_needsRevive;
    private CmsUUID m_projectId;
    private CmsUUID m_publishHistoryId;
    private boolean m_publishSiblings;
    private boolean m_publishSubResources;

    public CmsPublishList() {
    }

    public CmsPublishList(boolean all, List<CmsResource> directPublishResources, boolean directPublishSiblings) {
        this(null, directPublishResources, directPublishSiblings, false, true);
    }

    public CmsPublishList(CmsProject project) {
        this(project, null, false, true, false);
    }

    public CmsPublishList(CmsResource directPublishResource, boolean publishSiblings) {
        this(null, Collections.singletonList(directPublishResource), publishSiblings, true, false);
    }

    public CmsPublishList(List<CmsResource> directPublishResources, boolean publishSiblings) {
        this(null, directPublishResources, publishSiblings, true, false);
    }

    public CmsPublishList(List<CmsResource> directPublishResources, boolean publishSiblings, boolean publishSubResources) {
        this(null, directPublishResources, publishSiblings, publishSubResources, false);
    }

    private CmsPublishList(CmsProject project, List<CmsResource> directPublishResources, boolean publishSiblings, boolean publishSubResources, boolean all) {
        this.m_fileList = new ArrayList<CmsResource>();
        this.m_folderList = new ArrayList<CmsResource>();
        this.m_deletedFolderList = new ArrayList<CmsResource>();
        this.m_publishHistoryId = new CmsUUID();
        this.m_publishSiblings = publishSiblings;
        this.m_publishSubResources = publishSubResources;
        CmsUUID cmsUUID = this.m_projectId = project != null ? project.getUuid() : null;
        if (directPublishResources != null) {
            this.m_directPublishResources = !all ? Collections.unmodifiableList(CmsFileUtil.removeRedundantResources(directPublishResources)) : Collections.unmodifiableList(directPublishResources);
        }
    }

    public List<CmsResource> getAllResources() {
        ArrayList<CmsResource> all = new ArrayList<CmsResource>();
        all.addAll(this.m_folderList);
        all.addAll(this.m_fileList);
        all.addAll(this.m_deletedFolderList);
        Collections.sort(all, I_CmsResource.COMPARE_ROOT_PATH);
        return Collections.unmodifiableList(all);
    }

    public List<CmsResource> getDeletedFolderList() {
        if (this.m_needsRevive) {
            return null;
        }
        return this.m_deletedFolderList;
    }

    public List<CmsResource> getDirectPublishResources() {
        if (this.m_needsRevive) {
            return null;
        }
        return this.m_directPublishResources;
    }

    public List<CmsResource> getFileList() {
        if (this.m_needsRevive) {
            return null;
        }
        return Collections.unmodifiableList(this.m_fileList);
    }

    public List<CmsResource> getFolderList() {
        if (this.m_needsRevive) {
            return null;
        }
        return Collections.unmodifiableList(this.m_folderList);
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public CmsUUID getPublishHistoryId() {
        return this.m_publishHistoryId;
    }

    public List<CmsResource> getTopMovedFolders(CmsObject cms) throws CmsException {
        List<CmsResource> movedFolders = this.getMovedFolders(cms);
        List<CmsResource> result = this.getTopFolders(movedFolders);
        return result;
    }

    public boolean isDirectPublish() {
        return this.m_projectId == null;
    }

    public boolean isPublishSiblings() {
        return this.m_publishSiblings;
    }

    public boolean isPublishSubResources() {
        return this.m_publishSubResources;
    }

    public boolean isUserPublishList() {
        return this.m_isUserPublishList;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.m_publishHistoryId = this.internalReadUUID(in);
        this.m_projectId = this.internalReadUUID(in);
        if (this.m_projectId.isNullUUID()) {
            this.m_projectId = null;
        }
        this.m_publishSiblings = in.readInt() != 0;
        this.m_publishSubResources = in.readInt() != 0;
        this.m_directPublishResourceUUIDs = this.internalReadUUIDList(in);
        this.m_fileUUIDs = this.internalReadUUIDList(in);
        this.m_folderUUIDs = this.internalReadUUIDList(in);
        this.m_deletedFolderUUIDs = this.internalReadUUIDList(in);
        this.m_needsRevive = true;
    }

    public void revive(CmsObject cms) {
        if (this.m_needsRevive) {
            if (this.m_directPublishResourceUUIDs != null) {
                this.m_directPublishResources = this.internalReadResourceList(cms, this.m_directPublishResourceUUIDs);
            }
            if (this.m_fileUUIDs != null) {
                this.m_fileList = this.internalReadResourceList(cms, this.m_fileUUIDs);
            }
            if (this.m_folderUUIDs != null) {
                this.m_folderList = this.internalReadResourceList(cms, this.m_folderUUIDs);
            }
            if (this.m_deletedFolderUUIDs != null) {
                this.m_deletedFolderList = this.internalReadResourceList(cms, this.m_deletedFolderUUIDs);
            }
            this.m_needsRevive = false;
        }
    }

    public void setUserPublishList(boolean isUserPublishList) {
        this.m_isUserPublishList = isUserPublishList;
    }

    public int size() {
        if (this.m_needsRevive) {
            return 0;
        }
        return this.m_folderList.size() + this.m_fileList.size() + this.m_deletedFolderList.size();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("\n[\n");
        if (this.isDirectPublish()) {
            result.append("direct publish of resources: ").append(this.m_directPublishResources.toString()).append("\n");
        } else {
            result.append("publish of project: ").append(this.m_projectId).append("\n");
        }
        result.append("publish history ID: ").append(this.m_publishHistoryId.toString()).append("\n");
        result.append("resources: ").append(this.m_fileList.toString()).append("\n");
        result.append("folders: ").append(this.m_folderList.toString()).append("\n");
        result.append("deletedFolders: ").append(this.m_deletedFolderList.toString()).append("\n");
        result.append("]\n");
        return result.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Iterator<CmsResource> i;
        out.write(this.m_publishHistoryId.toByteArray());
        out.write(this.m_projectId != null ? this.m_projectId.toByteArray() : CmsUUID.getNullUUID().toByteArray());
        out.writeInt(this.m_publishSiblings ? 1 : 0);
        out.writeInt(this.m_publishSubResources ? 1 : 0);
        if (this.m_directPublishResources != null) {
            out.writeInt(this.m_directPublishResources.size());
            i = this.m_directPublishResources.iterator();
            while (i.hasNext()) {
                out.write(i.next().getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_fileList != null) {
            out.writeInt(this.m_fileList.size());
            i = this.m_fileList.iterator();
            while (i.hasNext()) {
                out.write(i.next().getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_folderList != null) {
            out.writeInt(this.m_folderList.size());
            i = this.m_folderList.iterator();
            while (i.hasNext()) {
                out.write(i.next().getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
        if (this.m_deletedFolderList != null) {
            out.writeInt(this.m_deletedFolderList.size());
            i = this.m_deletedFolderList.iterator();
            while (i.hasNext()) {
                out.write(i.next().getStructureId().toByteArray());
            }
        } else {
            out.writeInt(-1);
        }
    }

    protected void add(CmsResource resource, boolean check) throws IllegalArgumentException {
        if (check && resource.getState().isUnchanged()) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_PUBLISH_UNCHANGED_RESOURCE_1", resource.getRootPath()));
        }
        if (resource.isFolder()) {
            if (resource.getState().isDeleted()) {
                if (!this.m_deletedFolderList.contains(resource)) {
                    this.m_deletedFolderList.add(resource);
                }
            } else if (!this.m_folderList.contains(resource)) {
                this.m_folderList.add(resource);
            }
        } else if (!this.m_fileList.contains(resource)) {
            this.m_fileList.add(resource);
        }
    }

    protected void addAll(Collection<CmsResource> resources, boolean check) throws IllegalArgumentException {
        Iterator<CmsResource> i = resources.iterator();
        while (i.hasNext()) {
            this.add(i.next(), check);
        }
    }

    protected CmsResource checkContainsSubResources(CmsObject cms, List<CmsResource> folders) throws CmsException {
        for (CmsResource folder : folders) {
            if (this.containsSubResources(cms, folder)) continue;
            return folder;
        }
        return null;
    }

    protected boolean containsResource(CmsResource res) {
        return this.m_deletedFolderList.contains(res) || this.m_folderList.contains(res) || this.m_fileList.contains(res);
    }

    protected boolean containsSubResources(CmsObject cms, CmsResource folder) throws CmsException {
        String folderPath = cms.getSitePath(folder);
        List<CmsResource> subResources = cms.readResources(folderPath, CmsResourceFilter.ALL, true);
        for (CmsResource resource : subResources) {
            if (this.containsResource(resource)) continue;
            return false;
        }
        return true;
    }

    protected List<CmsResource> getMissingSubResources(CmsObject cms, List<CmsResource> folders) throws CmsException {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsResource folder : folders) {
            String folderPath = cms.getSitePath(folder);
            List<CmsResource> subResources = cms.readResources(folderPath, CmsResourceFilter.ALL, true);
            for (CmsResource resource : subResources) {
                if (this.containsResource(resource)) continue;
                result.add(resource);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CmsResource> getMovedFolders(CmsObject cms) throws CmsException {
        CmsProject onlineProject = cms.readProject(CmsProject.ONLINE_PROJECT_ID);
        ArrayList<CmsResource> movedFolders = new ArrayList<CmsResource>();
        for (CmsResource folder : this.m_folderList) {
            if (!folder.getState().isChanged()) continue;
            CmsProject oldProject = cms.getRequestContext().getCurrentProject();
            boolean isMoved = false;
            try {
                cms.getRequestContext().setCurrentProject(onlineProject);
                CmsResource onlineResource = cms.readResource(folder.getStructureId());
                isMoved = !onlineResource.getRootPath().equals(folder.getRootPath());
            }
            catch (CmsVfsResourceNotFoundException e) {
            }
            finally {
                cms.getRequestContext().setCurrentProject(oldProject);
            }
            if (!isMoved) continue;
            movedFolders.add(folder);
        }
        return movedFolders;
    }

    protected List<CmsResource> getTopFolders(List<CmsResource> folders) {
        ArrayList<String> folderPaths = new ArrayList<String>();
        ArrayList<CmsResource> topFolders = new ArrayList<CmsResource>();
        HashMap<String, CmsResource> foldersByPath = new HashMap<String, CmsResource>();
        for (CmsResource folder : folders) {
            folderPaths.add(folder.getRootPath());
            foldersByPath.put(folder.getRootPath(), folder);
        }
        Collections.sort(folderPaths);
        HashSet topFolderPaths = new HashSet(folderPaths);
        for (int i = 0; i < folderPaths.size(); ++i) {
            for (int j = i + 1; j < folderPaths.size() && ((String)folderPaths.get(j)).startsWith((String)folderPaths.get(i)); ++j) {
                topFolderPaths.remove(folderPaths.get(j));
            }
        }
        for (String path : topFolderPaths) {
            topFolders.add((CmsResource)foldersByPath.get(path));
        }
        return topFolders;
    }

    protected void initialize() {
        if (this.m_folderList != null) {
            Collections.sort(this.m_folderList, I_CmsResource.COMPARE_ROOT_PATH);
        }
        if (this.m_fileList != null) {
            Collections.sort(this.m_fileList, I_CmsResource.COMPARE_ROOT_PATH);
        }
        if (this.m_deletedFolderList != null) {
            Collections.sort(this.m_deletedFolderList, I_CmsResource.COMPARE_ROOT_PATH);
            Collections.reverse(this.m_deletedFolderList);
        }
    }

    protected boolean remove(CmsResource resource) {
        boolean ret = this.m_fileList.remove(resource);
        ret |= this.m_folderList.remove(resource);
        return ret |= this.m_deletedFolderList.remove(resource);
    }

    private List<CmsResource> internalReadResourceList(CmsObject cms, List<CmsUUID> uuidList) {
        ArrayList<CmsResource> resList = new ArrayList<CmsResource>(uuidList.size());
        Iterator<CmsUUID> i = uuidList.iterator();
        while (i.hasNext()) {
            try {
                CmsResource res = cms.readResource(i.next(), CmsResourceFilter.ALL);
                resList.add(res);
            }
            catch (CmsException exc) {
                LOG.error((Object)exc.getLocalizedMessage(), (Throwable)exc);
            }
        }
        return resList;
    }

    private CmsUUID internalReadUUID(ObjectInput in) throws IOException {
        byte[] bytes = new byte[UUID_LENGTH];
        in.readFully(bytes, 0, UUID_LENGTH);
        return new CmsUUID(bytes);
    }

    private List<CmsUUID> internalReadUUIDList(ObjectInput in) throws IOException {
        ArrayList<CmsUUID> result = null;
        int i = in.readInt();
        if (i >= 0) {
            result = new ArrayList<CmsUUID>();
            while (i > 0) {
                result.add(this.internalReadUUID(in));
                --i;
            }
        }
        return result;
    }
}

