/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.userpublishlist.CmsUserPublishListEntry;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsUUID;

public class CmsLogToPublishListChangeConverter {
    private Map<CmsPair<CmsUUID, CmsUUID>, Long> m_state = new HashMap<CmsPair<CmsUUID, CmsUUID>, Long>();

    public void add(CmsLogEntry entry) {
        CmsUUID userId = entry.getUserId();
        CmsUUID structureId = entry.getStructureId();
        if (userId == null || structureId == null) {
            return;
        }
        CmsPair<CmsUUID, CmsUUID> key = CmsPair.create(userId, structureId);
        if (this.isDeleting(entry)) {
            this.m_state.put(key, -1L);
        } else if (this.isChanging(entry)) {
            this.m_state.put(key, entry.getDate());
        }
    }

    protected boolean isDeleting(CmsLogEntry entry) {
        return entry.getType().getId() <= 20;
    }

    protected boolean isChanging(CmsLogEntry entry) {
        return entry.getType().getId() > 20;
    }

    public List<CmsUserPublishListEntry> getPublishListAdditions() {
        return this.filterEntries(Action.update);
    }

    private Action getAction(long value) {
        if (value == -1L) {
            return Action.delete;
        }
        return Action.update;
    }

    public List<CmsUserPublishListEntry> filterEntries(Action action) {
        ArrayList<CmsUserPublishListEntry> result = new ArrayList<CmsUserPublishListEntry>();
        for (Map.Entry<CmsPair<CmsUUID, CmsUUID>, Long> entry : this.m_state.entrySet()) {
            CmsPair<CmsUUID, CmsUUID> key = entry.getKey();
            Long value = entry.getValue();
            Action valueAction = this.getAction(value);
            if (!valueAction.equals((Object)action)) continue;
            result.add(new CmsUserPublishListEntry(key.getFirst(), key.getSecond(), value));
        }
        return result;
    }

    public List<CmsUserPublishListEntry> getPublishListDeletions() {
        return this.filterEntries(Action.delete);
    }

    private static enum Action {
        delete,
        update;

    }
}

