/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.configuration.Messages;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsLog;
import org.opencms.util.A_CmsModeStringEnumeration;
import org.opencms.util.CmsStringUtil;

public class CmsDefaultUserSettings
extends CmsUserSettings {
    private static final String[] BUTTON_STYLES = new String[]{"image", "textimage", "text"};
    public static final List<String> BUTTON_STYLES_LIST = Collections.unmodifiableList(Arrays.asList(BUTTON_STYLES));
    public static final CmsPublishRelatedResourcesMode PUBLISH_RELATED_RESOURCES_MODE_FALSE = CmsPublishRelatedResourcesMode.MODE_FALSE;
    public static final CmsPublishRelatedResourcesMode PUBLISH_RELATED_RESOURCES_MODE_FORCE = CmsPublishRelatedResourcesMode.MODE_FORCE;
    public static final CmsPublishRelatedResourcesMode PUBLISH_RELATED_RESOURCES_MODE_TRUE = CmsPublishRelatedResourcesMode.MODE_TRUE;
    public static final String PUBLISHBUTTON_SHOW_ALWAYS = "always";
    public static final String PUBLISHBUTTON_SHOW_AUTO = "auto";
    public static final String PUBLISHBUTTON_SHOW_NEVER = "never";
    private static final int BUTTONSTYLE_TEXTIMAGE = 1;
    private static final String COPYMODE_PRESERVE = "preservesiblings";
    private static final String COPYMODE_RESOURCE = "createresource";
    private static final String COPYMODE_SIBLING = "createsibling";
    private static final String DELETEMODE_DELETE = "deletesiblings";
    private static final String DELETEMODE_PRESERVE = "preservesiblings";
    private static final Log LOG = CmsLog.getLog(CmsDefaultUserSettings.class);
    private static final String PUBLISHMODE_ONLYRESOURCE = "onlyresource";
    private static final String PUBLISHMODE_SIBLINGS = "allsiblings";
    private boolean m_allowBrokenRelations = true;
    private CmsPublishRelatedResourcesMode m_publishRelatedResourcesMode;
    private SubsitemapCreationMode m_subsitemapCreationMode;

    public String getDialogCopyFileModeString() {
        if (this.getDialogCopyFileMode() == CmsResource.COPY_AS_NEW) {
            return COPYMODE_RESOURCE;
        }
        return COPYMODE_SIBLING;
    }

    public String getDialogCopyFolderModeString() {
        if (this.getDialogCopyFolderMode() == CmsResource.COPY_AS_NEW) {
            return COPYMODE_RESOURCE;
        }
        if (this.getDialogCopyFolderMode() == CmsResource.COPY_AS_SIBLING) {
            return COPYMODE_SIBLING;
        }
        return "preservesiblings";
    }

    public String getDialogDeleteFileModeString() {
        if (this.getDialogDeleteFileMode() == CmsResource.DELETE_REMOVE_SIBLINGS) {
            return DELETEMODE_DELETE;
        }
        return "preservesiblings";
    }

    public String getDialogExpandInheritedPermissionsString() {
        return String.valueOf(this.getDialogExpandInheritedPermissions());
    }

    public String getDialogExpandUserPermissionsString() {
        return String.valueOf(this.getDialogExpandUserPermissions());
    }

    public String getDialogPermissionsInheritOnFolderString() {
        return String.valueOf(this.getDialogPermissionsInheritOnFolder());
    }

    public String getDialogPublishSiblingsString() {
        if (this.getDialogPublishSiblings()) {
            return PUBLISHMODE_SIBLINGS;
        }
        return PUBLISHMODE_ONLYRESOURCE;
    }

    public String getDialogShowExportSettingsString() {
        return String.valueOf(this.getDialogShowExportSettings());
    }

    public String getDialogShowLockString() {
        return String.valueOf(this.getDialogShowLock());
    }

    public String getDirectEditButtonStyleString() {
        return BUTTON_STYLES[this.getDirectEditButtonStyle()];
    }

    public String getEditorButtonStyleString() {
        return BUTTON_STYLES[this.getEditorButtonStyle()];
    }

    public String getExplorerButtonStyleString() {
        return BUTTON_STYLES[this.getExplorerButtonStyle()];
    }

    public String getListAllProjectsString() {
        return String.valueOf(this.getShowPublishNotification());
    }

    public CmsPublishRelatedResourcesMode getPublishRelatedResources() {
        return this.m_publishRelatedResourcesMode;
    }

    public String getRestrictExplorerViewString() {
        return String.valueOf(this.getRestrictExplorerView());
    }

    public String getShowExplorerFileDateCreated() {
        return this.getExplorerSetting(1024);
    }

    public String getShowExplorerFileDateExpired() {
        return this.getExplorerSetting(8192);
    }

    public String getShowExplorerFileDateLastModified() {
        return this.getExplorerSetting(4);
    }

    public String getShowExplorerFileDateReleased() {
        return this.getExplorerSetting(4096);
    }

    public String getShowExplorerFileLockedBy() {
        return this.getExplorerSetting(256);
    }

    public String getShowExplorerFileNavText() {
        return this.getExplorerSetting(64);
    }

    public String getShowExplorerFilePermissions() {
        return this.getExplorerSetting(128);
    }

    public String getShowExplorerFileSize() {
        return this.getExplorerSetting(8);
    }

    public String getShowExplorerFileState() {
        return this.getExplorerSetting(16);
    }

    public String getShowExplorerFileTitle() {
        return this.getExplorerSetting(1);
    }

    public String getShowExplorerFileType() {
        return this.getExplorerSetting(2);
    }

    public String getShowExplorerFileUserCreated() {
        return this.getExplorerSetting(32);
    }

    public String getShowExplorerFileUserLastModified() {
        return this.getExplorerSetting(2048);
    }

    public String getShowFileUploadButtonString() {
        return String.valueOf(this.getShowFileUploadButton());
    }

    public String getShowPublishNotificationString() {
        return String.valueOf(this.getShowPublishNotification());
    }

    public SubsitemapCreationMode getSubsitemapCreationMode() {
        return this.getSubsitemapCreationMode(SubsitemapCreationMode.convert);
    }

    public SubsitemapCreationMode getSubsitemapCreationMode(SubsitemapCreationMode defaultValue) {
        if (this.m_subsitemapCreationMode != null) {
            return this.m_subsitemapCreationMode;
        }
        return defaultValue;
    }

    public String getWorkplaceButtonStyleString() {
        return BUTTON_STYLES[this.getWorkplaceButtonStyle()];
    }

    public boolean isAllowBrokenRelations() {
        return this.m_allowBrokenRelations;
    }

    public void setAllowBrokenRelations(String allowBrokenRelations) {
        this.m_allowBrokenRelations = Boolean.valueOf(allowBrokenRelations);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key(this.m_allowBrokenRelations ? "INIT_RELATION_DELETION_ENABLED_0" : "INIT_RELATION_DELETION_DISABLED_0"));
        }
    }

    public void setDialogCopyFileMode(String mode) {
        CmsResource.CmsResourceCopyMode copyMode = CmsResource.COPY_AS_NEW;
        if (mode.equalsIgnoreCase(COPYMODE_SIBLING)) {
            copyMode = CmsResource.COPY_AS_SIBLING;
        }
        this.setDialogCopyFileMode(copyMode);
    }

    public void setDialogCopyFolderMode(String mode) {
        CmsResource.CmsResourceCopyMode copyMode = CmsResource.COPY_AS_NEW;
        if (mode.equalsIgnoreCase(COPYMODE_SIBLING)) {
            copyMode = CmsResource.COPY_AS_SIBLING;
        } else if (mode.equalsIgnoreCase("preservesiblings")) {
            copyMode = CmsResource.COPY_PRESERVE_SIBLING;
        }
        this.setDialogCopyFolderMode(copyMode);
    }

    public void setDialogDeleteFileMode(String mode) {
        CmsResource.CmsResourceDeleteMode deleteMode = CmsResource.DELETE_PRESERVE_SIBLINGS;
        if (mode.equalsIgnoreCase(DELETEMODE_DELETE)) {
            deleteMode = CmsResource.DELETE_REMOVE_SIBLINGS;
        }
        this.setDialogDeleteFileMode(deleteMode);
    }

    public void setDialogExpandInheritedPermissions(String dialogExpandInheritedPermissions) {
        this.setDialogExpandInheritedPermissions(Boolean.valueOf(dialogExpandInheritedPermissions));
    }

    public void setDialogExpandUserPermissions(String dialogExpandUserPermissions) {
        this.setDialogExpandUserPermissions(Boolean.valueOf(dialogExpandUserPermissions));
    }

    public void setDialogPermissionsInheritOnFolder(String dialogPermissionsInheritOnFolder) {
        this.setDialogPermissionsInheritOnFolder(Boolean.valueOf(dialogPermissionsInheritOnFolder));
    }

    public void setDialogPublishSiblings(String mode) {
        boolean publishSiblings = false;
        if (mode.equalsIgnoreCase(PUBLISHMODE_SIBLINGS)) {
            publishSiblings = true;
        }
        this.setDialogPublishSiblings(publishSiblings);
    }

    public void setDirectEditButtonStyle(String buttonstyle) {
        int buttonstyleValue = 1;
        try {
            if (buttonstyle != null) {
                buttonstyleValue = BUTTON_STYLES_LIST.indexOf(buttonstyle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDirectEditButtonStyle(buttonstyleValue);
    }

    public void setEditorButtonStyle(String buttonstyle) {
        int buttonstyleValue = 1;
        try {
            if (buttonstyle != null) {
                buttonstyleValue = BUTTON_STYLES_LIST.indexOf(buttonstyle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setEditorButtonStyle(buttonstyleValue);
    }

    public void setExplorerButtonStyle(String buttonstyle) {
        int buttonstyleValue = 1;
        try {
            if (buttonstyle != null) {
                buttonstyleValue = BUTTON_STYLES_LIST.indexOf(buttonstyle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setExplorerButtonStyle(buttonstyleValue);
    }

    public void setExplorerFileEntries(String entries) {
        try {
            this.setExplorerFileEntries(Integer.parseInt(entries));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setListAllProjects(String listAllProjects) {
        this.setListAllProjects(Boolean.valueOf(listAllProjects));
    }

    public void setLocale(String locale) {
        this.setLocale(CmsLocaleManager.getLocale(locale));
    }

    public void setNewFolderCreateIndexPage(String booleanValue) {
        this.setNewFolderCreateIndexPage(Boolean.valueOf(booleanValue));
    }

    public void setNewFolderEditProperties(String booleanValue) {
        this.setNewFolderEditPropertes(Boolean.valueOf(booleanValue));
    }

    public void setPublishRelatedResourcesMode(String publishRelatedResourcesMode) {
        this.m_publishRelatedResourcesMode = CmsPublishRelatedResourcesMode.valueOf(publishRelatedResourcesMode);
        if (this.m_publishRelatedResourcesMode != null && CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_PUBLISH_RELATED_RESOURCES_MODE_1", this.m_publishRelatedResourcesMode.toString()));
        }
    }

    public void setRestrictExplorerView(String restrict) {
        this.setRestrictExplorerView(Boolean.valueOf(restrict));
    }

    public void setShowExplorerFileDateCreated(String show) {
        this.setShowExplorerFileDateCreated(Boolean.valueOf(show));
    }

    public void setShowExplorerFileDateExpired(String show) {
        this.setShowExplorerFileDateExpired(Boolean.valueOf(show));
    }

    public void setShowExplorerFileDateLastModified(String show) {
        this.setShowExplorerFileDateLastModified(Boolean.valueOf(show));
    }

    public void setShowExplorerFileDateReleased(String show) {
        this.setShowExplorerFileDateReleased(Boolean.valueOf(show));
    }

    public void setShowExplorerFileLockedBy(String show) {
        this.setShowExplorerFileLockedBy(Boolean.valueOf(show));
    }

    public void setShowExplorerFileNavText(String show) {
        this.setShowExplorerFileNavText(Boolean.valueOf(show));
    }

    public void setShowExplorerFilePermissions(String show) {
        this.setShowExplorerFilePermissions(Boolean.valueOf(show));
    }

    public void setShowExplorerFileSize(String show) {
        this.setShowExplorerFileSize(Boolean.valueOf(show));
    }

    public void setShowExplorerFileState(String show) {
        this.setShowExplorerFileState(Boolean.valueOf(show));
    }

    public void setShowExplorerFileTitle(String show) {
        this.setShowExplorerFileTitle(Boolean.valueOf(show));
    }

    public void setShowExplorerFileType(String show) {
        this.setShowExplorerFileType(Boolean.valueOf(show));
    }

    public void setShowExplorerFileUserCreated(String show) {
        this.setShowExplorerFileUserCreated(Boolean.valueOf(show));
    }

    public void setShowExplorerFileUserLastModified(String show) {
        this.setShowExplorerFileUserLastModified(Boolean.valueOf(show));
    }

    public void setShowExportSettingsDialog(String mode) {
        this.setDialogShowExportSettings(Boolean.valueOf(mode));
    }

    public void setShowFileUploadButton(String flag) {
        this.setShowFileUploadButton(Boolean.valueOf(flag));
    }

    public void setShowLockDialog(String mode) {
        this.setDialogShowLock(Boolean.valueOf(mode));
    }

    public void setShowPublishNotification(String notification) {
        this.setShowPublishNotification(Boolean.valueOf(notification));
    }

    public void setShowUploadTypeDialog(String booleanValue) {
        this.setShowUploadTypeDialog(Boolean.valueOf(booleanValue));
    }

    public void setSubsitemapCreationMode(String mode) {
        try {
            this.m_subsitemapCreationMode = SubsitemapCreationMode.valueOf(mode);
        }
        catch (Exception e) {
            LOG.warn((Object)("Invalid value for subsitemap creation mode was ignored: " + mode));
        }
    }

    public void setWorkplaceButtonStyle(String buttonstyle) {
        int buttonstyleValue = 1;
        try {
            if (buttonstyle != null) {
                buttonstyleValue = BUTTON_STYLES_LIST.indexOf(buttonstyle);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setWorkplaceButtonStyle(buttonstyleValue);
    }

    public void setWorkplaceSearchViewStyle(String viewStyle) {
        this.setWorkplaceSearchViewStyle(CmsUserSettings.CmsSearchResultStyle.valueOf(viewStyle));
    }

    private String getExplorerSetting(int setting) {
        return String.valueOf((this.getExplorerSettings() & setting) > 0);
    }

    public static enum SubsitemapCreationMode {
        convert,
        createfolder;

    }

    public static final class CmsPublishRelatedResourcesMode
    extends A_CmsModeStringEnumeration {
        protected static final CmsPublishRelatedResourcesMode MODE_FALSE = new CmsPublishRelatedResourcesMode(CmsStringUtil.FALSE);
        protected static final CmsPublishRelatedResourcesMode MODE_FORCE = new CmsPublishRelatedResourcesMode("FORCE");
        protected static final CmsPublishRelatedResourcesMode MODE_TRUE = new CmsPublishRelatedResourcesMode(CmsStringUtil.TRUE);
        private static final long serialVersionUID = -2665888243460791770L;

        private CmsPublishRelatedResourcesMode(String mode) {
            super(mode);
        }

        public static CmsPublishRelatedResourcesMode valueOf(String publishRelatedResourcesMode) {
            if (publishRelatedResourcesMode == null) {
                return null;
            }
            if (publishRelatedResourcesMode.equalsIgnoreCase(MODE_FALSE.getMode())) {
                return MODE_FALSE;
            }
            if (publishRelatedResourcesMode.equalsIgnoreCase(MODE_TRUE.getMode())) {
                return MODE_TRUE;
            }
            if (publishRelatedResourcesMode.equalsIgnoreCase(MODE_FORCE.getMode())) {
                return MODE_FORCE;
            }
            return null;
        }
    }
}

