/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.publish.CmsPublishActionElement;
import org.opencms.ade.sitemap.ClientMessages;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.ade.sitemap.shared.rpc.I_CmsSitemapService;
import org.opencms.ade.upload.CmsUploadActionElement;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.CmsRpcException;
import org.opencms.main.OpenCms;

public class CmsSitemapActionElement
extends CmsGwtActionElement {
    public static final String CMS_MODULE_NAME = "org.opencms.ade.sitemap";
    public static final String GWT_MODULE_NAME = "sitemap";
    private CmsSitemapData m_sitemapData;

    public CmsSitemapActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    @Override
    public String export() throws Exception {
        StringBuffer sb = new StringBuffer();
        String prefetchedData = CmsSitemapActionElement.exportDictionary("org_opencms_ade_sitemap", I_CmsSitemapService.class.getMethod("prefetch", String.class), this.getSitemapData());
        sb.append(prefetchedData);
        sb.append(ClientMessages.get().export(this.getRequest()));
        sb.append(org.opencms.gwt.seo.ClientMessages.get().export(this.getRequest()));
        return sb.toString();
    }

    @Override
    public String exportAll() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(super.export(".vfsMode"));
        sb.append(this.export());
        sb.append(new CmsPublishActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(new CmsUploadActionElement(this.getJspContext(), this.getRequest(), this.getResponse()).export());
        sb.append(this.createNoCacheScript(GWT_MODULE_NAME, OpenCms.getModuleManager().getModule(CMS_MODULE_NAME).getVersion().toString()));
        return sb.toString();
    }

    public CmsSitemapData getSitemapData() {
        if (this.m_sitemapData == null) {
            try {
                this.m_sitemapData = CmsVfsSitemapService.prefetch(this.getRequest(), this.getCmsObject().getRequestContext().getUri());
            }
            catch (CmsRpcException cmsRpcException) {
                // empty catch block
            }
        }
        return this.m_sitemapData;
    }

    public String getTitle() {
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_EDITOR_TITLE_1", this.getCoreData().getUri());
    }
}

